/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JList;
import net.filebot.ui.transfer.ByteBufferTransferable;
import net.filebot.ui.transfer.ClipboardHandler;
import net.filebot.ui.transfer.TransferableExportHandler;
import net.filebot.vfs.MemoryFile;

class MemoryFileListExportHandler
implements TransferableExportHandler,
ClipboardHandler {
    MemoryFileListExportHandler() {
    }

    public boolean canExport(JComponent component) {
        JList list = (JList)component;
        return !list.isSelectionEmpty();
    }

    public List<MemoryFile> export(JComponent component) {
        JList list = (JList)component;
        return list.getSelectedValuesList().stream().map(MemoryFile.class::cast).collect(Collectors.toList());
    }

    @Override
    public int getSourceActions(JComponent component) {
        return this.canExport(component) ? 3 : 0;
    }

    @Override
    public Transferable createTransferable(JComponent component) {
        HashMap<String, ByteBuffer> vfs = new HashMap<String, ByteBuffer>();
        for (MemoryFile file : this.export(component)) {
            vfs.put(file.getName(), file.getData());
        }
        return new ByteBufferTransferable(vfs);
    }

    @Override
    public void exportToClipboard(JComponent component, Clipboard clip, int action) {
        clip.setContents(this.createTransferable(component), null);
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
    }
}

