/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle.upload;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.MediaTypes;
import net.filebot.ResourceManager;

class FileRenderer
extends DefaultTableCellRenderer {
    FileRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null) {
            File file = (File)value;
            this.setText(file.getName());
            this.setToolTipText(file.getPath());
            if (MediaTypes.SUBTITLE_FILES.accept(file)) {
                this.setIcon(ResourceManager.getIcon("file.subtitle"));
            } else if (MediaTypes.VIDEO_FILES.accept(file)) {
                this.setIcon(ResourceManager.getIcon("file.video"));
            }
            this.setForeground(table.getForeground());
        } else {
            this.setText("<Click to select video file>");
            this.setToolTipText(null);
            this.setIcon(null);
            this.setForeground(Color.LIGHT_GRAY);
        }
        return this;
    }
}

