/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle.upload;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.web.Movie;

class MovieRenderer
extends DefaultTableCellRenderer {
    private Icon icon;

    public MovieRenderer(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null) {
            Movie movie = (Movie)value;
            this.setText(movie.toString());
            this.setToolTipText(String.format("%s [tt%07d]", movie.toString(), movie.getImdbId()));
            this.setIcon(this.icon);
            this.setForeground(table.getForeground());
        } else {
            this.setText("<Click to select movie / series>");
            this.setToolTipText(null);
            this.setIcon(null);
            this.setForeground(Color.LIGHT_GRAY);
        }
        return this;
    }
}

