/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle.upload;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.filebot.Language;
import net.filebot.ui.subtitle.upload.Status;
import net.filebot.ui.subtitle.upload.SubtitleMapping;

class SubtitleGroup {
    private final SubtitleMapping[] mapping;

    public SubtitleGroup(List<SubtitleMapping> mapping) {
        this.mapping = mapping.toArray(new SubtitleMapping[mapping.size()]);
    }

    public void setState(Status status) {
        for (SubtitleMapping it : this.mapping) {
            it.setState(status);
        }
    }

    public boolean isUploadReady() {
        return Arrays.stream(this.mapping).allMatch(SubtitleMapping::isUploadReady);
    }

    public Object getIdentity() {
        return this.mapping[0].getIdentity();
    }

    public Language getLanguage() {
        return this.mapping[0].getLanguage();
    }

    public File[] getVideoFiles() {
        return (File[])Arrays.stream(this.mapping).map(SubtitleMapping::getVideo).toArray(File[]::new);
    }

    public File[] getSubtitleFiles() {
        return (File[])Arrays.stream(this.mapping).map(SubtitleMapping::getSubtitle).toArray(File[]::new);
    }

    public String toString() {
        return Arrays.asList(this.getIdentity(), this.getLanguage(), Arrays.asList(this.getVideoFiles()), Arrays.asList(this.getSubtitleFiles())).toString();
    }
}

