/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle.upload;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.WebServices;
import net.filebot.media.MediaDetection;
import net.filebot.ui.subtitle.upload.FileEditor;
import net.filebot.ui.subtitle.upload.FileRenderer;
import net.filebot.ui.subtitle.upload.LanguageEditor;
import net.filebot.ui.subtitle.upload.LanguageRenderer;
import net.filebot.ui.subtitle.upload.MovieEditor;
import net.filebot.ui.subtitle.upload.MovieRenderer;
import net.filebot.ui.subtitle.upload.Status;
import net.filebot.ui.subtitle.upload.StatusRenderer;
import net.filebot.ui.subtitle.upload.SubtitleGroup;
import net.filebot.ui.subtitle.upload.SubtitleMapping;
import net.filebot.ui.subtitle.upload.SubtitleMappingTableModel;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.EmptySelectionModel;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Movie;
import net.filebot.web.OpenSubtitlesClient;
import net.filebot.web.SearchResult;
import net.filebot.web.TheTVDBSeriesInfo;
import net.filebot.web.VideoHashSubtitleService;
import net.miginfocom.swing.MigLayout;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;

public class SubtitleUploadDialog
extends JDialog {
    private final JTable subtitleMappingTable;
    private final OpenSubtitlesClient database;
    private ExecutorService checkExecutorService = Executors.newSingleThreadExecutor();
    private ExecutorService uploadExecutorService;
    private final Pattern CDI_PATTERN = Pattern.compile("(?<!\\p{Alnum})CD\\D?(?<i>[1-9])(?!\\p{Digit})", 258);

    public SubtitleUploadDialog(OpenSubtitlesClient database, Window owner) {
        super(owner, "Upload Subtitles", Dialog.ModalityType.DOCUMENT_MODAL);
        this.database = database;
        this.subtitleMappingTable = this.createTable();
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new MigLayout("fill, insets dialog, nogrid, novisualpadding", "", "[fill][pref!]"));
        content.add((Component)new JScrollPane(this.subtitleMappingTable), "grow, wrap");
        content.add((Component)SwingUI.newButton("Upload", ResourceManager.getIcon("dialog.continue"), this::doUpload), "tag ok");
        content.add((Component)SwingUI.newButton("Close", ResourceManager.getIcon("dialog.cancel"), this::doClose), "tag cancel");
    }

    protected JTable createTable() {
        JTable table = new JTable(new SubtitleMappingTableModel());
        table.setDefaultRenderer(Movie.class, new MovieRenderer(this.database.getIcon()));
        table.setDefaultRenderer(File.class, new FileRenderer());
        table.setDefaultRenderer(Language.class, new LanguageRenderer());
        table.setDefaultRenderer(Status.class, new StatusRenderer());
        table.setRowHeight(28);
        table.setIntercellSpacing(new Dimension(5, 5));
        table.setBackground(Color.white);
        table.setAutoCreateRowSorter(true);
        table.setFillsViewportHeight(true);
        table.setSelectionModel(new EmptySelectionModel());
        table.setDefaultEditor(Movie.class, new MovieEditor(this.database));
        table.setDefaultEditor(File.class, new FileEditor());
        table.setDefaultEditor(Language.class, new LanguageEditor());
        return table;
    }

    public void setUploadPlan(Map<File, File> uploadPlan) {
        ArrayList<SubtitleMapping> mappings = new ArrayList<SubtitleMapping>(uploadPlan.size());
        for (Map.Entry<File, File> entry : uploadPlan.entrySet()) {
            File subtitle = entry.getKey();
            File video = entry.getValue();
            Locale locale = MediaDetection.guessLanguageFromSuffix(subtitle);
            Language language = Language.getLanguage(locale);
            mappings.add(new SubtitleMapping(subtitle, video, language));
        }
        this.subtitleMappingTable.setModel(new SubtitleMappingTableModel(mappings).onCheckPending(this::startChecking));
    }

    public void startChecking() {
        for (SubtitleMapping mapping : ((SubtitleMappingTableModel)this.subtitleMappingTable.getModel()).getData()) {
            if (!mapping.isCheckReady()) continue;
            this.checkExecutorService.submit(() -> this.runCheck(mapping));
        }
    }

    private int getCD(SubtitleMapping mapping) {
        int i = Integer.MIN_VALUE;
        for (File f : new File[]{mapping.getSubtitle(), mapping.getVideo()}) {
            Matcher m = this.CDI_PATTERN.matcher(f.getName());
            while (m.find()) {
                i = Integer.parseInt(m.group("i"));
            }
        }
        return i;
    }

    private List<SubtitleGroup> getUploadGroups(SubtitleMapping[] table) {
        return ((AbstractStreamEx)StreamEx.ofValues(StreamEx.of(table).groupingBy(SubtitleMapping::getGroup, LinkedHashMap::new, Collectors.toList())).flatMap(this::groupRunsByCD)).toList();
    }

    private Stream<SubtitleGroup> groupRunsByCD(Collection<SubtitleMapping> group) {
        return ((StreamEx)StreamEx.of(group).sortedBy(SubtitleMapping::getVideo)).groupRuns((m1, m2) -> this.getCD((SubtitleMapping)m1) + 1 == this.getCD((SubtitleMapping)m2)).map(SubtitleGroup::new);
    }

    private void runCheck(SubtitleMapping mapping) {
        try {
            block19: {
                if (mapping.getIdentity() == null && mapping.getVideo() != null) {
                    mapping.setState(Status.Checking);
                    VideoHashSubtitleService.CheckResult checkResult = this.database.checkSubtitle(mapping.getVideo(), mapping.getSubtitle());
                    if (checkResult.exists) {
                        mapping.setLanguage(Language.getLanguage(checkResult.language));
                    }
                }
                if (mapping.getLanguage() == null) {
                    mapping.setState(Status.Identifying);
                    try {
                        Locale locale = this.database.detectLanguage(FileUtilities.readFile(mapping.getSubtitle()));
                        mapping.setLanguage(Language.getLanguage(locale));
                    }
                    catch (Exception e) {
                        Logging.debug.log(Level.WARNING, "Failed to auto-detect language: " + e.getMessage());
                    }
                }
                if (mapping.getIdentity() == null && mapping.getVideo() != null) {
                    mapping.setState(Status.Identifying);
                    try {
                        if (MediaDetection.isEpisode(mapping.getVideo().getPath(), true)) {
                            List<String> seriesNames = MediaDetection.detectSeriesNames(Collections.singleton(mapping.getVideo()), false, Locale.ENGLISH);
                            for (String name : seriesNames) {
                                List<SearchResult> options = WebServices.TheTVDB.search(name, Locale.ENGLISH);
                                for (SearchResult entry : options) {
                                    TheTVDBSeriesInfo seriesInfo = WebServices.TheTVDB.getSeriesInfo(entry, Locale.ENGLISH);
                                    if (seriesInfo.getImdbId() == null) continue;
                                    int imdbId = MediaDetection.grepImdbId(seriesInfo.getImdbId()).iterator().next();
                                    mapping.setIdentity(WebServices.OpenSubtitles.getMovieDescriptor(new Movie(imdbId), Locale.ENGLISH));
                                    break block19;
                                }
                            }
                            break block19;
                        }
                        List<Movie> identity = MediaDetection.detectMovie(mapping.getVideo(), this.database, Locale.ENGLISH, true);
                        for (Movie it : identity) {
                            if (it.getImdbId() <= 0 && it.getTmdbId() > 0) {
                                it = WebServices.TheMovieDB.getMovieDescriptor(it, Locale.US);
                            }
                            if (it == null || it.getImdbId() <= 0) continue;
                            mapping.setIdentity(it);
                            break;
                        }
                    }
                    catch (Exception e) {
                        Logging.debug.log(Level.WARNING, "Failed to auto-detect movie: " + e.getMessage());
                    }
                }
            }
            if (mapping.getVideo() == null) {
                mapping.setState(Status.IllegalInput);
            } else if (mapping.getIdentity() == null || mapping.getLanguage() == null) {
                mapping.setState(Status.IdentificationRequired);
            } else {
                mapping.setState(Status.UploadReady);
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, e.getMessage(), e);
            mapping.setState(Status.CheckFailed);
        }
    }

    private void runUpload(SubtitleGroup group) {
        try {
            group.setState(Status.Uploading);
            this.database.uploadSubtitle(group.getIdentity(), group.getLanguage().getLocale(), group.getVideoFiles(), group.getSubtitleFiles());
            group.setState(Status.UploadComplete);
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, e.getMessage(), e);
            group.setState(Status.UploadFailed);
        }
    }

    public void doUpload(ActionEvent evt) {
        if (this.subtitleMappingTable.getCellEditor() != null) {
            this.subtitleMappingTable.getCellEditor().stopCellEditing();
        }
        if (this.uploadExecutorService != null && !this.uploadExecutorService.isTerminated()) {
            return;
        }
        this.uploadExecutorService = Executors.newSingleThreadExecutor();
        SubtitleMapping[] table = ((SubtitleMappingTableModel)this.subtitleMappingTable.getModel()).getData();
        for (SubtitleGroup group : this.getUploadGroups(table)) {
            if (!group.isUploadReady()) continue;
            this.uploadExecutorService.submit(() -> this.runUpload(group));
        }
        this.uploadExecutorService.shutdown();
    }

    public void doClose(ActionEvent evt) {
        if (this.checkExecutorService != null) {
            this.checkExecutorService.shutdownNow();
        }
        if (this.uploadExecutorService != null) {
            this.uploadExecutorService.shutdownNow();
        }
        this.setVisible(false);
        this.dispose();
    }
}

