/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.platform.gnome.GVFS;

public class FileTransferable
implements Transferable {
    public static final DataFlavor uriListFlavor = FileTransferable.createUriListFlavor();
    private final File[] files;

    private static DataFlavor createUriListFlavor() {
        try {
            return new DataFlavor("text/uri-list;class=java.nio.CharBuffer");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isFileListFlavor(DataFlavor flavor) {
        return flavor.isFlavorJavaFileListType() || flavor.equals(uriListFlavor);
    }

    public static boolean hasFileListFlavor(Transferable tr) {
        return tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || tr.isDataFlavorSupported(uriListFlavor);
    }

    public FileTransferable(File ... files) {
        this.files = files;
    }

    public FileTransferable(Collection<File> files) {
        this.files = files.toArray(new File[0]);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.isFlavorJavaFileListType()) {
            return Arrays.asList(this.files);
        }
        if (flavor.equals(uriListFlavor)) {
            return CharBuffer.wrap(this.getUriList());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String getUriList() {
        StringBuilder sb = new StringBuilder(80 * this.files.length);
        for (File file : this.files) {
            sb.append("file://").append(file.toURI().getRawPath());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, uriListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FileTransferable.isFileListFlavor(flavor);
    }

    public static List<File> getFilesFromTransferable(Transferable tr) throws IOException, UnsupportedFlavorException {
        if (Settings.useGVFS() && tr.isDataFlavorSupported(uriListFlavor)) {
            Readable transferData = (Readable)tr.getTransferData(uriListFlavor);
            try (Scanner scanner = new Scanner(transferData);){
                ArrayList<File> files = new ArrayList<File>();
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#")) continue;
                    try {
                        File file = GVFS.getDefaultVFS().getPathForURI(new URI(line));
                        if (file == null || !file.exists()) {
                            throw new FileNotFoundException(file.getPath());
                        }
                        files.add(file);
                    }
                    catch (Throwable e) {
                        Logging.debug.warning(Logging.format("GVFS: %s => %s", line, e));
                    }
                }
                ArrayList<File> arrayList = files;
                return arrayList;
            }
        }
        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object transferable = tr.getTransferData(DataFlavor.javaFileListFlavor);
            if (transferable instanceof List) {
                return (List)transferable;
            }
            return null;
        }
        throw new UnsupportedFlavorException(DataFlavor.javaFileListFlavor);
    }
}

