/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.position() < this.buffer.limit() ? this.buffer.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buffer.position() >= this.buffer.limit()) {
            return -1;
        }
        if (len > this.buffer.remaining()) {
            len = this.buffer.remaining();
        }
        if (len <= 0) {
            return 0;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }
}

