/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final ThreadGroup group;
    private final int priority;
    private final boolean daemon;

    public DefaultThreadFactory(String name) {
        this(name, 5);
    }

    public DefaultThreadFactory(String name, int priority) {
        this(name, priority, false);
    }

    public DefaultThreadFactory(String groupName, int priority, boolean daemon) {
        SecurityManager sm = System.getSecurityManager();
        ThreadGroup parentGroup = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.group = new ThreadGroup(parentGroup, groupName);
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.group, r, String.format("%s-thread-%d", this.group.getName(), this.threadNumber.incrementAndGet()));
        if (this.daemon != thread.isDaemon()) {
            thread.setDaemon(this.daemon);
        }
        if (this.priority != thread.getPriority()) {
            thread.setPriority(this.priority);
        }
        return thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }
}

