/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.filebot.Logging;

public class PreferencesMap<T>
implements Map<String, T> {
    private final Preferences prefs;
    private final Adapter<T> adapter;

    public PreferencesMap(Preferences prefs, Adapter<T> adapter) {
        this.prefs = prefs;
        this.adapter = adapter;
    }

    @Override
    public T get(Object key) {
        return this.adapter.get(this.prefs, key.toString());
    }

    @Override
    public T put(String key, T value) {
        this.adapter.put(this.prefs, key, value);
        return null;
    }

    @Override
    public T remove(Object key) {
        this.adapter.remove(this.prefs, key.toString());
        return null;
    }

    public String[] keys() {
        try {
            return this.adapter.keys(this.prefs);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        for (String key : this.keys()) {
            this.adapter.remove(this.prefs, key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return Arrays.asList(this.keys()).contains(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (String key : this.keys()) {
            if (!value.equals(this.get(key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        LinkedHashSet<Map.Entry<String, T>> entries = new LinkedHashSet<Map.Entry<String, T>>();
        for (String key : this.keys()) {
            entries.add(new PreferencesEntry<T>(this.prefs, key, this.adapter));
        }
        return entries;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(Arrays.asList(this.keys()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.keys().length;
    }

    @Override
    public Collection<T> values() {
        ArrayList<T> values = new ArrayList<T>();
        for (String key : this.keys()) {
            values.add(this.get(key));
        }
        return values;
    }

    public static PreferencesMap<String> map(Preferences prefs) {
        return PreferencesMap.map(prefs, new StringAdapter());
    }

    public static <T> PreferencesMap<T> map(Preferences prefs, Adapter<T> adapter) {
        return new PreferencesMap<T>(prefs, adapter);
    }

    public static class PreferencesEntry<T>
    implements Map.Entry<String, T> {
        private final String key;
        private final Preferences prefs;
        private final Adapter<T> adapter;
        private T defaultValue = null;

        public PreferencesEntry(Preferences prefs, String key, Adapter<T> adapter) {
            this.key = key;
            this.prefs = prefs;
            this.adapter = adapter;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            T value = this.adapter.get(this.prefs, this.key);
            return value != null ? value : this.defaultValue;
        }

        @Override
        public T setValue(T value) {
            this.adapter.put(this.prefs, this.key, value);
            return null;
        }

        public PreferencesEntry<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public void remove() {
            this.adapter.remove(this.prefs, this.key);
        }

        public void flush() {
            try {
                this.prefs.flush();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static class JsonAdapter<T>
    extends AbstractAdapter<T> {
        private Class<T> type;

        public JsonAdapter(Class<T> type) {
            this.type = type;
        }

        @Override
        public T get(Preferences prefs, String key) {
            String json = prefs.get(key, null);
            if (json != null) {
                try {
                    return this.type.cast(JsonReader.jsonToJava(json));
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e, e::getMessage);
                }
            }
            return null;
        }

        @Override
        public void put(Preferences prefs, String key, T value) {
            prefs.put(key, JsonWriter.objectToJson(value));
        }
    }

    public static class SimpleAdapter<T>
    extends AbstractAdapter<T> {
        private final Constructor<T> constructor;

        public SimpleAdapter(Class<T> type) {
            try {
                this.constructor = type.getConstructor(String.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public T get(Preferences prefs, String key) {
            String value = prefs.get(key, null);
            if (value != null) {
                try {
                    return this.constructor.newInstance(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        @Override
        public void put(Preferences prefs, String key, T value) {
            prefs.put(key, value.toString());
        }

        public static <T> SimpleAdapter<T> forClass(Class<T> type) {
            return new SimpleAdapter<T>(type);
        }
    }

    public static class StringAdapter
    extends AbstractAdapter<String> {
        @Override
        public String get(Preferences prefs, String key) {
            return prefs.get(key, null);
        }

        @Override
        public void put(Preferences prefs, String key, String value) {
            prefs.put(key, value);
        }
    }

    public static abstract class AbstractAdapter<T>
    implements Adapter<T> {
        @Override
        public abstract T get(Preferences var1, String var2);

        @Override
        public abstract void put(Preferences var1, String var2, T var3);

        @Override
        public String[] keys(Preferences prefs) throws BackingStoreException {
            return prefs.keys();
        }

        @Override
        public void remove(Preferences prefs, String key) {
            prefs.remove(key);
        }
    }

    public static interface Adapter<T> {
        public String[] keys(Preferences var1) throws BackingStoreException;

        public T get(Preferences var1, String var2);

        public void put(Preferences var1, String var2, T var3);

        public void remove(Preferences var1, String var2);
    }
}

