/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import net.filebot.Logging;

public class SystemProperty<T> {
    private final String key;
    private final Function<String, T> valueFunction;
    private final T defaultValue;

    public static <T> SystemProperty<T> of(String key, Function<String, T> valueFunction) {
        return new SystemProperty<Object>(key, valueFunction, null);
    }

    public static <T> SystemProperty<T> of(String key, Function<String, T> valueFunction, T defaultValue) {
        return new SystemProperty<T>(key, valueFunction, defaultValue);
    }

    private SystemProperty(String key, Function<String, T> valueFunction, T defaultValue) {
        this.key = key;
        this.valueFunction = valueFunction;
        this.defaultValue = defaultValue;
    }

    public T get() {
        String prop = System.getProperty(this.key);
        if (prop != null && prop.length() > 0) {
            try {
                return this.valueFunction.apply(prop);
            }
            catch (Exception e) {
                Logging.debug.logp(Level.WARNING, "SystemProperty", this.key, e.toString());
            }
        }
        return this.defaultValue;
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.get());
    }
}

