/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.prefs;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class PropertyFileBackingStore {
    private static final char nodeSeparatorChar = '/';
    private static final Pattern nodeSeparatorPattern = Pattern.compile(String.valueOf('/'), 16);
    private Path store;
    private int modCount = 0;
    private Map<String, Map<String, String>> nodes = new HashMap<String, Map<String, String>>();

    public PropertyFileBackingStore(Path store) {
        this.store = store;
    }

    private Map<String, String> newKeyValueMap(String node) {
        return new HashMap<String, String>();
    }

    public synchronized String setValue(String node, String key, String value) {
        ++this.modCount;
        return this.nodes.computeIfAbsent(node, this::newKeyValueMap).put(key, value);
    }

    public synchronized String getValue(String node, String key) {
        Map<String, String> values = this.nodes.get(node);
        if (values != null) {
            return values.get(key);
        }
        return null;
    }

    public synchronized void removeValue(String node, String key) {
        Map<String, String> values = this.nodes.get(node);
        if (values != null) {
            ++this.modCount;
            values.remove(key);
        }
    }

    public synchronized void removeNode(String node) {
        ++this.modCount;
        this.nodes.remove(node);
    }

    public synchronized String[] getKeys(String node) {
        Map<String, String> values = this.nodes.get(node);
        if (values != null) {
            return values.keySet().toArray(new String[0]);
        }
        return new String[0];
    }

    public synchronized String[] getChildren(String node) {
        HashSet<String> keys = new HashSet<String>();
        String[] path = node.isEmpty() ? new String[]{} : nodeSeparatorPattern.split(node);
        for (String n : this.nodes.keySet()) {
            String[] p = nodeSeparatorPattern.split(n);
            if (p.length <= path.length || path.length != 0 && !IntStream.range(0, path.length).allMatch(i -> p[i].equals(path[i]))) continue;
            keys.add(p[path.length]);
        }
        return keys.toArray(new String[0]);
    }

    public synchronized Properties toProperties() {
        Properties props = new Properties();
        this.nodes.forEach((node, values) -> values.forEach((key, value) -> props.put(node + "/" + key, value)));
        return props;
    }

    public synchronized void mergeNodes(Map<String, Map<String, String>> n) {
        n.forEach((node, values) -> this.nodes.merge((String)node, (Map<String, String>)values, (m1, m2) -> {
            Map<String, String> m = this.newKeyValueMap((String)node);
            m.putAll((Map<String, String>)m1);
            m.putAll((Map<String, String>)m2);
            return m;
        }));
    }

    public void sync() throws IOException {
        if (!Files.exists(this.store, new LinkOption[0])) {
            return;
        }
        byte[] bytes = Files.readAllBytes(this.store);
        StringReader buffer = new StringReader(new String(bytes, StandardCharsets.UTF_8));
        Properties props = new Properties();
        props.load(buffer);
        HashMap<String, Map<String, String>> n = new HashMap<String, Map<String, String>>();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String propertyKey = k.toString();
            int s = propertyKey.lastIndexOf(47);
            String node = propertyKey.substring(0, s);
            String key = propertyKey.substring(s + 1);
            n.computeIfAbsent(node, this::newKeyValueMap).put(key, v.toString());
        }));
        this.mergeNodes(n);
    }

    public void flush() throws IOException {
        if (this.modCount == 0) {
            return;
        }
        StringWriter buffer = new StringWriter();
        this.toProperties().store(buffer, null);
        ByteBuffer data = StandardCharsets.UTF_8.encode(CharBuffer.wrap(buffer.getBuffer()));
        try (FileChannel out = FileChannel.open(this.store, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             FileLock lock = out.lock();){
            out.write(data);
            out.truncate(out.position());
        }
        this.modCount = 0;
    }

    public synchronized String toString() {
        return this.nodes.toString();
    }
}

