/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class ColorTintImageFilter
extends RGBImageFilter {
    private Color color;
    private float intensity;

    public ColorTintImageFilter(Color color, float intensity) {
        this.color = color;
        this.intensity = intensity;
        this.canFilterIndexColorModel = true;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        Color c = new Color(rgb, true);
        int red = (int)((float)c.getRed() * (1.0f - this.intensity) + (float)this.color.getRed() * this.intensity);
        int green = (int)((float)c.getGreen() * (1.0f - this.intensity) + (float)this.color.getGreen() * this.intensity);
        int blue = (int)((float)c.getBlue() * (1.0f - this.intensity) + (float)this.color.getBlue() * this.intensity);
        return new Color(red, green, blue, c.getAlpha()).getRGB();
    }
}

