/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.filebot.util.ui.GradientStyle;

public class FancyTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color gradientBeginColor;
    private Color gradientEndColor;
    private GradientStyle gradientStyle;
    private boolean paintGradient;
    private Color backgroundSelectionColor;

    public FancyTreeCellRenderer() {
        this(GradientStyle.TOP_TO_BOTTOM);
    }

    public FancyTreeCellRenderer(GradientStyle gradientStyle) {
        this.gradientStyle = gradientStyle;
        this.backgroundSelectionColor = this.getBackgroundSelectionColor();
        this.setBackgroundSelectionColor(null);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, false);
        this.setIconTextGap(5);
        if (selected) {
            this.setPaintGradient(true);
            this.setGradientBeginColor(this.backgroundSelectionColor.brighter());
            this.setGradientEndColor(this.backgroundSelectionColor);
        } else {
            this.setPaintGradient(false);
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isPaintGradient()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int imageOffset = this.getLabelStart() - 2;
            int arch = 16;
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(imageOffset, 1.0, this.getWidth() - imageOffset, this.getHeight() - 2, arch, arch);
            g2d.setPaint(this.gradientStyle.getGradientPaint(shape, this.gradientBeginColor, this.gradientEndColor));
            g2d.fill(shape);
        }
        super.paintComponent(g);
    }

    protected int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Color getGradientBeginColor() {
        return this.gradientBeginColor;
    }

    public void setGradientBeginColor(Color gradientBeginColor) {
        this.gradientBeginColor = gradientBeginColor;
    }

    public boolean isPaintGradient() {
        return this.paintGradient;
    }

    public void setPaintGradient(boolean gradientEnabled) {
        this.paintGradient = gradientEnabled;
    }

    public Color getGradientEndColor() {
        return this.gradientEndColor;
    }

    public void setGradientEndColor(Color gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
    }

    public GradientStyle getGradientStyle() {
        return this.gradientStyle;
    }

    public void setGradientStyle(GradientStyle gradientStyle) {
        this.gradientStyle = gradientStyle;
    }
}

