/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Component;
import javax.swing.JComponent;
import net.filebot.util.ui.ProgressIndicator;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

public class LoadingOverlayPane
extends JComponent {
    public static final String LOADING_PROPERTY = "loading";
    private final JComponent animationComponent;
    private boolean overlayEnabled = false;
    private int millisToOverlay = 400;

    public LoadingOverlayPane(JComponent component, JComponent propertyChangeSource) {
        this(component, propertyChangeSource, null, null);
    }

    public LoadingOverlayPane(JComponent component, JComponent propertyChangeSource, String offsetX, String offsetY) {
        this.setLayout(new MigLayout("insets 0, fill"));
        this.animationComponent = new ProgressIndicator();
        this.animationComponent.setVisible(false);
        this.add((Component)this.animationComponent, String.format("pos n %s 100%%-%s n", offsetY != null ? offsetY : "8px", offsetX != null ? offsetX : "20px"));
        this.add((Component)component, "grow");
        if (propertyChangeSource != null) {
            propertyChangeSource.addPropertyChangeListener(LOADING_PROPERTY, evt -> this.setOverlayVisible((Boolean)evt.getNewValue()));
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void setOverlayVisible(boolean b) {
        this.overlayEnabled = b;
        if (this.overlayEnabled) {
            SwingUI.invokeLater(this.millisToOverlay, new Runnable(){

                @Override
                public void run() {
                    if (LoadingOverlayPane.this.overlayEnabled) {
                        LoadingOverlayPane.this.animationComponent.setVisible(true);
                    }
                }
            });
        } else {
            this.animationComponent.setVisible(false);
        }
    }
}

