/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.Icon;
import net.filebot.util.ui.LabelProvider;

public class SimpleLabelProvider<T>
implements LabelProvider<T> {
    private final Method getIconMethod;
    private final Method getTextMethod;

    public static <T> SimpleLabelProvider<T> forClass(Class<T> type) {
        return new SimpleLabelProvider<T>(type);
    }

    public SimpleLabelProvider(Class<T> type) {
        this.getTextMethod = this.findAnyMethod(type, "getText", "getName", "toString");
        this.getIconMethod = this.findAnyMethod(type, "getIcon");
    }

    public SimpleLabelProvider(Class<T> type, String getText, String getIcon) {
        this.getTextMethod = this.findAnyMethod(type, getText);
        this.getIconMethod = this.findAnyMethod(type, getIcon);
    }

    private Method findAnyMethod(Class<T> type, String ... names) {
        for (String name : names) {
            try {
                return type.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new IllegalArgumentException("Method not found: " + Arrays.toString(names));
    }

    @Override
    public String getText(T value) {
        try {
            return (String)this.getTextMethod.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Icon getIcon(T value) {
        try {
            return (Icon)this.getIconMethod.invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

