/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.filebot.web.Crew;
import net.filebot.web.Datasource;
import net.filebot.web.Person;

public class EpisodeInfo
implements Crew,
Serializable {
    protected String database;
    protected Integer seriesId;
    protected Integer id;
    protected String language;
    protected Person[] people;
    protected String overview;
    protected Double rating;
    protected Integer votes;

    public EpisodeInfo() {
    }

    public EpisodeInfo(EpisodeInfo other) {
        this.database = other.database;
        this.seriesId = other.seriesId;
        this.id = other.id;
        this.language = other.language;
        this.people = other.people == null ? null : (Person[])other.people.clone();
        this.overview = other.overview;
        this.rating = other.rating;
        this.votes = other.votes;
    }

    public EpisodeInfo(Datasource database, Locale language, Integer seriesId, Integer id, List<Person> people, String overview, Double rating, Integer votes) {
        this.database = database.getIdentifier();
        this.language = language.getLanguage();
        this.seriesId = seriesId;
        this.id = id;
        this.people = people.toArray(new Person[0]);
        this.overview = overview;
        this.votes = votes;
        this.rating = rating;
    }

    public String getDatabase() {
        return this.database;
    }

    public Integer getSeriesId() {
        return this.seriesId;
    }

    public Integer getId() {
        return this.id;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public List<Person> getCrew() {
        return Collections.unmodifiableList(Arrays.asList(this.people));
    }

    public String getOverview() {
        return this.overview;
    }

    public Double getRating() {
        return this.rating;
    }

    public Integer getVotes() {
        return this.votes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EpisodeInfo) {
            EpisodeInfo other = (EpisodeInfo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.database, other.database);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id;
    }

    public EpisodeInfo clone() {
        return new EpisodeInfo(this);
    }

    public String toString() {
        return this.database + "::" + this.seriesId + "::" + this.id;
    }
}

