/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.filebot.WebServices;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.MultiEpisode;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SortOrder;

public final class EpisodeUtilities {
    public static final Comparator<Episode> EPISODE_NUMBERS_COMPARATOR = new Comparator<Episode>(){

        @Override
        public int compare(Episode a, Episode b) {
            int diff = this.compareValue(a.getSeason(), b.getSeason());
            if (diff != 0) {
                return diff;
            }
            diff = this.compareValue(a.getEpisode(), b.getEpisode());
            if (diff != 0) {
                return diff;
            }
            diff = this.compareValue(a.getSpecial(), b.getSpecial());
            if (diff != 0) {
                return diff;
            }
            return this.compareValue(a.getAbsolute(), b.getAbsolute());
        }

        private <T> int compareValue(Comparable<T> o1, T o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return Integer.MAX_VALUE;
            }
            if (o1 != null && o2 == null) {
                return Integer.MIN_VALUE;
            }
            return o1.compareTo(o2);
        }
    };

    public static Episode createEpisode(List<Episode> episode) {
        if (episode.isEmpty()) {
            throw new IllegalArgumentException("No such Episode");
        }
        return episode.size() == 1 ? episode.get(0) : new MultiEpisode(episode);
    }

    public static List<Episode> getMultiEpisodeList(Episode e) {
        return e instanceof MultiEpisode ? ((MultiEpisode)e).getEpisodes() : Collections.singletonList(e);
    }

    public static boolean isAnime(Episode e) {
        return WebServices.AniDB.getIdentifier().equals(e.getSeriesInfo().getDatabase());
    }

    public static boolean isRegular(Episode e) {
        return e.getEpisode() != null && e.getSpecial() == null;
    }

    public static boolean isAbsolute(Episode e) {
        return e.getAbsolute() != null && e.getSeriesInfo().getOrder() != null && SortOrder.Absolute == SortOrder.valueOf(e.getSeriesInfo().getOrder());
    }

    public static List<Episode> fetchEpisodeList(Episode episode) throws Exception {
        return EpisodeUtilities.fetchEpisodeList(episode, null, null);
    }

    public static List<Episode> fetchEpisodeList(Episode episode, SortOrder preferredSortOrder, Locale preferredLocale) throws Exception {
        Locale locale;
        SeriesInfo info = episode.getSeriesInfo();
        SortOrder order = preferredSortOrder;
        if (order == null) {
            order = SortOrder.valueOf(info.getOrder());
        }
        if ((locale = preferredLocale) == null) {
            locale = new Locale(info.getLanguage());
        }
        return WebServices.getEpisodeListProvider(info.getDatabase()).getEpisodeList(info.getId(), order, locale);
    }

    public static Episode fetchEpisode(Episode episode, SortOrder preferredSortOrder, Locale preferredLocale) throws Exception {
        List<Episode> episodeList = EpisodeUtilities.fetchEpisodeList(episode, preferredSortOrder, preferredLocale);
        List<Episode> includes = EpisodeUtilities.getMultiEpisodeList(episode);
        return EpisodeUtilities.createEpisode(episodeList.stream().filter(includes::contains).sorted(EPISODE_NUMBERS_COMPARATOR).collect(Collectors.toList()));
    }

    public static Episode getEpisodeByAbsoluteNumber(Episode e, EpisodeListProvider service, SortOrder order) throws Exception {
        Set<String> seriesNames = EpisodeUtilities.getLenientSeriesNameSet(e);
        Locale locale = new Locale(e.getSeriesInfo().getLanguage());
        List<Episode> multiEpisode = EpisodeUtilities.getMultiEpisodeList(e);
        for (SearchResult series : service.search(e.getSeriesName(), locale)) {
            if (!series.getEffectiveNames().stream().anyMatch(seriesNames::contains)) continue;
            List<Episode> airdateEpisodeList = service.getEpisodeList(series, order, locale);
            List<Episode> airdateEpisode = multiEpisode.stream().flatMap(abs -> airdateEpisodeList.stream().filter(sxe -> abs.getSpecial() == null && sxe.getSpecial() == null).filter(sxe -> abs.getAbsolute() != null && abs.getAbsolute().equals(sxe.getAbsolute()))).collect(Collectors.toList());
            if (airdateEpisode.size() != multiEpisode.size()) break;
            return EpisodeUtilities.createEpisode(airdateEpisode);
        }
        return e;
    }

    private static Set<String> getLenientSeriesNameSet(Episode e) {
        Collator collator = Collator.getInstance(new Locale(e.getSeriesInfo().getLanguage()));
        collator.setDecomposition(2);
        collator.setStrength(0);
        TreeSet<Object> seriesNames = new TreeSet<Object>(collator);
        seriesNames.addAll(e.getSeriesNames());
        return seriesNames;
    }

    public static List<Episode> filterBySeason(Collection<Episode> episodes, int season) {
        return episodes.stream().filter(it -> it.getSeason() != null && season == it.getSeason()).collect(Collectors.toList());
    }

    public static int getLastSeason(Collection<Episode> episodes) {
        return episodes.stream().mapToInt(it -> it.getSeason() == null ? 0 : it.getSeason()).max().orElse(0);
    }

    public static Comparator<Episode> episodeComparator() {
        return EPISODE_NUMBERS_COMPARATOR;
    }

    private EpisodeUtilities() {
        throw new UnsupportedOperationException();
    }
}

