/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.util.JsonUtilities;
import net.filebot.web.Artwork;
import net.filebot.web.ArtworkProvider;
import net.filebot.web.Datasource;

public class FanartTVClient
implements Datasource,
ArtworkProvider {
    private String apikey;

    public FanartTVClient(String apikey) {
        this.apikey = apikey;
    }

    @Override
    public String getIdentifier() {
        return "FanartTV";
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    public URL getResource(String path) throws Exception {
        return new URL("https://webservice.fanart.tv/v3/" + path + "?api_key=" + this.apikey);
    }

    @Override
    public List<Artwork> getArtwork(int id, String category, Locale locale) throws Exception {
        Cache cache = Cache.getCache(this.getName(), CacheType.Weekly);
        Object json = cache.json(category + "/" + id, s -> this.getResource((String)s)).expire(Cache.ONE_WEEK).get();
        return JsonUtilities.asMap(json).entrySet().stream().flatMap(type -> JsonUtilities.streamJsonObjects(type.getValue()).map(it -> {
            try {
                String url = JsonUtilities.getString(it, "url");
                Locale language = JsonUtilities.getStringValue(it, "lang", Locale::new);
                Double likes = JsonUtilities.getDecimal(it, "likes");
                String season = JsonUtilities.getString(it, "season");
                String discType = JsonUtilities.getString(it, "disc_type");
                return new Artwork(Stream.of(type.getKey(), season, discType), new URL(url), language, likes);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e, e::getMessage);
                return null;
            }
        })).filter(Objects::nonNull).sorted(Artwork.RATING_ORDER).collect(Collectors.toList());
    }
}

