/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import net.filebot.Logging;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.util.StringUtilities;
import net.filebot.web.Movie;
import net.filebot.web.OpenSubtitlesSubtitleDescriptor;
import net.filebot.web.SubtitleSearchResult;
import redstone.xmlrpc.XmlRpcClient;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;
import redstone.xmlrpc.util.Base64;

public class OpenSubtitlesXmlRpc {
    private final String useragent;
    private String token;

    public OpenSubtitlesXmlRpc(String useragent) {
        this.useragent = useragent;
    }

    public void loginAnonymous() throws XmlRpcFault {
        this.login("", "", "en");
    }

    public synchronized void login(String username, String password, String language) throws XmlRpcFault {
        Map<?, ?> response = this.invoke("LogIn", username, password, language, this.useragent);
        this.token = response.get("token").toString();
    }

    public synchronized void logout() throws XmlRpcFault {
        try {
            this.invoke("LogOut", this.token);
        }
        catch (XmlRpcFault xmlRpcFault) {
        }
        finally {
            this.token = null;
        }
    }

    public boolean isLoggedOn() {
        return this.token != null;
    }

    public Map<String, String> getServerInfo() throws XmlRpcFault {
        return this.invoke("ServerInfo", this.token);
    }

    public List<OpenSubtitlesSubtitleDescriptor> searchSubtitles(Collection<Query> queryList) throws XmlRpcFault {
        OpenSubtitlesSubtitleDescriptor.checkDownloadQuota();
        ArrayList<OpenSubtitlesSubtitleDescriptor> subtitles = new ArrayList<OpenSubtitlesSubtitleDescriptor>();
        Map<?, ?> response = this.invoke("SearchSubtitles", this.token, queryList);
        try {
            List subtitleData = (List)response.get("data");
            for (Map propertyMap : subtitleData) {
                subtitles.add(new OpenSubtitlesSubtitleDescriptor(OpenSubtitlesSubtitleDescriptor.Property.asEnumMap(propertyMap)));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return subtitles;
    }

    public List<SubtitleSearchResult> searchMoviesOnIMDB(String query) throws XmlRpcFault {
        try {
            Map<?, ?> response = this.invoke("SearchMoviesOnIMDB", this.token, query);
            List movieData = (List)response.get("data");
            ArrayList<SubtitleSearchResult> movies = new ArrayList<SubtitleSearchResult>();
            Pattern pattern = Pattern.compile("(.+)[(](\\d{4})([/]I+)?[)]");
            for (Map movie : movieData) {
                try {
                    String imdbid = (String)movie.get("id");
                    if (!imdbid.matches("\\d{1,7}")) {
                        throw new IllegalArgumentException("Illegal IMDb movie ID: Must be a 7-digit number");
                    }
                    Matcher matcher = pattern.matcher((CharSequence)movie.get("title"));
                    if (!matcher.find()) {
                        throw new IllegalArgumentException("Illegal title: Must be in 'name (year)' format");
                    }
                    String name = matcher.group(1).replaceAll("\"", "").trim();
                    int year = Integer.parseInt(matcher.group(2));
                    movies.add(new SubtitleSearchResult(Integer.parseInt(imdbid), name, year, null, -1));
                }
                catch (Exception e) {
                    Logging.debug.log(Level.FINE, String.format("Ignore movie [%s]: %s", movie, e.getMessage()));
                }
            }
            return movies;
        }
        catch (ClassCastException e) {
            throw new XmlRpcException("Illegal XMLRPC response on searchMoviesOnIMDB");
        }
    }

    public Movie getIMDBMovieDetails(int imdbid) throws XmlRpcFault {
        Map<?, ?> response = this.invoke("GetIMDBMovieDetails", this.token, imdbid);
        try {
            Map data = (Map)response.get("data");
            String name = (String)data.get("title");
            int year = Integer.parseInt((String)data.get("year"));
            return new Movie(name, year, imdbid);
        }
        catch (RuntimeException e) {
            Logging.debug.log(Level.WARNING, String.format("Failed to lookup movie by imdbid %s: %s", imdbid, e.getMessage()));
            return null;
        }
    }

    private Map<String, Object> getUploadStruct(BaseInfo baseInfo, SubFile ... subtitles) {
        LinkedHashMap<String, Object> struct = new LinkedHashMap<String, Object>();
        if (baseInfo != null) {
            struct.put("baseinfo", baseInfo);
        }
        for (int i = 0; i < subtitles.length; ++i) {
            struct.put("cd" + (i + 1), subtitles[i]);
        }
        return struct;
    }

    public TryUploadResponse tryUploadSubtitles(SubFile ... subtitles) throws XmlRpcFault {
        Map<String, Object> struct = this.getUploadStruct(null, subtitles);
        Map<?, ?> response = this.invoke("TryUploadSubtitles", this.token, struct);
        boolean uploadRequired = response.get("alreadyindb").toString().equals("0");
        ArrayList<Map> subtitleData = new ArrayList<Map>();
        if (response.get("data") instanceof Map) {
            subtitleData.add((Map)response.get("data"));
        } else if (response.get("data") instanceof List) {
            subtitleData.addAll((List)response.get("data"));
        }
        return new TryUploadResponse(uploadRequired, subtitleData);
    }

    public URI uploadSubtitles(BaseInfo baseInfo, SubFile ... subtitles) throws XmlRpcFault {
        Map<String, Object> struct = this.getUploadStruct(baseInfo, subtitles);
        Map<?, ?> response = this.invoke("UploadSubtitles", this.token, struct);
        return URI.create(response.get("data").toString());
    }

    public List<String> detectLanguage(byte[] data) throws XmlRpcFault {
        String parameter = OpenSubtitlesXmlRpc.encodeData(data);
        Map<?, ?> response = this.invoke("DetectLanguage", this.token, Collections.singleton(parameter));
        ArrayList<String> languages = new ArrayList<String>(2);
        if (response.containsKey("data")) {
            languages.addAll(((Map)response.get("data")).values());
        }
        return languages;
    }

    public Map<String, Integer> checkSubHash(Collection<String> hashes) throws XmlRpcFault {
        Map<?, ?> response = this.invoke("CheckSubHash", this.token, hashes);
        Map subHashData = (Map)response.get("data");
        HashMap<String, Integer> subHashMap = new HashMap<String, Integer>();
        for (Map.Entry entry : subHashData.entrySet()) {
            subHashMap.put((String)entry.getKey(), Integer.parseInt(entry.getValue().toString()));
        }
        return subHashMap;
    }

    public Map<String, List<SubtitleSearchResult>> guessMovie(Collection<String> tags) throws XmlRpcFault {
        HashMap<String, List<SubtitleSearchResult>> results = new HashMap<String, List<SubtitleSearchResult>>();
        Map<?, ?> response = this.invoke("GuessMovieFromString", this.token, tags);
        Object payload = response.get("data");
        if (payload instanceof Map) {
            Map dataByTag = (Map)payload;
            for (String tag : tags) {
                Map match;
                ArrayList<SubtitleSearchResult> value = new ArrayList<SubtitleSearchResult>();
                Map data = (Map)dataByTag.get(tag);
                if (data != null && (match = (Map)data.get("BestGuess")) != null) {
                    String name = String.valueOf(match.get("MovieName"));
                    String kind = String.valueOf(match.get("MovieKind"));
                    int imdbid = Integer.parseInt(String.valueOf(match.get("IDMovieIMDB")));
                    int year = Integer.parseInt(String.valueOf(match.get("MovieYear")));
                    value.add(new SubtitleSearchResult(imdbid, name, year, kind, -1));
                }
                results.put(tag, value);
            }
        }
        return results;
    }

    public Map<String, Movie> checkMovieHash(Collection<String> hashes, int minSeenCount) throws XmlRpcFault {
        HashMap<String, Movie> movieHashMap = new HashMap<String, Movie>();
        Map<?, ?> response = this.invoke("CheckMovieHash2", this.token, hashes);
        Object payload = response.get("data");
        if (payload instanceof Map) {
            Map movieHashData = (Map)payload;
            for (Map.Entry entry : movieHashData.entrySet()) {
                if (!(entry.getValue() instanceof List)) continue;
                String hash = (String)entry.getKey();
                ArrayList<Movie> matches = new ArrayList<Movie>();
                List hashMatches = (List)entry.getValue();
                for (Object match : hashMatches) {
                    Map info;
                    int seenCount;
                    if (!(match instanceof Map) || (seenCount = Integer.parseInt((String)(info = (Map)match).get("SeenCount"))) < minSeenCount) continue;
                    String name = (String)info.get("MovieName");
                    int year = Integer.parseInt((String)info.get("MovieYear"));
                    int imdb = Integer.parseInt((String)info.get("MovieImdbID"));
                    matches.add(new Movie(name, year, imdb));
                }
                if (matches.size() == 1) {
                    movieHashMap.put(hash, (Movie)matches.get(0));
                    continue;
                }
                if (matches.size() <= 1) continue;
                Logging.debug.log(Level.WARNING, "Ignore hash match due to hash collision: " + matches);
            }
        }
        return movieHashMap;
    }

    public Map<String, String> getSubLanguages() throws XmlRpcFault {
        return this.getSubLanguages("en");
    }

    public Map<String, String> getSubLanguages(String languageCode) throws XmlRpcFault {
        Map<?, ?> response = this.invoke("GetSubLanguages", languageCode);
        HashMap<String, String> subLanguageMap = new HashMap<String, String>();
        for (Map language : (List)response.get("data")) {
            subLanguageMap.put((String)language.get("SubLanguageID"), (String)language.get("ISO639"));
        }
        return subLanguageMap;
    }

    public void noOperation() throws XmlRpcFault {
        this.invoke("NoOperation", this.token);
    }

    protected Map<?, ?> invoke(String method, Object ... arguments) throws XmlRpcFault {
        try {
            XmlRpcClient rpc = new XmlRpcClient(this.getXmlRpcUrl(), false){

                @Override
                public void parse(InputStream input) throws XmlRpcException {
                    try {
                        super.parse(new GZIPInputStream(input));
                    }
                    catch (IOException e) {
                        throw new XmlRpcException(e.getMessage(), e);
                    }
                }
            };
            rpc.setRequestProperty("Accept-Encoding", "gzip");
            Map response = (Map)rpc.invoke(method, arguments);
            this.checkResponse(response);
            return response;
        }
        catch (XmlRpcFault e) {
            if (e.getErrorCode() == 406) {
                this.token = null;
            }
            throw e;
        }
        catch (ClassCastException e) {
            throw new XmlRpcFault(500, "The remote server returned an unexpected response");
        }
    }

    protected URL getXmlRpcUrl() {
        try {
            return new URL(System.getProperty("net.filebot.OpenSubtitlesXmlRpc.url", "https://api.opensubtitles.org/xml-rpc"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String encodeData(byte[] data) {
        try {
            DeflaterInputStream compressedDataStream = new DeflaterInputStream(new ByteArrayInputStream(data));
            ByteBufferOutputStream buffer = new ByteBufferOutputStream(data.length);
            buffer.transferFully(compressedDataStream);
            return new String(Base64.encode(buffer.getByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkResponse(Map<?, ?> response) throws XmlRpcFault {
        String status = (String)response.get("status");
        if (status == null || status.equals("200 OK")) {
            return;
        }
        try {
            throw new XmlRpcFault(new Scanner(status).nextInt(), status);
        }
        catch (NoSuchElementException e) {
            throw new XmlRpcException("Illegal status code: " + status);
        }
    }

    public static final class TryUploadResponse {
        private final boolean uploadRequired;
        private final List<Map<String, String>> subtitleData;

        private TryUploadResponse(boolean uploadRequired, List<Map<String, String>> subtitleData) {
            this.uploadRequired = uploadRequired;
            this.subtitleData = subtitleData;
        }

        public boolean isUploadRequired() {
            return this.uploadRequired;
        }

        public List<Map<String, String>> getSubtitleData() {
            return this.subtitleData;
        }

        public String toString() {
            return String.format("TryUploadResponse: %s => %s", this.uploadRequired, this.subtitleData);
        }
    }

    public static final class SubFile
    extends HashMap<String, Object> {
        public void setSubHash(String subhash) {
            this.put("subhash", subhash);
        }

        public void setSubFileName(String subfilename) {
            this.put("subfilename", subfilename);
        }

        public void setMovieHash(String moviehash) {
            this.put("moviehash", moviehash);
        }

        public void setMovieByteSize(long moviebytesize) {
            this.put("moviebytesize", Long.toString(moviebytesize));
        }

        public void setMovieFileName(String moviefilename) {
            this.put("moviefilename", moviefilename);
        }

        public void setSubContent(byte[] data) {
            this.put("subcontent", OpenSubtitlesXmlRpc.encodeData(data));
        }

        public void setMovieTimeMS(String movietimems) {
            if (movietimems.length() > 0) {
                this.put("movietimems", movietimems);
            }
        }

        public void setMovieFPS(String moviefps) {
            if (moviefps.length() > 0) {
                this.put("moviefps", moviefps);
            }
        }

        public void setMovieFrames(String movieframes) {
            if (movieframes.length() > 0) {
                this.put("movieframes", movieframes);
            }
        }

        @Override
        public String toString() {
            return String.format("(%s, %s)", this.get("moviefilename"), this.get("subfilename"));
        }
    }

    public static final class BaseInfo
    extends HashMap<String, Object> {
        public void setIDMovieImdb(int imdb) {
            this.put("idmovieimdb", Integer.toString(imdb));
        }

        public void setSubLanguageID(String sublanguageid) {
            this.put("sublanguageid", sublanguageid);
        }

        public void setMovieReleaseName(String moviereleasename) {
            this.put("moviereleasename", moviereleasename);
        }

        public void setMovieAka(String movieaka) {
            this.put("movieaka", movieaka);
        }

        public void setSubAuthorComment(String subauthorcomment) {
            this.put("subauthorcomment", subauthorcomment);
        }
    }

    public static final class Query
    extends HashMap<String, Object>
    implements Serializable {
        private Query(String ... sublanguageids) {
            this.put("sublanguageid", StringUtilities.join(sublanguageids, (CharSequence)","));
        }

        public static Query forHash(String moviehash, long moviebytesize, String ... sublanguageids) {
            Query query = new Query(sublanguageids);
            query.put("moviehash", moviehash);
            query.put("moviebytesize", Long.toString(moviebytesize));
            return query;
        }

        public static Query forTag(String tag, String ... sublanguageids) {
            Query query = new Query(sublanguageids);
            query.put("tag", tag);
            return query;
        }

        public static Query forImdbId(int imdbid, int season, int episode, String ... sublanguageids) {
            Query query = new Query(sublanguageids);
            query.put("imdbid", Integer.toString(imdbid));
            if (season >= 0) {
                query.put("season", Integer.toString(season));
            }
            if (episode >= 0) {
                query.put("episode", Integer.toString(episode));
            }
            return query;
        }
    }
}

