/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.net.URL;
import java.util.Comparator;

public class Person
implements Serializable {
    protected String name;
    protected String character;
    protected String job;
    protected String department;
    protected Integer order;
    protected URL image;
    public static final String WRITER = "Writer";
    public static final String DIRECTOR = "Director";
    public static final String ACTOR = "Actor";
    public static final String GUEST_STAR = "Guest Star";
    public static final Comparator<Person> CREDIT_ORDER = Comparator.comparing(Person::getOrder, Comparator.nullsLast(Comparator.naturalOrder()));

    public Person() {
    }

    public Person(String name, String job) {
        this(name, null, job, null, null, null);
    }

    public Person(String name, String character, String job, String department, Integer order, URL image) {
        this.name = name;
        this.character = character == null || character.isEmpty() ? null : character;
        this.job = job == null || job.isEmpty() ? null : job;
        this.department = department == null || department.isEmpty() ? null : department;
        this.order = order;
        this.image = image;
    }

    public String getName() {
        return this.name;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getJob() {
        return this.job;
    }

    public String getDepartment() {
        return this.department;
    }

    public Integer getOrder() {
        return this.order;
    }

    public URL getImage() {
        return this.image;
    }

    public boolean isActor() {
        return this.character != null || ACTOR.equals(this.job) || GUEST_STAR.equals(this.job);
    }

    public boolean isDirector() {
        return DIRECTOR.equals(this.job);
    }

    public boolean isWriter() {
        return WRITER.equals(this.job);
    }

    public String toString() {
        return String.format("%s (%s)", this.name, this.character != null ? this.character : this.job);
    }
}

