/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.util.List;
import java.util.Locale;
import net.filebot.web.Movie;

public class SubtitleSearchResult
extends Movie {
    private Kind kind;
    private int score;

    public SubtitleSearchResult() {
    }

    public SubtitleSearchResult(int imdbId, String name, int year, String kind, int score) {
        this(name, null, year, imdbId, -1, Locale.ENGLISH, Kind.forName(kind), score);
    }

    public SubtitleSearchResult(String name, String[] aliasNames, int year, int imdbId, int tmdbId, Locale locale, Kind kind, int score) {
        super(name, aliasNames, year, imdbId, tmdbId, locale);
        this.kind = kind;
        this.score = score;
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isMovie() {
        return this.kind == Kind.Movie;
    }

    public boolean isSeries() {
        return this.kind == Kind.Series;
    }

    @Override
    public List<String> getEffectiveNames() {
        switch (this.kind) {
            case Series: {
                return super.getEffectiveNamesWithoutYear();
            }
        }
        return super.getEffectiveNames();
    }

    @Override
    public String toString() {
        switch (this.kind) {
            case Series: {
                return super.getName();
            }
        }
        return super.toString();
    }

    public static enum Kind {
        Movie,
        Series,
        Other,
        Unkown;


        public static Kind forName(String s) {
            if (s == null || s.isEmpty()) {
                return Unkown;
            }
            if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("movie")) {
                return Movie;
            }
            if (s.equalsIgnoreCase("s") || s.equalsIgnoreCase("tv series")) {
                return Series;
            }
            return Other;
        }
    }
}

