/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected FileObject resolveFile(String uri) throws FileSystemException {
        if (manager == null) {
            StandardFileSystemManager mngr = new StandardFileSystemManager();
            mngr.setLogger(new AntLogger());
            mngr.init();
            manager = mngr;
            this.getProject().addBuildListener(new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), uri);
    }

    protected void closeManager() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
    }

    private class AntLogger
    implements Log {
        private AntLogger() {
        }

        @Override
        public void debug(Object o) {
            VfsTask.this.log(String.valueOf(o), 4);
        }

        @Override
        public void debug(Object o, Throwable throwable) {
            this.debug(o);
        }

        @Override
        public void error(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        @Override
        public void error(Object o, Throwable throwable) {
            this.error(o);
        }

        @Override
        public void fatal(Object o) {
            VfsTask.this.log(String.valueOf(o), 0);
        }

        @Override
        public void fatal(Object o, Throwable throwable) {
            this.fatal(o);
        }

        @Override
        public void info(Object o) {
            VfsTask.this.log(String.valueOf(o), 2);
        }

        @Override
        public void info(Object o, Throwable throwable) {
            this.info(o);
        }

        @Override
        public void trace(Object o) {
        }

        @Override
        public void trace(Object o, Throwable throwable) {
        }

        @Override
        public void warn(Object o) {
            VfsTask.this.log(String.valueOf(o), 1);
        }

        @Override
        public void warn(Object o, Throwable throwable) {
            this.warn(o);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public boolean isFatalEnabled() {
            return true;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }
    }

    private class CloseListener
    implements SubBuildListener {
        private CloseListener() {
        }

        @Override
        public void subBuildStarted(BuildEvent buildEvent) {
        }

        @Override
        public void subBuildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        @Override
        public void buildFinished(BuildEvent event) {
            VfsTask.this.closeManager();
        }

        @Override
        public void buildStarted(BuildEvent event) {
        }

        @Override
        public void messageLogged(BuildEvent event) {
        }

        @Override
        public void targetFinished(BuildEvent event) {
        }

        @Override
        public void targetStarted(BuildEvent event) {
        }

        @Override
        public void taskFinished(BuildEvent event) {
        }

        @Override
        public void taskStarted(BuildEvent event) {
        }
    }
}

