/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.Getter;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayFieldSetter
implements Getter,
Setter {
    private final Object bean;
    private final Field f;
    private Object defaultArray;

    public ArrayFieldSetter(Object bean, Field f) {
        this.bean = bean;
        this.f = f;
        if (!f.getType().isArray()) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(f.getType()));
        }
        this.trySetDefault(bean);
    }

    private void trySetDefault(Object bean1) throws IllegalAccessError {
        try {
            this.doSetDefault(bean1);
        }
        catch (IllegalAccessException ex) {
            try {
                this.f.setAccessible(true);
                this.doSetDefault(bean1);
            }
            catch (IllegalAccessException ex1) {
                throw new IllegalAccessError(ex1.getMessage());
            }
        }
    }

    private void doSetDefault(Object bean) throws IllegalAccessException {
        this.defaultArray = this.f.get(bean);
    }

    @Override
    public FieldSetter asFieldSetter() {
        return new FieldSetter(this.bean, this.f);
    }

    @Override
    public AnnotatedElement asAnnotatedElement() {
        return this.f;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    public Class getType() {
        return this.f.getType().getComponentType();
    }

    public void addValue(Object value) {
        try {
            this.doAddValue(this.bean, value);
        }
        catch (IllegalAccessException ex) {
            this.f.setAccessible(true);
            try {
                this.doAddValue(this.bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void doAddValue(Object bean, Object value) throws IllegalAccessException {
        Object ary = this.f.get(bean);
        if (ary == null || ary == this.defaultArray) {
            ary = Array.newInstance(this.getType(), 1);
            Array.set(ary, 0, value);
        } else {
            int len = Array.getLength(ary);
            Object newAry = Array.newInstance(ary.getClass().getComponentType(), len + 1);
            System.arraycopy(ary, 0, newAry, 0, len);
            Array.set(newAry, len, value);
            ary = newAry;
        }
        this.f.set(bean, ary);
    }

    public List<Object> getValueList() {
        this.f.setAccessible(true);
        try {
            ArrayList<Object> r = new ArrayList<Object>();
            Object array = this.f.get(this.bean);
            int len = Array.getLength(array);
            for (int i = 0; i < len; ++i) {
                r.add(Array.get(array, i));
            }
            return r;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }
}

