/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.AbstractBasePane;
import com.googlecode.lanterna.gui2.BasePaneListener;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowListener;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractWindow
extends AbstractBasePane<Window>
implements Window {
    private String title;
    private WindowBasedTextGUI textGUI;
    private boolean visible;
    private TerminalSize lastKnownSize;
    private TerminalSize lastKnownDecoratedSize;
    private TerminalPosition lastKnownPosition;
    private TerminalPosition contentOffset;
    private Set<Window.Hint> hints;
    private WindowPostRenderer windowPostRenderer;
    private boolean closeWindowWithEscape;

    public AbstractWindow() {
        this("");
    }

    public AbstractWindow(String title) {
        this.title = title;
        this.textGUI = null;
        this.visible = true;
        this.contentOffset = TerminalPosition.TOP_LEFT_CORNER;
        this.lastKnownPosition = null;
        this.lastKnownSize = null;
        this.lastKnownDecoratedSize = null;
        this.closeWindowWithEscape = false;
        this.hints = new HashSet<Window.Hint>();
    }

    public void setCloseWindowWithEscape(boolean closeWindowWithEscape) {
        this.closeWindowWithEscape = closeWindowWithEscape;
    }

    @Override
    public void setTextGUI(WindowBasedTextGUI textGUI) {
        if (this.textGUI != null && textGUI != null) {
            throw new UnsupportedOperationException("Are you calling setTextGUI yourself? Please read the documentation in that case (this could also be a bug in Lanterna, please report it if you are sure you are not calling Window.setTextGUI(..) from your code)");
        }
        this.textGUI = textGUI;
    }

    @Override
    public WindowBasedTextGUI getTextGUI() {
        return this.textGUI;
    }

    public void setTitle(String title) {
        this.title = title;
        this.invalidate();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void draw(TextGUIGraphics graphics) {
        if (!graphics.getSize().equals(this.lastKnownSize)) {
            this.getComponent().invalidate();
        }
        this.setSize(graphics.getSize(), false);
        super.draw(graphics);
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        boolean handled = super.handleInput(key);
        if (!handled && this.closeWindowWithEscape && key.getKeyType() == KeyType.Escape) {
            this.close();
            return true;
        }
        return handled;
    }

    @Override
    public TerminalPosition toGlobal(TerminalPosition localPosition) {
        if (localPosition == null) {
            return null;
        }
        return this.lastKnownPosition.withRelative(this.contentOffset.withRelative(localPosition));
    }

    @Override
    public TerminalPosition fromGlobal(TerminalPosition globalPosition) {
        if (globalPosition == null || this.lastKnownPosition == null) {
            return null;
        }
        return globalPosition.withRelative(-this.lastKnownPosition.getColumn() - this.contentOffset.getColumn(), -this.lastKnownPosition.getRow() - this.contentOffset.getRow());
    }

    @Override
    public TerminalSize getPreferredSize() {
        return this.contentHolder.getPreferredSize();
    }

    @Override
    public void setHints(Collection<Window.Hint> hints) {
        this.hints = new HashSet<Window.Hint>(hints);
        this.invalidate();
    }

    @Override
    public Set<Window.Hint> getHints() {
        return Collections.unmodifiableSet(this.hints);
    }

    @Override
    public WindowPostRenderer getPostRenderer() {
        return this.windowPostRenderer;
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        this.addBasePaneListener(windowListener);
    }

    @Override
    public void removeWindowListener(WindowListener windowListener) {
        this.removeBasePaneListener(windowListener);
    }

    public void setWindowPostRenderer(WindowPostRenderer windowPostRenderer) {
        this.windowPostRenderer = windowPostRenderer;
    }

    @Override
    public final TerminalPosition getPosition() {
        return this.lastKnownPosition;
    }

    @Override
    public final void setPosition(TerminalPosition topLeft) {
        TerminalPosition oldPosition = this.lastKnownPosition;
        this.lastKnownPosition = topLeft;
        for (BasePaneListener listener : this.getBasePaneListeners()) {
            if (!(listener instanceof WindowListener)) continue;
            ((WindowListener)listener).onMoved(this, oldPosition, topLeft);
        }
    }

    @Override
    public final TerminalSize getSize() {
        return this.lastKnownSize;
    }

    @Override
    public void setSize(TerminalSize size) {
        this.setSize(size, true);
    }

    private void setSize(TerminalSize size, boolean invalidate) {
        TerminalSize oldSize = this.lastKnownSize;
        this.lastKnownSize = size;
        if (invalidate) {
            this.invalidate();
        }
        for (BasePaneListener listener : this.getBasePaneListeners()) {
            if (!(listener instanceof WindowListener)) continue;
            ((WindowListener)listener).onResized(this, oldSize, size);
        }
    }

    @Override
    public final TerminalSize getDecoratedSize() {
        return this.lastKnownDecoratedSize;
    }

    @Override
    public final void setDecoratedSize(TerminalSize decoratedSize) {
        this.lastKnownDecoratedSize = decoratedSize;
    }

    @Override
    public void setContentOffset(TerminalPosition offset) {
        this.contentOffset = offset;
    }

    @Override
    public void close() {
        if (this.textGUI != null) {
            this.textGUI.removeWindow(this);
        }
        this.setComponent(null);
    }

    @Override
    public void waitUntilClosed() {
        WindowBasedTextGUI textGUI = this.getTextGUI();
        if (textGUI != null) {
            textGUI.waitForWindowToClose(this);
        }
    }

    @Override
    Window self() {
        return this;
    }
}

