/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;

public class MessageDialog
extends DialogWindow {
    private MessageDialogButton result = null;

    MessageDialog(String title, String text, MessageDialogButton ... buttons) {
        super(title);
        if (buttons == null || buttons.length == 0) {
            buttons = new MessageDialogButton[]{MessageDialogButton.OK};
        }
        Panel buttonPanel = new Panel();
        buttonPanel.setLayoutManager(new GridLayout(buttons.length).setHorizontalSpacing(1));
        for (final MessageDialogButton button : buttons) {
            buttonPanel.addComponent(new Button(button.toString(), new Runnable(){

                @Override
                public void run() {
                    MessageDialog.this.result = button;
                    MessageDialog.this.close();
                }
            }));
        }
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager(new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        mainPanel.addComponent(new Label(text));
        mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false))).addTo(mainPanel);
        this.setComponent(mainPanel);
    }

    public MessageDialogButton showDialog(WindowBasedTextGUI textGUI) {
        this.result = null;
        super.showDialog(textGUI);
        return this.result;
    }

    public static MessageDialogButton showMessageDialog(WindowBasedTextGUI textGUI, String title, String text, MessageDialogButton ... buttons) {
        MessageDialogBuilder builder = new MessageDialogBuilder().setTitle(title).setText(text);
        if (buttons.length == 0) {
            builder.addButton(MessageDialogButton.OK);
        }
        for (MessageDialogButton button : buttons) {
            builder.addButton(button);
        }
        return builder.build().showDialog(textGUI);
    }
}

