/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.Symbols;
import com.googlecode.lanterna.TextCharacter;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AWTTerminalFontConfiguration {
    private static final Set<String> MONOSPACE_CHECK_OVERRIDE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("VL Gothic Regular", "NanumGothic", "WenQuanYi Zen Hei Mono", "WenQuanYi Zen Hei", "AR PL UMing TW", "AR PL UMing HK", "AR PL UMing CN")));
    private static Integer CHOSEN_FONT_SIZE = null;
    private final List<Font> fontPriority;
    private final int fontWidth;
    private final int fontHeight;
    private final boolean useAntiAliasing;
    private final BoldMode boldMode;
    private static final Set<Character> SYMBOLS_CACHE = new HashSet<Character>();

    private static List<Font> getDefaultWindowsFonts() {
        return Collections.unmodifiableList(Arrays.asList(new Font("Courier New", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("Monospaced", 0, AWTTerminalFontConfiguration.getFontSize())));
    }

    private static List<Font> getDefaultLinuxFonts() {
        return Collections.unmodifiableList(Arrays.asList(new Font("DejaVu Sans Mono", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("Monospaced", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("Ubuntu Mono", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("FreeMono", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("Liberation Mono", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("VL Gothic Regular", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("NanumGothic", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("WenQuanYi Zen Hei Mono", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("WenQuanYi Zen Hei", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("AR PL UMing TW", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("AR PL UMing HK", 0, AWTTerminalFontConfiguration.getFontSize()), new Font("AR PL UMing CN", 0, AWTTerminalFontConfiguration.getFontSize())));
    }

    private static List<Font> getDefaultFonts() {
        return Collections.unmodifiableList(Collections.singletonList(new Font("Monospaced", 0, AWTTerminalFontConfiguration.getFontSize())));
    }

    private static synchronized int getFontSize() {
        int primaryMonitorWidth;
        if (CHOSEN_FONT_SIZE != null) {
            return CHOSEN_FONT_SIZE;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (gs.length > 0 && (primaryMonitorWidth = gs[0].getDisplayMode().getWidth()) > 2000) {
            CHOSEN_FONT_SIZE = 28;
        }
        if (CHOSEN_FONT_SIZE == null) {
            CHOSEN_FONT_SIZE = 14;
        }
        return CHOSEN_FONT_SIZE;
    }

    protected static Font[] selectDefaultFont() {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.contains("win")) {
            List<Font> windowsFonts = AWTTerminalFontConfiguration.getDefaultWindowsFonts();
            return windowsFonts.toArray(new Font[windowsFonts.size()]);
        }
        if (osName.contains("linux")) {
            List<Font> linuxFonts = AWTTerminalFontConfiguration.getDefaultLinuxFonts();
            return linuxFonts.toArray(new Font[linuxFonts.size()]);
        }
        List<Font> defaultFonts = AWTTerminalFontConfiguration.getDefaultFonts();
        return defaultFonts.toArray(new Font[defaultFonts.size()]);
    }

    public static AWTTerminalFontConfiguration getDefault() {
        return AWTTerminalFontConfiguration.newInstance(AWTTerminalFontConfiguration.filterMonospaced(AWTTerminalFontConfiguration.selectDefaultFont()));
    }

    public static Font[] filterMonospaced(Font ... fonts) {
        ArrayList<Font> result = new ArrayList<Font>(fonts.length);
        for (Font font : fonts) {
            if (!AWTTerminalFontConfiguration.isFontMonospaced(font)) continue;
            result.add(font);
        }
        return result.toArray(new Font[result.size()]);
    }

    public static AWTTerminalFontConfiguration newInstance(Font ... fontsInOrderOfPriority) {
        return new AWTTerminalFontConfiguration(true, BoldMode.EVERYTHING_BUT_SYMBOLS, fontsInOrderOfPriority);
    }

    protected AWTTerminalFontConfiguration(boolean useAntiAliasing, BoldMode boldMode, Font ... fontsInOrderOfPriority) {
        if (fontsInOrderOfPriority == null || fontsInOrderOfPriority.length == 0) {
            throw new IllegalArgumentException("Must pass in a valid list of fonts to SwingTerminalFontConfiguration");
        }
        this.useAntiAliasing = useAntiAliasing;
        this.boldMode = boldMode;
        this.fontPriority = new ArrayList<Font>(Arrays.asList(fontsInOrderOfPriority));
        this.fontWidth = this.getFontWidth(this.fontPriority.get(0));
        this.fontHeight = this.getFontHeight(this.fontPriority.get(0));
        for (Font font : this.fontPriority) {
            if (AWTTerminalFontConfiguration.isFontMonospaced(font)) continue;
            throw new IllegalArgumentException("Font " + font + " isn't monospaced!");
        }
        for (int i = 1; i < this.fontPriority.size(); ++i) {
            Font font;
            font = this.fontPriority.get(i);
            while (this.getFontWidth(font) > this.fontWidth || this.getFontHeight(font) > this.fontHeight) {
                float newSize = font.getSize2D() - 0.5f;
                if ((double)newSize < 0.01) {
                    throw new IllegalStateException("Unable to shrink font " + (i + 1) + " to fit the size of highest priority font " + this.fontPriority.get(0));
                }
                font = font.deriveFont(newSize);
                this.fontPriority.set(i, font);
            }
        }
    }

    Font getFontForCharacter(TextCharacter character) {
        Font normalFont = this.getFontForCharacter(character.getCharacter());
        if ((this.boldMode == BoldMode.EVERYTHING || this.boldMode == BoldMode.EVERYTHING_BUT_SYMBOLS && this.isNotASymbol(character.getCharacter())) && character.isBold()) {
            normalFont = normalFont.deriveFont(1);
        }
        if (character.isItalic()) {
            normalFont = normalFont.deriveFont(2);
        }
        return normalFont;
    }

    private Font getFontForCharacter(char c) {
        for (Font font : this.fontPriority) {
            if (!font.canDisplay(c)) continue;
            return font;
        }
        return this.fontPriority.get(0);
    }

    int getFontWidth() {
        return this.fontWidth;
    }

    int getFontHeight() {
        return this.fontHeight;
    }

    boolean isAntiAliased() {
        return this.useAntiAliasing;
    }

    private static boolean isFontMonospaced(Font font) {
        if (MONOSPACE_CHECK_OVERRIDE.contains(font.getName())) {
            return true;
        }
        FontRenderContext frc = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        Rectangle2D iBounds = font.getStringBounds("i", frc);
        Rectangle2D mBounds = font.getStringBounds("W", frc);
        return iBounds.getWidth() == mBounds.getWidth();
    }

    private int getFontWidth(Font font) {
        return (int)font.getStringBounds("W", this.getFontRenderContext()).getWidth();
    }

    private int getFontHeight(Font font) {
        return (int)font.getStringBounds("W", this.getFontRenderContext()).getHeight();
    }

    private FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, this.useAntiAliasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
    }

    private boolean isNotASymbol(char character) {
        return !SYMBOLS_CACHE.contains(Character.valueOf(character));
    }

    static {
        for (Field field : Symbols.class.getFields()) {
            if (field.getType() != Character.TYPE || (field.getModifiers() & 0x10) == 0 || (field.getModifiers() & 8) == 0) continue;
            try {
                SYMBOLS_CACHE.add(Character.valueOf(field.getChar(null)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static enum BoldMode {
        EVERYTHING,
        EVERYTHING_BUT_SYMBOLS,
        NOTHING;

    }
}

