/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.filebot.Cache;
import net.filebot.InvalidResponseException;
import net.filebot.Logging;
import net.filebot.Resource;
import net.filebot.util.ByteBufferInputStream;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.util.JsonUtilities;
import net.filebot.web.WebRequest;
import org.w3c.dom.Document;

public class CachedResource<K, R>
implements Resource<R> {
    public static final int DEFAULT_RETRY_LIMIT = 2;
    public static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(5L);
    private K key;
    private Transform<K, URL> resource;
    private Fetch fetch;
    private Transform<ByteBuffer, ? extends Object> parse;
    private Transform<? super Object, R> cast;
    private Duration expirationTime;
    private int retryLimit;
    private Duration retryWait;
    private final Cache cache;

    public CachedResource(K key, Transform<K, URL> resource, Fetch fetch, Transform<ByteBuffer, ? extends Object> parse, Transform<? super Object, R> cast, Duration expirationTime, Cache cache) {
        this(key, resource, fetch, parse, cast, 2, DEFAULT_RETRY_DELAY, expirationTime, cache);
    }

    public CachedResource(K key, Transform<K, URL> resource, Fetch fetch, Transform<ByteBuffer, ? extends Object> parse, Transform<? super Object, R> cast, int retryLimit, Duration retryWait, Duration expirationTime, Cache cache) {
        this.key = key;
        this.resource = resource;
        this.fetch = fetch;
        this.parse = parse;
        this.cast = cast;
        this.expirationTime = expirationTime;
        this.retryLimit = retryLimit;
        this.retryWait = retryWait;
        this.cache = cache;
    }

    public synchronized CachedResource<K, R> fetch(Fetch fetch) {
        this.fetch = fetch;
        return this;
    }

    public synchronized CachedResource<K, R> expire(Duration expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public synchronized CachedResource<K, R> retry(int retryLimit) {
        this.retryLimit = retryLimit;
        return this;
    }

    @Override
    public synchronized R get() throws Exception {
        Object value = this.cache.computeIf(this.key, Cache.isStale(this.expirationTime), element -> {
            URL url = this.resource.transform(this.key);
            long lastModified = element == null ? 0L : element.getLatestOfCreationAndUpdateTime();
            try {
                ByteBuffer data = this.retry(() -> this.fetch.fetch(url, lastModified), this.retryLimit, this.retryWait);
                Logging.debug.finest(WebRequest.log(data));
                if (data == null && element != null && element.getObjectValue() != null) {
                    return element.getObjectValue();
                }
                if (data == null) {
                    throw new IOException(String.format("Response data is null: %s => %s", this.key, url));
                }
                return this.parse.transform(data);
            }
            catch (Exception e) {
                Logging.debug.log(Level.SEVERE, "Fetch failed: " + url, e);
                if (element == null || element.getObjectValue() == null) {
                    throw e;
                }
                return element.getObjectValue();
            }
        });
        try {
            return this.cast.transform(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to cast cached value: %s => %s (%s)", this.key, value, this.cache), e);
        }
    }

    protected <T> T retry(Callable<T> callable, int retryCount, Duration retryWaitTime) throws Exception {
        try {
            return callable.call();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            if (retryCount <= 0) {
                throw e;
            }
            Logging.debug.warning(Logging.format("Fetch failed: Try again in %d seconds (%d more) => %s", retryWaitTime.getSeconds(), retryCount, e));
            Thread.sleep(retryWaitTime.toMillis());
            return this.retry(callable, retryCount - 1, retryWaitTime.multipliedBy(2L));
        }
    }

    public static Transform<ByteBuffer, byte[]> getBytes() {
        return data -> {
            byte[] bytes = new byte[data.remaining()];
            data.get(bytes, 0, bytes.length);
            return bytes;
        };
    }

    public static Transform<ByteBuffer, byte[]> getBytes(Transform<InputStream, InputStream> decompressor) {
        return data -> {
            ByteBufferOutputStream buffer = new ByteBufferOutputStream(data.remaining());
            try (InputStream in = (InputStream)decompressor.transform(new ByteBufferInputStream((ByteBuffer)data));){
                buffer.transferFully(in);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return buffer.getByteArray();
        };
    }

    public static Transform<ByteBuffer, String> getText(Charset charset) {
        return data -> charset.decode((ByteBuffer)data).toString();
    }

    public static <T> Transform<T, String> validateXml(Transform<T, String> parse) {
        return object -> {
            String xml = (String)parse.transform(object);
            try {
                WebRequest.validateXml(xml);
                return xml;
            }
            catch (Exception e) {
                throw new InvalidResponseException("Invalid XML", xml, e);
            }
        };
    }

    public static <T> Transform<T, String> validateJson(Transform<T, String> parse) {
        return object -> {
            String json = (String)parse.transform(object);
            try {
                JsonUtilities.readJson(json);
                return json;
            }
            catch (Exception e) {
                throw new InvalidResponseException("Invalid JSON", json, e);
            }
        };
    }

    public static <T> Transform<T, Document> getXml(Transform<T, String> parse) {
        return object -> WebRequest.getDocument((String)parse.transform(object));
    }

    public static <T> Transform<T, Object> getJson(Transform<T, String> parse) {
        return object -> JsonUtilities.readJson((CharSequence)parse.transform(object));
    }

    public static Fetch fetchIfModified() {
        return CachedResource.fetchIfModified(Collections::emptyMap);
    }

    public static Fetch fetchIfModified(Supplier<Map<String, String>> requestParameters) {
        return (url, lastModified) -> {
            Logging.debug.fine(WebRequest.log(url, lastModified, null));
            try {
                return WebRequest.fetch(url, lastModified, null, (Map)requestParameters.get(), null);
            }
            catch (FileNotFoundException e) {
                return CachedResource.fileNotFound(url, e);
            }
        };
    }

    public static Fetch fetchIfNoneMatch(Transform<URL, ?> key, Cache cache) {
        Cache etagStorage = Cache.getCache(cache.getName() + "_etag", cache.getCacheType());
        return CachedResource.fetchIfNoneMatch((URL url) -> {
            try {
                return cache.get(key.transform((URL)url)) == null ? null : etagStorage.get(key.transform((URL)url));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (URL url, String etag) -> {
            try {
                etagStorage.put(key.transform((URL)url), etag);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Fetch fetchIfNoneMatch(Function<URL, Object> etagRetrieve, BiConsumer<URL, String> etagStore) {
        return (url, lastModified) -> {
            Object etagValue = etagRetrieve.apply(url);
            Logging.debug.fine(WebRequest.log(url, lastModified, etagValue));
            try {
                return WebRequest.fetch(url, etagValue == null ? lastModified : 0L, etagValue, null, CachedResource.storeETag(url, etagStore, etag -> !etag.equals(etagValue)));
            }
            catch (FileNotFoundException e) {
                return CachedResource.fileNotFound(url, e);
            }
        };
    }

    private static Consumer<Map<String, List<String>>> storeETag(URL url, BiConsumer<URL, String> etagStore, Predicate<String> etagFilter) {
        return responseHeaders -> WebRequest.getETag(responseHeaders).filter(etagFilter).ifPresent(etag -> {
            Logging.debug.finest(Logging.format("Store ETag: %s", etag));
            etagStore.accept(url, (String)etag);
        });
    }

    private static ByteBuffer fileNotFound(URL url, FileNotFoundException e) {
        Logging.debug.warning(Logging.format("Resource not found: %s", url));
        return ByteBuffer.allocate(0);
    }

    public static Fetch withPermit(Fetch fetch, Permit permit) {
        return (url, lastModified) -> {
            permit.acquire(url);
            return fetch.fetch(url, lastModified);
        };
    }

    @FunctionalInterface
    public static interface Permit {
        public void acquire(URL var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Fetch {
        public ByteBuffer fetch(URL var1, long var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Transform<T, R> {
        public R transform(T var1) throws Exception;
    }
}

