/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;

public class MediaTypes {
    private static Map<String, FileUtilities.ExtensionFileFilter> types = MediaTypes.getKnownMediaTypes();
    public static final FileUtilities.ExtensionFileFilter AUDIO_FILES = MediaTypes.getCategoryFilter("audio");
    public static final FileUtilities.ExtensionFileFilter VIDEO_FILES = MediaTypes.getCategoryFilter("video");
    public static final FileUtilities.ExtensionFileFilter SUBTITLE_FILES = MediaTypes.getCategoryFilter("subtitle");
    public static final FileUtilities.ExtensionFileFilter IMAGE_FILES = MediaTypes.getCategoryFilter("image");
    public static final FileUtilities.ExtensionFileFilter ARCHIVE_FILES = MediaTypes.getCategoryFilter("archive");
    public static final FileUtilities.ExtensionFileFilter VERIFICATION_FILES = MediaTypes.getCategoryFilter("verification");
    public static final FileUtilities.ExtensionFileFilter NFO_FILES = MediaTypes.getTypeFilter("application/nfo");
    public static final FileUtilities.ExtensionFileFilter LIST_FILES = MediaTypes.getTypeFilter("application/list");
    public static final FileUtilities.ExtensionFileFilter TORRENT_FILES = MediaTypes.getTypeFilter("application/torrent");

    private static Map<String, FileUtilities.ExtensionFileFilter> getKnownMediaTypes() {
        LinkedHashMap<String, FileUtilities.ExtensionFileFilter> types = new LinkedHashMap<String, FileUtilities.ExtensionFileFilter>(64);
        ResourceBundle bundle = ResourceBundle.getBundle(MediaTypes.class.getName());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String type = keys.nextElement();
            String[] extensions = RegularExpressions.SPACE.split(bundle.getString(type));
            types.put(type, new FileUtilities.ExtensionFileFilter(extensions));
        }
        return types;
    }

    public static void main(String[] args) {
        System.out.println(types);
    }

    public static String getMediaType(String extension) {
        for (Map.Entry<String, FileUtilities.ExtensionFileFilter> it : types.entrySet()) {
            if (!it.getValue().acceptExtension(extension)) continue;
            return it.getKey();
        }
        return null;
    }

    public static FileUtilities.ExtensionFileFilter getTypeFilter(String name) {
        return types.get(name);
    }

    public static FileUtilities.ExtensionFileFilter getCategoryFilter(String category) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Map.Entry<String, FileUtilities.ExtensionFileFilter> it : types.entrySet()) {
            if (!it.getKey().startsWith(category)) continue;
            Collections.addAll(extensions, it.getValue().extensions());
        }
        return new FileUtilities.ExtensionFileFilter(extensions);
    }
}

