/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import net.filebot.RenameAction;
import net.filebot.StandardRenameAction;
import net.filebot.util.FileUtilities;

public enum NativeRenameAction implements RenameAction
{
    MOVE,
    COPY;


    @Override
    public File rename(File src, File dst) {
        dst = FileUtilities.resolve(src, dst);
        this.rename(Collections.singletonMap(src, dst));
        return dst;
    }

    public void rename(Map<File, File> map) {
        ArrayList<File> src = new ArrayList<File>(map.size());
        ArrayList<File> dst = new ArrayList<File>(map.size());
        map.forEach((from, to) -> {
            src.add((File)from);
            dst.add(FileUtilities.resolve(from, to));
        });
        NativeRenameAction.SHFileOperation(this, NativeRenameAction.getPathArray(src), NativeRenameAction.getPathArray(dst));
    }

    private static void SHFileOperation(NativeRenameAction action, String[] src, String[] dst) {
        ShellAPI.SHFILEOPSTRUCT op = new ShellAPI.SHFILEOPSTRUCT();
        op.wFunc = NativeRenameAction.SHFileOperationFunction(action);
        op.fFlags = (short)2577;
        op.pFrom = op.encodePaths(src);
        op.pTo = op.encodePaths(dst);
        Shell32.INSTANCE.SHFileOperation(op);
        if (op.fAnyOperationsAborted) {
            throw new CancellationException(action.name() + " cancelled");
        }
    }

    private static int SHFileOperationFunction(NativeRenameAction action) {
        switch (action) {
            case MOVE: {
                return 1;
            }
            case COPY: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("SHFileOperation not supported: " + action);
    }

    private static String[] getPathArray(List<File> files) {
        return (String[])files.stream().map(File::getAbsolutePath).toArray(String[]::new);
    }

    public static boolean isSupported(StandardRenameAction action) {
        try {
            return Platform.isWindows() && (action == StandardRenameAction.MOVE || action == StandardRenameAction.COPY);
        }
        catch (Throwable e) {
            return false;
        }
    }
}

