/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.filebot.util.WeakValueHashMap;

public final class ResourceManager {
    private static final WeakValueHashMap<String, Icon> cache = new WeakValueHashMap(256);

    public static Icon getIcon(String name) {
        return ResourceManager.getIcon(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getIcon(String name, String def) {
        Icon icon = null;
        WeakValueHashMap<String, Icon> weakValueHashMap = cache;
        synchronized (weakValueHashMap) {
            icon = cache.get(name);
            if (icon != null) {
                return icon;
            }
        }
        URL resource = ResourceManager.getImageResource(name, def);
        if (resource == null) {
            return null;
        }
        Image image = ResourceManager.getImage(resource);
        icon = new ImageIcon(image);
        WeakValueHashMap<String, Icon> weakValueHashMap2 = cache;
        synchronized (weakValueHashMap2) {
            cache.put(name, icon);
        }
        return icon;
    }

    public static Stream<URL> getApplicationIconResources() {
        return Stream.of("window.icon.large", "window.icon.medium", "window.icon.small").map(ResourceManager::getImageResource);
    }

    public static List<Image> getApplicationIcons() {
        return ResourceManager.getApplicationIconResources().map(ResourceManager::getImage).collect(Collectors.toList());
    }

    public static Icon getFlagIcon(String languageCode) {
        return ResourceManager.getIcon("flags/" + languageCode);
    }

    public static Image getImage(String name) {
        return ResourceManager.getImage(ResourceManager.getImageResource(name));
    }

    private static Image getImage(URL resource) {
        return Toolkit.getDefaultToolkit().getImage(resource);
    }

    private static URL getImageResource(String name) {
        return ResourceManager.class.getResource("resources/" + name + ".png");
    }

    private static URL getImageResource(String name, String def) {
        URL resource = ResourceManager.getImageResource(name);
        if (resource == null) {
            resource = ResourceManager.getImageResource(def);
        }
        return resource;
    }

    private ResourceManager() {
        throw new UnsupportedOperationException();
    }
}

