/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.filebot.Logging;
import net.filebot.UserFiles;
import net.filebot.cli.ArgumentBean;
import net.filebot.util.PreferencesList;
import net.filebot.util.PreferencesMap;

public final class Settings {
    private static ArgumentBean applicationArguments;
    private final Preferences prefs;

    public static String getApplicationName() {
        return Settings.getApplicationProperty("application.name");
    }

    public static String getApplicationVersion() {
        return Settings.getApplicationProperty("application.version");
    }

    public static int getApplicationRevisionNumber() {
        try {
            return Integer.parseInt(Settings.getApplicationProperty("application.revision"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getApplicationProperty(String key) {
        return ResourceBundle.getBundle(Settings.class.getName(), Locale.ROOT).getString(key);
    }

    public static String getApiKey(String name) {
        if (Settings.isAppStore()) {
            return Settings.getApplicationProperty("com.apikey." + name);
        }
        return Settings.getApplicationProperty("apikey." + name);
    }

    public static boolean isUnixFS() {
        return Boolean.parseBoolean(System.getProperty("unixfs"));
    }

    public static boolean useNativeShell() {
        return Boolean.parseBoolean(System.getProperty("useNativeShell"));
    }

    public static boolean useGVFS() {
        return Boolean.parseBoolean(System.getProperty("useGVFS"));
    }

    public static boolean useExtendedFileAttributes() {
        return Boolean.parseBoolean(System.getProperty("useExtendedFileAttributes"));
    }

    public static boolean useCreationDate() {
        return Boolean.parseBoolean(System.getProperty("useCreationDate"));
    }

    public static boolean useRenameHistory() {
        return Boolean.parseBoolean(System.getProperty("application.rename.history", "true"));
    }

    public static String getApplicationDeployment() {
        return System.getProperty("application.deployment", "jar");
    }

    public static boolean isPortableApp() {
        return Settings.isApplicationDeployment("portable", "jar");
    }

    public static boolean isAppStore() {
        return Settings.isApplicationDeployment("mas", "appx");
    }

    public static boolean isWindowsApp() {
        return Settings.isApplicationDeployment("appx", "msi");
    }

    public static boolean isUbuntuApp() {
        return Settings.isApplicationDeployment("deb", "snap");
    }

    public static boolean isMacApp() {
        return Settings.isApplicationDeployment("mas", "app");
    }

    public static boolean isMacSandbox() {
        return Settings.isApplicationDeployment("mas");
    }

    public static boolean isAutoUpdateEnabled() {
        return Settings.isApplicationDeployment("mas", "appx", "snap", "spk", "aur");
    }

    private static boolean isApplicationDeployment(String ... ids) {
        String current = Settings.getApplicationDeployment();
        for (String id : ids) {
            if (current == null || !current.equals(id)) continue;
            return true;
        }
        return false;
    }

    public static String getApplicationUserModelID() {
        return System.getProperty("net.filebot.AppUserModelID", Settings.getApplicationName());
    }

    public static UserFiles.FileChooser getPreferredFileChooser() {
        return UserFiles.FileChooser.valueOf(System.getProperty("net.filebot.UserFiles.fileChooser", "Swing"));
    }

    public static int getPreferredThreadPoolSize() {
        try {
            String threadPool = System.getProperty("threadPool");
            if (threadPool != null) {
                return Integer.parseInt(threadPool);
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e.getMessage(), e);
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getAppStoreName() {
        if (Settings.isMacApp()) {
            return "Mac App Store";
        }
        if (Settings.isWindowsApp()) {
            return "Windows Store";
        }
        if (Settings.isUbuntuApp()) {
            return "Ubuntu Software Center";
        }
        return null;
    }

    public static String getAppStoreLink() {
        if (Settings.isMacApp()) {
            return Settings.getApplicationProperty("link.mas");
        }
        if (Settings.isWindowsApp()) {
            return Settings.getApplicationProperty("link.mws");
        }
        if (Settings.isUbuntuApp()) {
            return null;
        }
        return null;
    }

    public static String getDonateURL() {
        return Settings.getApplicationProperty("donate.url") + "?src=" + Settings.getApplicationDeployment();
    }

    public static String getEmbeddedHelpURL() {
        return Settings.getApplicationProperty("link.app.help") + "#" + Settings.getApplicationDeployment();
    }

    public static String getApplicationIdentifier() {
        return String.format("%s %s (r%d)", Settings.getApplicationName(), Settings.getApplicationVersion(), Settings.getApplicationRevisionNumber());
    }

    public static String getJavaRuntimeIdentifier() {
        return String.format("%s %s", System.getProperty("java.runtime.name"), System.getProperty("java.version"));
    }

    public static String getSystemIdentifier() {
        return String.format("%s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static void setApplicationArguments(ArgumentBean args) {
        applicationArguments = args;
    }

    public static ArgumentBean getApplicationArguments() {
        return applicationArguments;
    }

    public static Settings forPackage(Class<?> type) {
        return new Settings(Preferences.userNodeForPackage(type));
    }

    private Settings(Preferences prefs) {
        this.prefs = prefs;
    }

    public Settings node(String nodeName) {
        return new Settings(this.prefs.node(nodeName));
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String def) {
        return this.prefs.get(key, def);
    }

    public void put(String key, String value) {
        if (value != null) {
            this.prefs.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public PreferencesMap.PreferencesEntry<String> entry(String key) {
        return new PreferencesMap.PreferencesEntry<String>(this.prefs, key, new PreferencesMap.StringAdapter());
    }

    public PreferencesMap<String> asMap() {
        return PreferencesMap.map(this.prefs);
    }

    public <T> PreferencesMap<T> asMap(Class<T> cls) {
        return PreferencesMap.map(this.prefs, new PreferencesMap.JsonAdapter<T>(cls));
    }

    public PreferencesList<String> asList() {
        return PreferencesList.map(this.prefs);
    }

    public <T> PreferencesList<T> asList(Class<T> cls) {
        return PreferencesList.map(this.prefs, new PreferencesMap.JsonAdapter<T>(cls));
    }

    public void clear() {
        try {
            for (String nodeName : this.prefs.childrenNames()) {
                this.prefs.node(nodeName).removeNode();
            }
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            Logging.debug.warning(e.getMessage());
        }
    }
}

