/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.filebot.MediaTypes;
import net.filebot.archive.ApacheVFS;
import net.filebot.archive.ArchiveExtractor;
import net.filebot.archive.SevenZipExecutable;
import net.filebot.archive.SevenZipNativeBindings;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.util.SystemProperty;
import net.filebot.vfs.FileInfo;
import net.sf.sevenzipjbinding.ArchiveFormat;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;

public class Archive
implements Closeable {
    private final ArchiveExtractor extractor;
    private static final Pattern multiPartIndex = Pattern.compile("[.][0-9]{3}$");
    public static final FileFilter VOLUME_ONE_FILTER = new FileFilter(){
        private final Pattern volume = Pattern.compile("[.]r[0-9]+$|[.]part[0-9]+|[.][0-9]+$", 2);
        private final FileFilter archives = new FileUtilities.ExtensionFileFilter(Archive.getArchiveTypes());

        @Override
        public boolean accept(File path) {
            Integer i;
            if (!this.archives.accept(path) && !Archive.hasMultiPartIndex(path)) {
                return false;
            }
            Matcher matcher = this.volume.matcher(path.getName());
            return !matcher.find() || (i = StringUtilities.matchInteger(matcher.group())) != null && i == 1;
        }
    };

    public static Extractor getExtractor() {
        return SystemProperty.of("net.filebot.Archive.extractor", Extractor::valueOf, Extractor.SevenZipNativeBindings).get();
    }

    public static Archive open(File archive) throws Exception {
        return new Archive(Archive.getExtractor().newInstance(archive));
    }

    public Archive(ArchiveExtractor extractor) throws Exception {
        this.extractor = extractor;
    }

    public List<FileInfo> listFiles() throws Exception {
        return this.extractor.listFiles();
    }

    public void extract(File outputDir) throws Exception {
        this.extractor.extract(outputDir);
    }

    public void extract(File outputDir, FileFilter filter) throws Exception {
        this.extractor.extract(outputDir, filter);
    }

    @Override
    public void close() throws IOException {
        if (this.extractor instanceof Closeable) {
            ((Closeable)((Object)this.extractor)).close();
        }
    }

    public static String[] getArchiveTypes() {
        return (String[])Stream.of(MediaTypes.ARCHIVE_FILES.extensions(), Extractor.SevenZipNativeBindings.getSupportedTypes()).flatMap(Stream::of).distinct().toArray(String[]::new);
    }

    public static boolean hasMultiPartIndex(File file) {
        return multiPartIndex.matcher(file.getName()).find();
    }

    public static enum Extractor {
        SevenZipNativeBindings,
        SevenZipExecutable,
        ApacheVFS;


        public ArchiveExtractor newInstance(File archive) throws Exception {
            switch (this) {
                case SevenZipNativeBindings: {
                    return new SevenZipNativeBindings(archive);
                }
                case SevenZipExecutable: {
                    return new SevenZipExecutable(archive);
                }
            }
            return new ApacheVFS(archive);
        }

        public String[] getSupportedTypes() {
            switch (this) {
                case SevenZipNativeBindings: 
                case SevenZipExecutable: {
                    return (String[])Arrays.stream(ArchiveFormat.values()).map(ArchiveFormat::getMethodName).toArray(String[]::new);
                }
            }
            try {
                return VFS.getManager().getSchemes();
            }
            catch (FileSystemException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

