/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import net.filebot.ApplicationFolder;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.cli.CmdlineOperations;
import net.filebot.cli.ScriptShell;
import net.filebot.cli.ScriptShellMethods;
import net.filebot.cli.ScriptSource;
import net.filebot.util.TeePrintStream;
import net.filebot.util.ui.SwingUI;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTextScrollPane;

public class GroovyPad
extends JFrame {
    public static final String DEFAULT_SCRIPT = "runScript 'sysinfo'";
    protected MessageConsole console;
    protected TextEditorPane editor;
    protected TextEditorPane output;
    protected final ScriptShell shell;
    protected final Action run = SwingUI.newAction("Run", ResourceManager.getIcon("script.go"), this::runScript);
    protected final Action cancel = SwingUI.newAction("Cancel", ResourceManager.getIcon("script.cancel"), this::cancelScript);
    private Runner currentRunner = null;

    public GroovyPad() throws IOException {
        super("Groovy Pad");
        JSplitPane splitPane = new JSplitPane(0, true, this.createEditor(), this.createOutputLog());
        splitPane.setResizeWeight(0.7);
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)splitPane, "Center");
        JToolBar tools = new JToolBar("Run", 0);
        tools.setFloatable(true);
        tools.add(this.run);
        tools.add(this.cancel);
        tools.addSeparator();
        tools.add(SwingUI.newAction(DEFAULT_SCRIPT, ResourceManager.getIcon("status.info"), evt -> this.runScript(DEFAULT_SCRIPT)));
        c.add((Component)tools, "North");
        this.run.setEnabled(true);
        this.cancel.setEnabled(false);
        SwingUI.installAction(c, KeyStroke.getKeyStroke(116, 0), this.run);
        SwingUI.installAction(c, KeyStroke.getKeyStroke(82, 128), this.run);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                GroovyPad.this.cancel.actionPerformed(null);
                GroovyPad.this.console.unhook();
                try {
                    GroovyPad.this.editor.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.console = new MessageConsole(this.output);
        this.console.hook();
        this.shell = this.createScriptShell();
        this.editor.requestFocusInWindow();
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setSize(800, 600);
    }

    protected JComponent createEditor() {
        this.editor = new TextEditorPane(0, false);
        this.editor.setSyntaxEditingStyle("text/groovy");
        this.editor.setAutoscrolls(false);
        this.editor.setAnimateBracketMatching(false);
        this.editor.setAntiAliasingEnabled(true);
        this.editor.setAutoIndentEnabled(true);
        this.editor.setBracketMatchingEnabled(true);
        this.editor.setCloseCurlyBraces(true);
        this.editor.setClearWhitespaceLinesEnabled(true);
        this.editor.setCodeFoldingEnabled(true);
        this.editor.setHighlightSecondaryLanguages(false);
        this.editor.setRoundedSelectionEdges(false);
        this.editor.setTabsEmulated(false);
        try {
            File pad = ApplicationFolder.AppData.resolve("pad.groovy");
            if (!pad.exists()) {
                ScriptShellMethods.saveAs(DEFAULT_SCRIPT, pad);
            }
            this.editor.load(FileLocation.create(pad), "UTF-8");
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
        }
        return new RTextScrollPane(this.editor, true);
    }

    protected JComponent createOutputLog() throws IOException {
        this.output = new TextEditorPane(0, false);
        this.output.setEditable(false);
        this.output.setReadOnly(true);
        this.output.setAutoscrolls(true);
        this.output.setBackground(new Color(255, 255, 218));
        this.output.setSyntaxEditingStyle("text/plain");
        this.output.setAnimateBracketMatching(false);
        this.output.setAntiAliasingEnabled(true);
        this.output.setAutoIndentEnabled(false);
        this.output.setBracketMatchingEnabled(false);
        this.output.setCloseCurlyBraces(false);
        this.output.setClearWhitespaceLinesEnabled(false);
        this.output.setCodeFoldingEnabled(false);
        this.output.setHighlightCurrentLine(false);
        this.output.setHighlightSecondaryLanguages(false);
        this.output.setRoundedSelectionEdges(false);
        this.output.setTabsEmulated(false);
        return new RTextScrollPane(this.output, true);
    }

    protected ScriptShell createScriptShell() {
        try {
            return new ScriptShell(s -> ScriptSource.GITHUB_STABLE.getScriptProvider(s).getScript(s), new CmdlineOperations(), new HashMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runScript(ActionEvent evt) {
        try {
            this.editor.save();
        }
        catch (IOException e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
        }
        this.runScript(this.editor.getText());
    }

    public void runScript(String script) {
        if (this.currentRunner == null || this.currentRunner.isDone()) {
            this.currentRunner = new Runner(script){

                @Override
                protected void done() {
                    GroovyPad.this.run.setEnabled(true);
                    GroovyPad.this.cancel.setEnabled(false);
                }
            };
            this.run.setEnabled(false);
            this.cancel.setEnabled(true);
            this.output.setText(null);
            this.currentRunner.execute();
        }
    }

    protected void cancelScript(ActionEvent evt) {
        if (this.currentRunner != null && !this.currentRunner.isDone()) {
            this.currentRunner.cancel(true);
            this.currentRunner.getExecutionThread().stop();
            try {
                this.currentRunner.get(2L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e, e::getMessage);
            }
        }
    }

    public static class MessageConsole {
        private final PrintStream system_out = System.out;
        private final PrintStream system_err = System.err;
        private JTextComponent textComponent;

        public MessageConsole(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        public void hook() {
            try {
                System.setOut(new TeePrintStream(new ConsoleOutputStream(), true, "UTF-8", this.system_out));
                System.setErr(new TeePrintStream(new ConsoleOutputStream(), true, "UTF-8", this.system_err));
            }
            catch (UnsupportedEncodingException e) {
                Logging.debug.log(Level.WARNING, e, e::getMessage);
            }
        }

        public void unhook() {
            System.setOut(this.system_out);
            System.setErr(this.system_err);
        }

        private class ConsoleOutputStream
        extends ByteArrayOutputStream {
            private ConsoleOutputStream() {
            }

            @Override
            public void flush() {
                try {
                    String message = this.toString("UTF-8");
                    this.reset();
                    this.commit(message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private void commit(String line) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        int offset = MessageConsole.this.textComponent.getDocument().getLength();
                        MessageConsole.this.textComponent.getDocument().insertString(offset, line, null);
                        MessageConsole.this.textComponent.setCaretPosition(MessageConsole.this.textComponent.getDocument().getLength());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }

    protected class Runner
    extends SwingWorker<Object, Object> {
        private Thread executionThread;
        private Object result;

        public Runner(final String script) {
            this.executionThread = new Thread("GroovyPadRunner"){

                @Override
                public void run() {
                    try {
                        SimpleBindings bindings = new SimpleBindings();
                        bindings.put("__args", (Object)Settings.getApplicationArguments());
                        bindings.put("args", (Object)Settings.getApplicationArguments().getFiles(false));
                        Runner.this.result = GroovyPad.this.shell.evaluate(script, bindings);
                        SimpleBindings resultBindings = new SimpleBindings();
                        resultBindings.put("result", Runner.this.result);
                        if (Runner.this.result != null) {
                            GroovyPad.this.shell.evaluate("print('Result: '); println(result);", resultBindings);
                        } else {
                            GroovyPad.this.shell.evaluate("println();", resultBindings);
                        }
                    }
                    catch (ScriptException e) {
                        while (e.getCause() instanceof ScriptException) {
                            e = (ScriptException)e.getCause();
                        }
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
            this.executionThread.setDaemon(false);
            this.executionThread.setPriority(1);
        }

        @Override
        protected Object doInBackground() throws Exception {
            this.executionThread.start();
            this.executionThread.join();
            return this.result;
        }

        public Thread getExecutionThread() {
            return this.executionThread;
        }
    }
}

