/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import com.sun.jna.Platform;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.xml.MarkupBuilder;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.SimpleBindings;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.filebot.HistorySpooler;
import net.filebot.Logging;
import net.filebot.RenameAction;
import net.filebot.StandardRenameAction;
import net.filebot.WebServices;
import net.filebot.cli.ArgumentBean;
import net.filebot.cli.CmdlineInterface;
import net.filebot.cli.CmdlineOperationsTextUI;
import net.filebot.cli.ExecutableRenameAction;
import net.filebot.cli.GroovyRenameAction;
import net.filebot.cli.PseudoConsole;
import net.filebot.cli.ScriptDeath;
import net.filebot.cli.ScriptShell;
import net.filebot.format.AssociativeScriptObject;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.format.SuppressedThrowables;
import net.filebot.media.MediaDetection;
import net.filebot.media.XattrMetaInfo;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.util.FileUtilities;
import net.filebot.web.Movie;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public abstract class ScriptShellBaseClass
extends Script {
    private final Map<String, Object> defaultValues = Collections.synchronizedMap(new LinkedHashMap());

    public void setDefaultValues(Map<String, ?> values) {
        this.defaultValues.putAll(values);
    }

    public Map<String, Object> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            if (this.defaultValues.containsKey(property)) {
                return this.defaultValues.get(property);
            }
            throw e;
        }
    }

    private ArgumentBean getArgumentBean() {
        return (ArgumentBean)this.getBinding().getVariable("__args");
    }

    private ScriptShell getShell() {
        return (ScriptShell)this.getBinding().getVariable("__shell");
    }

    private CmdlineInterface getCLI() {
        return (CmdlineInterface)this.getBinding().getVariable("__cli");
    }

    public void include(String input) throws Throwable {
        try {
            this.executeScript(input, null, null, null);
        }
        catch (Exception e) {
            this.printException(e, true);
        }
    }

    public Object runScript(String input, String ... argv) throws Throwable {
        try {
            ArgumentBean args = argv == null || argv.length == 0 ? this.getArgumentBean() : new ArgumentBean(argv);
            return this.executeScript(input, Arrays.asList(this.getArgumentBean().getArgumentArray()), args.defines, args.getFiles(false));
        }
        catch (Exception e) {
            this.printException(e, true);
            return null;
        }
    }

    public Object executeScript(String input, Map<String, ?> bindings, Object ... args) throws Throwable {
        return this.executeScript(input, Arrays.asList(this.getArgumentBean().getArgumentArray()), bindings, FileUtilities.asFileList(args));
    }

    public Object executeScript(String input, List<String> argv, Map<String, ?> bindings, List<?> args) throws Throwable {
        SimpleBindings parameters = new SimpleBindings();
        if (bindings != null) {
            parameters.putAll((Map<? extends String, ? extends Object>)bindings);
        }
        parameters.put("__args", (Object)(argv != null ? new ArgumentBean(argv.toArray(new String[0])) : new ArgumentBean(new String[0])));
        parameters.put("args", (Object)(args != null ? FileUtilities.asFileList(args) : new ArrayList()));
        return this.getShell().runScript(input, parameters);
    }

    public Object tryQuietly(Closure<?> c) {
        try {
            return c.call();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object tryLogCatch(Closure<?> c) {
        try {
            return c.call();
        }
        catch (Exception e) {
            this.printException(e, false);
            return null;
        }
    }

    public void printException(Throwable t) {
        this.printException(t, false);
    }

    public void printException(Throwable t, boolean severe) {
        if (severe) {
            Logging.log.log(Level.SEVERE, Logging.trace(t));
        } else {
            Logging.log.log(Level.WARNING, Logging.cause(t));
        }
    }

    public void die(Object cause) throws Throwable {
        if (cause instanceof Throwable) {
            throw new ScriptDeath((Throwable)cause);
        }
        throw new ScriptDeath(String.valueOf(cause));
    }

    public ArgumentBean get_args() {
        return this.getArgumentBean();
    }

    public Map<String, String> get_def() {
        return Collections.unmodifiableMap(this.getArgumentBean().defines);
    }

    public AssociativeScriptObject get_system() {
        return new AssociativeScriptObject(System.getProperties(), property -> null);
    }

    public AssociativeScriptObject get_environment() {
        return new AssociativeScriptObject(System.getenv(), property -> null);
    }

    public Map<File, File> getRenameLog() throws IOException {
        return HistorySpooler.getInstance().getSessionHistory().getRenameMap();
    }

    public Map<File, File> getPersistentRenameLog() throws IOException {
        return HistorySpooler.getInstance().getCompleteHistory().getRenameMap();
    }

    public Map<File, File> getRenameLog(boolean complete) throws IOException {
        if (complete) {
            return HistorySpooler.getInstance().getCompleteHistory().getRenameMap();
        }
        return HistorySpooler.getInstance().getSessionHistory().getRenameMap();
    }

    public Logger getLog() {
        return Logging.log;
    }

    public Object getConsole() {
        return System.console() != null ? System.console() : PseudoConsole.getSystemConsole();
    }

    public Date getNow() {
        return new Date();
    }

    @Override
    public Object run() {
        return null;
    }

    public String getMediaInfo(File file, String format) throws Exception {
        ExpressionFormat formatter = new ExpressionFormat(format);
        try {
            return formatter.format(new MediaBindingBean(XattrMetaInfo.xattr.getMetaInfo(file), file));
        }
        catch (SuppressedThrowables e) {
            Logging.debug.finest(Logging.format("%s => %s", format, e));
            return null;
        }
    }

    public String detectSeriesName(Object files) throws Exception {
        return this.detectSeriesName(files, false);
    }

    public String detectAnimeName(Object files) throws Exception {
        return this.detectSeriesName(files, true);
    }

    public String detectSeriesName(Object files, boolean anime) throws Exception {
        List<File> input = FileUtilities.asFileList(files);
        if (input.isEmpty()) {
            return null;
        }
        List<String> names = MediaDetection.detectSeriesNames(input, anime, Locale.ENGLISH);
        return names == null || names.isEmpty() ? null : names.get(0);
    }

    public static SeasonEpisodeMatcher.SxE parseEpisodeNumber(Object object) {
        List<SeasonEpisodeMatcher.SxE> matches = MediaDetection.parseEpisodeNumber(object.toString(), true);
        return matches == null || matches.isEmpty() ? null : matches.get(0);
    }

    public Movie detectMovie(File file, boolean strict) {
        Object metaObject = XattrMetaInfo.xattr.getMetaInfo(file);
        if (metaObject instanceof Movie) {
            return (Movie)metaObject;
        }
        try {
            Movie match = MediaDetection.matchMovie(file, 4);
            if (match != null) {
                return match;
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e::toString);
        }
        try {
            List<Movie> options = MediaDetection.detectMovieWithYear(file, WebServices.TheMovieDB, Locale.US, strict);
            if (options != null && options.size() > 0) {
                return options.get(0);
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e::toString);
        }
        return null;
    }

    public Movie matchMovie(String name) {
        List<Movie> matches = MediaDetection.matchMovieName(Collections.singleton(name), true, 0);
        return matches == null || matches.isEmpty() ? null : matches.get(0);
    }

    public int execute(Object ... args) throws Exception {
        Stream<String> cmd = Arrays.stream(args).filter(Objects::nonNull).map(Objects::toString);
        if (Platform.isWindows()) {
            cmd = Stream.concat(Stream.of("powershell", "-NonInteractive", "-NoProfile", "-NoLogo", "-ExecutionPolicy", "Bypass", "-Command"), cmd);
        } else if (args.length == 1) {
            cmd = Stream.concat(Stream.of("sh", "-c"), cmd);
        }
        ProcessBuilder process = new ProcessBuilder(cmd.collect(Collectors.toList())).inheritIO();
        return process.start().waitFor();
    }

    public String XML(Closure<?> buildClosure) {
        StringWriter out = new StringWriter();
        MarkupBuilder builder = new MarkupBuilder(out);
        buildClosure.rehydrate(buildClosure.getDelegate(), builder, builder).call();
        return out.toString();
    }

    public void telnet(String host, int port, Closure<?> handler) throws IOException {
        try (Socket socket = new Socket(host, port);){
            handler.call(new PrintStream(socket.getOutputStream(), true, "UTF-8"), new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8")));
        }
    }

    public Object retry(int retryCountLimit, int retryWaitTime, Closure<?> c) throws InterruptedException {
        for (int i = 0; retryCountLimit < 0 || i <= retryCountLimit; ++i) {
            try {
                return c.call();
            }
            catch (Exception e) {
                if (i >= 0 && i >= retryCountLimit) {
                    throw e;
                }
                Thread.sleep(retryWaitTime);
                continue;
            }
        }
        return null;
    }

    public List<File> rename(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        Map<File, File> map = files.isEmpty() ? this.getInputFileMap(parameters) : Collections.emptyMap();
        RenameAction action = this.getRenameAction(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            if (files.size() > 0) {
                return this.getCLI().rename(files, action, args.getConflictAction(), args.getAbsoluteOutputFolder(), args.getExpressionFileFormat(), args.getDatasource(), args.getSearchQuery(), args.getSortOrder(), args.getExpressionFilter(), args.getLanguage().getLocale(), args.isStrict(), args.getExecCommand());
            }
            if (map.size() > 0) {
                return this.getCLI().rename(map, action, args.getConflictAction());
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
        return null;
    }

    public List<File> getSubtitles(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().getSubtitles(files, args.getSearchQuery(), args.getLanguage(), args.getSubtitleOutputFormat(), args.getEncoding(), args.getSubtitleNamingFormat(), args.isStrict());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public List<File> getMissingSubtitles(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().getMissingSubtitles(files, args.getSearchQuery(), args.getLanguage(), args.getSubtitleOutputFormat(), args.getEncoding(), args.getSubtitleNamingFormat(), args.isStrict());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public boolean check(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        try {
            return this.getCLI().check(files);
        }
        catch (Exception e) {
            this.printException(e);
            return false;
        }
    }

    public File compute(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().compute(files, args.getOutputPath(), args.getOutputHashType(), args.getEncoding());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public List<File> extract(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        FileFilter filter = this.getFileFilter(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().extract(files, args.getOutputPath(), args.getConflictAction(), filter, args.isStrict());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public List<String> fetchEpisodeList(Map<String, ?> parameters) throws Exception {
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().fetchEpisodeList(args.getEpisodeListProvider(), args.getSearchQuery(), args.getExpressionFormat(), args.getExpressionFilter(), args.getSortOrder(), args.getLanguage().getLocale(), args.isStrict()).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    public Object getMediaInfo(Map<String, ?> parameters) throws Exception {
        List<File> files = this.getInputFileList(parameters);
        ArgumentBean args = this.getArgumentBean(parameters);
        try {
            return this.getCLI().getMediaInfo(files, args.getFileFilter(), args.getExpressionFormat());
        }
        catch (Exception e) {
            this.printException(e);
            return null;
        }
    }

    private ArgumentBean getArgumentBean(Map<String, ?> parameters) throws Exception {
        ArgumentBean args = new ArgumentBean(this.getArgumentBean().getArgumentArray());
        Stream.of("forceExtractAll", "strict").map(parameters::remove).filter(Objects::nonNull).forEach(v -> {
            args.nonStrict = !DefaultTypeTransformation.castToBoolean(v);
        });
        parameters.forEach((k, v) -> {
            try {
                Field field = args.getClass().getField((String)k);
                Object value = DefaultTypeTransformation.castToType(v, field.getType());
                field.set(args, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal parameter: " + k, e);
            }
        });
        return args;
    }

    private List<File> getInputFileList(Map<String, ?> parameters) {
        return this.consumeParameter(parameters, "file").map(f -> FileUtilities.asFileList(f)).findFirst().orElseGet(() -> this.consumeParameter(parameters, "folder").flatMap(f -> FileUtilities.asFileList(f).stream()).flatMap(f -> FileUtilities.getChildren(f, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER).stream()).collect(Collectors.toList()));
    }

    private Map<File, File> getInputFileMap(Map<String, ?> parameters) {
        LinkedHashMap<File, File> map = new LinkedHashMap<File, File>();
        this.consumeParameter(parameters, "map").map(Map.class::cast).forEach(m -> m.forEach((k, v) -> {
            File from = FileUtilities.asFileList(k).get(0);
            File to = FileUtilities.asFileList(v).get(0);
            map.put(from, to);
        }));
        return map;
    }

    private RenameAction getRenameAction(Map<String, ?> parameters) {
        return this.consumeParameter(parameters, "action").map(action -> this.getRenameAction(action)).findFirst().orElse(this.getArgumentBean().getRenameAction());
    }

    private FileFilter getFileFilter(Map<String, ?> parameters) {
        return this.consumeParameter(parameters, "filter").map(filter -> (FileFilter)DefaultTypeTransformation.castToType(filter, FileFilter.class)).findFirst().orElse(null);
    }

    private Stream<?> consumeParameter(Map<String, ?> parameters, String ... names) {
        return Stream.of(names).map(parameters::remove).filter(Objects::nonNull);
    }

    public RenameAction getRenameAction(Object obj) {
        if (obj instanceof RenameAction) {
            return (RenameAction)obj;
        }
        if (obj instanceof CharSequence) {
            return StandardRenameAction.forName(obj.toString());
        }
        if (obj instanceof File) {
            return new ExecutableRenameAction(obj.toString(), this.getArgumentBean().getOutputPath());
        }
        if (obj instanceof Closure) {
            return new GroovyRenameAction((Closure)obj);
        }
        return (RenameAction)DefaultTypeTransformation.castToType(obj, RenameAction.class);
    }

    public <T> T showInputDialog(Collection<T> options, String title, String message) throws Exception {
        if (options.isEmpty()) {
            return null;
        }
        if (this.getCLI() instanceof CmdlineOperationsTextUI) {
            CmdlineOperationsTextUI cli = (CmdlineOperationsTextUI)this.getCLI();
            return cli.showInputDialog(options, title, message);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            ArrayList selection = new ArrayList(1);
            SwingUtilities.invokeAndWait(() -> {
                Object value = JOptionPane.showInputDialog(null, message, title, 3, null, options.toArray(), options.iterator().next());
                selection.add(0, value);
            });
            return (T)selection.get(0);
        }
        Logging.log.log(Level.CONFIG, Logging.format("Auto-Select [%s] from %s", options.iterator().next(), options));
        return options.iterator().next();
    }
}

