/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.Bindings;
import net.filebot.format.BindingException;
import net.filebot.format.Define;
import net.filebot.format.ExpressionFormatFunctions;
import net.filebot.util.ExceptionUtilities;

public class ExpressionBindings
extends AbstractMap<String, Object>
implements Bindings {
    protected final Object bindingBean;
    protected final Map<String, Method> bindings = new TreeMap<String, Method>(String.CASE_INSENSITIVE_ORDER);
    protected final Method undefined;

    public ExpressionBindings(Object bindingBean) {
        this.bindingBean = bindingBean;
        for (Method method : bindingBean.getClass().getMethods()) {
            Define define = method.getAnnotation(Define.class);
            if (define == null) continue;
            for (String name : define.value()) {
                Method existingBinding = this.bindings.put(name, method);
                if (existingBinding == null) continue;
                throw new IllegalArgumentException(String.format("Illegal binding {%s} on %s", name, method.getName()));
            }
        }
        this.undefined = this.bindings.remove("");
    }

    protected boolean isUndefined(Object value) {
        return value == null || ExpressionFormatFunctions.isEmptyValue(value);
    }

    public Object getBindingBean() {
        return this.bindingBean;
    }

    @Override
    public Object get(Object key) {
        Method method = this.bindings.get(key);
        if (method != null) {
            try {
                Object value = method.invoke(this.bindingBean, new Object[0]);
                if (!this.isUndefined(value)) {
                    return value;
                }
                if (this.undefined != null) {
                    return this.undefined.invoke(this.bindingBean, key);
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof BindingException) {
                    throw (BindingException)e.getCause();
                }
                throw new BindingException(key, ExceptionUtilities.getRootCauseMessage(e), e);
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.bindings.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        for (final String key : this.keySet()) {
            entrySet.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return ExpressionBindings.this.get(key);
                }

                @Override
                public Object setValue(Object value) {
                    return ExpressionBindings.this.put(key, value);
                }
            });
        }
        return entrySet;
    }
}

