/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import com.sun.jna.Platform;
import groovy.lang.Closure;
import groovy.util.XmlSlurper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.ApplicationFolder;
import net.filebot.Settings;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;

public class ExpressionFormatFunctions {
    public static Object call(Object object) {
        if (object instanceof Closure) {
            try {
                return ExpressionFormatFunctions.call(((Closure)object).call());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (ExpressionFormatFunctions.isEmptyValue(object)) {
            return null;
        }
        return object;
    }

    public static boolean isEmptyValue(Object object) {
        if (object instanceof CharSequence && object.toString().isEmpty()) {
            return true;
        }
        return object instanceof Collection && ((Collection)object).isEmpty();
    }

    public static Object any(Object c1, Object c2, Object ... cN) {
        return ExpressionFormatFunctions.stream(c1, c2, cN).findFirst().orElse(null);
    }

    public static List<Object> allOf(Object c1, Object c2, Object ... cN) {
        return ExpressionFormatFunctions.stream(c1, c2, cN).collect(Collectors.toList());
    }

    public static String concat(Object c1, Object c2, Object ... cN) {
        return ExpressionFormatFunctions.stream(c1, c2, cN).map(Objects::toString).collect(Collectors.joining());
    }

    protected static Stream<Object> stream(Object c1, Object c2, Object ... cN) {
        return Stream.concat(Stream.of(c1, c2), Stream.of(cN)).map(ExpressionFormatFunctions::call).filter(Objects::nonNull);
    }

    public static String quote(Object c1, Object ... cN) {
        return Platform.isWindows() ? ExpressionFormatFunctions.quotePowerShell(c1, cN) : ExpressionFormatFunctions.quoteBash(c1, cN);
    }

    public static String quoteBash(Object c1, Object ... cN) {
        return ExpressionFormatFunctions.stream(c1, null, cN).map(Objects::toString).map(s -> "'" + s.replace("'", "'\"'\"'") + "'").collect(Collectors.joining(" "));
    }

    public static String quotePowerShell(Object c1, Object ... cN) {
        return ExpressionFormatFunctions.stream(c1, null, cN).map(Objects::toString).map(s -> "@'\n" + s + "\n'@").collect(Collectors.joining(" "));
    }

    public static Map<String, String> csv(Object path) throws IOException {
        Pattern[] delimiter = new Pattern[]{RegularExpressions.TAB, RegularExpressions.SEMICOLON};
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        block0: for (String line : ExpressionFormatFunctions.readLines(path)) {
            for (Pattern d : delimiter) {
                String[] field = d.split(line, 2);
                if (field.length < 2) continue;
                map.put(field[0].trim(), field[1].trim());
                continue block0;
            }
        }
        return map;
    }

    public static List<String> readLines(Object path) throws IOException {
        return FileUtilities.readLines(ExpressionFormatFunctions.getUserFile(path));
    }

    public static Object readXml(Object path) throws Exception {
        return new XmlSlurper().parse(ExpressionFormatFunctions.getUserFile(path));
    }

    public static File getUserFile(Object path) {
        File f = new File(path.toString());
        if (!f.isAbsolute()) {
            f = ApplicationFolder.UserHome.resolve(f.getPath());
        }
        if (Settings.isMacSandbox()) {
            MacAppUtilities.askUnlockFolders(null, Collections.singleton(f));
        }
        return f;
    }

    private ExpressionFormatFunctions() {
        throw new UnsupportedOperationException();
    }
}

