/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import com.ibm.icu.text.Transliterator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.Normalizer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.filebot.Language;
import net.filebot.MediaTypes;
import net.filebot.WebServices;
import net.filebot.format.ExpressionFormatFunctions;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.Normalization;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeInfo;
import net.filebot.web.Person;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ExpressionFormatMethods {
    public static String lower(String self) {
        return self.toLowerCase();
    }

    public static String upper(String self) {
        return self.toUpperCase();
    }

    public static String pad(String self, int length, String padding) {
        while (((String)self).length() < length) {
            self = padding + (String)self;
        }
        return self;
    }

    public static String pad(String self, int length) {
        return ExpressionFormatMethods.pad(self, length, "0");
    }

    public static String pad(Number self, int length) {
        return ExpressionFormatMethods.pad(self.toString(), length, "0");
    }

    public static double round(Number self, int precision) {
        return DefaultGroovyMethods.round(self.doubleValue(), precision);
    }

    public static String match(String self, String pattern) throws Exception {
        return ExpressionFormatMethods.match(self, pattern, -1);
    }

    public static String match(String self, String pattern, int matchGroup) throws Exception {
        Matcher matcher = Pattern.compile(pattern, 266).matcher(self);
        if (matcher.find()) {
            return ExpressionFormatMethods.firstCapturingGroup(matcher, matchGroup);
        }
        throw new Exception("Pattern not found: " + self);
    }

    public static List<String> matchAll(String self, String pattern) throws Exception {
        return ExpressionFormatMethods.matchAll(self, pattern, -1);
    }

    public static List<String> matchAll(String self, String pattern, int matchGroup) throws Exception {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = Pattern.compile(pattern, 266).matcher(self);
        while (matcher.find()) {
            matches.add(ExpressionFormatMethods.firstCapturingGroup(matcher, matchGroup));
        }
        if (matches.isEmpty()) {
            throw new Exception("Pattern not found: " + self);
        }
        return matches;
    }

    public static String firstCapturingGroup(Matcher self, int matchGroup) throws Exception {
        int g;
        int n = matchGroup < 0 ? (self.groupCount() > 0 ? 1 : 0) : (g = matchGroup);
        if (g == 0) {
            return self.group();
        }
        return IntStream.rangeClosed(g, self.groupCount()).mapToObj(self::group).filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0).findFirst().orElseThrow(() -> new Exception(String.format("Capturing group %d not found", g)));
    }

    public static String replaceAll(String self, String pattern) {
        return self.replaceAll(pattern, "");
    }

    public static String removeAll(String self, String pattern) {
        return Pattern.compile(pattern, 266).matcher(self).replaceAll("").trim();
    }

    public static String removeIllegalCharacters(String self) {
        return FileUtilities.validateFileName(Normalization.normalizeQuotationMarks(self));
    }

    public static String space(String self, String replacement) {
        return Normalization.normalizeSpace(self, replacement);
    }

    public static String colon(String self, String colon) {
        return RegularExpressions.COLON.matcher(self).replaceAll(colon);
    }

    public static String colon(String self, String ratio, String colon) {
        return RegularExpressions.COLON.matcher(RegularExpressions.RATIO.matcher(self).replaceAll(ratio)).replaceAll(colon);
    }

    public static String slash(String self, String replacement) {
        return RegularExpressions.SLASH.matcher(self).replaceAll(replacement);
    }

    public static String upperInitial(String self) {
        return ExpressionFormatMethods.replaceHeadTail(self, String::toUpperCase, String::toString);
    }

    public static String lowerTrail(String self) {
        return ExpressionFormatMethods.replaceHeadTail(self, String::toString, String::toLowerCase);
    }

    public static String replaceHeadTail(String self, Function<String, String> head, Function<String, String> tail) {
        Matcher matcher = Pattern.compile("\\b(['`\u00b4]|\\p{Alnum})(\\p{Alnum}*)\\b", 256).matcher(self);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, head.apply(matcher.group(1)) + tail.apply(matcher.group(2)));
        }
        return matcher.appendTail(buffer).toString();
    }

    public static String sortName(String self) {
        return ExpressionFormatMethods.sortName(self, "$2");
    }

    public static String sortName(String self, String replacement) {
        return Pattern.compile("^(The|A|An)\\s(.+)", 258).matcher(self).replaceFirst(replacement).trim();
    }

    public static String sortInitial(String self) {
        char c = ExpressionFormatMethods.ascii(ExpressionFormatMethods.sortName(self)).charAt(0);
        if (Character.isDigit(c)) {
            return "0-9";
        }
        if (Character.isLetter(c)) {
            return String.valueOf(c).toUpperCase();
        }
        return null;
    }

    public static String acronym(String self) {
        return Pattern.compile("\\s|\\B\\p{Alnum}+", 256).matcher(ExpressionFormatMethods.space(ExpressionFormatMethods.sortName(self), " ")).replaceAll("");
    }

    public static String truncate(String self, int limit) {
        if (limit >= self.length()) {
            return self;
        }
        return self.substring(0, limit);
    }

    public static String truncate(String self, int hardLimit, String nonWordPattern) {
        if (hardLimit >= self.length()) {
            return self;
        }
        int softLimit = 0;
        Matcher matcher = Pattern.compile(nonWordPattern, 258).matcher(self);
        while (matcher.find() && matcher.start() <= hardLimit) {
            softLimit = matcher.start();
        }
        return ExpressionFormatMethods.truncate(self, softLimit);
    }

    public static String before(String self, String pattern) {
        Matcher matcher = Pattern.compile(pattern, 258).matcher(self);
        return matcher.find() ? self.substring(0, matcher.start()).trim() : self;
    }

    public static String after(String self, String pattern) {
        Matcher matcher = Pattern.compile(pattern, 258).matcher(self);
        return matcher.find() ? self.substring(matcher.end(), self.length()).trim() : self;
    }

    public static boolean findMatch(String self, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return false;
        }
        return Pattern.compile(pattern, 258).matcher(self).find();
    }

    public static boolean findWordMatch(String self, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return false;
        }
        return ExpressionFormatMethods.findMatch(self, "\\b(" + pattern + ")\\b");
    }

    public static String replaceTrailingBrackets(String self) {
        return ExpressionFormatMethods.replaceTrailingBrackets(self, "");
    }

    public static String replaceTrailingBrackets(String self, String replacement) {
        return Pattern.compile("\\s*[(]([^)]*)[)]$", 256).matcher(self).replaceAll(replacement);
    }

    public static String replacePart(String self) {
        return ExpressionFormatMethods.replacePart(self, "");
    }

    public static String replacePart(String self, String replacement) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"\\s*[(](\\w+)[)]$", "\\W+Part (\\w+)\\W*$"}) {
            Matcher matcher = Pattern.compile(pattern, 258).matcher(self);
            if (!matcher.find()) continue;
            return matcher.replaceAll(replacement).trim();
        }
        return self;
    }

    public static String roman(String self) {
        TreeMap<Integer, String> numerals = new TreeMap<Integer, String>();
        numerals.put(10, "X");
        numerals.put(9, "IX");
        numerals.put(5, "V");
        numerals.put(4, "IV");
        numerals.put(1, "I");
        StringBuffer s = new StringBuffer();
        Matcher m = Pattern.compile("\\b\\d+\\b").matcher(self);
        while (m.find()) {
            int n = Integer.parseInt(m.group());
            m.appendReplacement(s, n >= 1 && n <= 12 ? ExpressionFormatMethods.roman(n, numerals) : m.group());
        }
        return m.appendTail(s).toString();
    }

    public static String roman(Integer n, TreeMap<Integer, String> numerals) {
        int l = numerals.floorKey(n);
        if (n == l) {
            return numerals.get(n);
        }
        return numerals.get(l) + ExpressionFormatMethods.roman(n - l, numerals);
    }

    public static String transliterate(String self, String transformIdentifier) {
        return Transliterator.getInstance(transformIdentifier).transform(self);
    }

    public static String ascii(String self) {
        return ExpressionFormatMethods.ascii(self, " ");
    }

    public static String ascii(String self, String fallback) {
        return Transliterator.getInstance("Any-Latin;Latin-ASCII;[:Diacritic:]remove").transform(ExpressionFormatMethods.asciiQuotes(self)).replaceAll("\\P{ASCII}+", fallback).trim();
    }

    public static String asciiQuotes(String self) {
        return Normalization.normalizeQuotationMarks(self);
    }

    public static boolean isLatin(String self) {
        return Normalizer.normalize(self, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}", "").matches("\\p{InBasicLatin}+");
    }

    public static String replace(String self, Map<?, ?> replace) {
        for (Map.Entry<?, ?> it : replace.entrySet()) {
            if (it.getKey() instanceof Pattern) {
                self = ((Pattern)it.getKey()).matcher(self).replaceAll(it.getValue().toString());
                continue;
            }
            self = self.replace(it.getKey().toString(), it.getValue().toString());
        }
        return self;
    }

    public static String joining(Collection<?> self, String delimiter) throws Exception {
        CharSequence[] list = (String[])self.stream().filter(Objects::nonNull).map(Objects::toString).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (list.length > 0) {
            return String.join((CharSequence)delimiter, list);
        }
        throw new Exception("Collection did not yield any values: " + self);
    }

    public static String joiningDistinct(Collection<?> self, String delimiter, Closure<?> ... mapper) throws Exception {
        CharSequence[] list;
        Stream<Object> stream = self.stream().filter(Objects::nonNull);
        if (mapper.length > 0) {
            stream = stream.flatMap(v -> Arrays.stream(mapper).map(m -> m.call(v)).filter(Objects::nonNull));
        }
        if ((list = (String[])stream.map(Objects::toString).filter(s -> !s.isEmpty()).distinct().sorted().toArray(String[]::new)).length > 0) {
            return String.join((CharSequence)delimiter, list);
        }
        throw new Exception("Collection did not yield any values: " + self);
    }

    public static Object check(Object self, Closure<?> c) throws Exception {
        if (DefaultTypeTransformation.castToBoolean(c.call(self))) {
            return self;
        }
        throw new Exception("Object failed check: " + self);
    }

    public static File derive(File self, Object tag, Object ... tagN) {
        Matcher nameMatcher;
        String name = FileUtilities.getName(self);
        Object extension = self.getName().substring(name.length());
        if (MediaTypes.SUBTITLE_FILES.accept(self) && (nameMatcher = MediaDetection.releaseInfo.getSubtitleLanguageTagPattern().matcher(name)).find()) {
            extension = name.substring(nameMatcher.start() - 1) + (String)extension;
            name = name.substring(0, nameMatcher.start() - 1);
        }
        return new File(self.getParentFile(), ExpressionFormatFunctions.concat(name, ExpressionFormatMethods.slash(ExpressionFormatFunctions.concat(tag, null, tagN), ""), extension));
    }

    public static File getRoot(File self) {
        return FileUtilities.listPath(self).get(0);
    }

    public static File getTail(File self) {
        return FileUtilities.getRelativePathTail(self, FileUtilities.listPath(self).size() - 1);
    }

    public static List<File> listPath(File self) {
        return FileUtilities.listPath(self);
    }

    public static List<File> listPath(File self, int tailSize) {
        return FileUtilities.listPath(FileUtilities.getRelativePathTail(self, tailSize));
    }

    public static File getRelativePathTail(File self, int tailSize) {
        return FileUtilities.getRelativePathTail(self, tailSize);
    }

    public static long getDiskSpace(File self) {
        List<File> list = FileUtilities.listPath(self);
        for (int i = list.size() - 1; i >= 0; --i) {
            long usableSpace;
            if (!list.get(i).exists() || (usableSpace = list.get(i).getUsableSpace()) <= 0L) continue;
            return usableSpace;
        }
        return 0L;
    }

    public static long getCreationDate(File self) throws IOException {
        BasicFileAttributes attr = Files.getFileAttributeView(self.toPath(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        long creationDate = attr.creationTime().toMillis();
        if (creationDate > 0L) {
            return creationDate;
        }
        return attr.lastModifiedTime().toMillis();
    }

    public static File toFile(String self) {
        if (self == null || self.isEmpty()) {
            return null;
        }
        return new File(self);
    }

    public static File toFile(String self, String parent) {
        if (self == null || self.isEmpty()) {
            return null;
        }
        File file = new File(self);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, self);
    }

    public static Locale toLocale(String self) {
        return Locale.forLanguageTag(self);
    }

    public static String plus(String self, Closure<?> other) {
        return ExpressionFormatFunctions.concat(self, other, new Object[0]);
    }

    public static String plus(Closure<?> self, Object other) {
        return ExpressionFormatFunctions.concat(self, other, new Object[0]);
    }

    public static String plus(Language self, Object other) {
        return ExpressionFormatFunctions.concat(self, other, new Object[0]);
    }

    public static String plus(SimpleDate self, Object other) {
        return ExpressionFormatFunctions.concat(self, other, new Object[0]);
    }

    public static List<?> bounds(Iterable<?> self) {
        return Stream.of(DefaultGroovyMethods.min(self), DefaultGroovyMethods.max(self)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static String format(Temporal self, String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH).format(self);
    }

    public static String format(TemporalAmount self, String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH).format(LocalTime.MIDNIGHT.plus(self));
    }

    public static EpisodeInfo getInfo(Episode self) throws Exception {
        if (WebServices.TheTVDB.getIdentifier().equals(self.getSeriesInfo().getDatabase())) {
            return WebServices.TheTVDB.getEpisodeInfo(self.getId(), Locale.ENGLISH);
        }
        return null;
    }

    public static List<String> getActors(SeriesInfo self) throws Exception {
        if (WebServices.TheTVDB.getIdentifier().equals(self.getDatabase())) {
            return WebServices.TheTVDB.getActors(self.getId(), Locale.ENGLISH).stream().map(Person::getName).collect(Collectors.toList());
        }
        return null;
    }

    private ExpressionFormatMethods() {
        throw new UnsupportedOperationException();
    }
}

