/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.filebot.ApplicationFolder;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.MetaAttributeView;
import net.filebot.Resource;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.format.AssociativeEnumObject;
import net.filebot.format.AssociativeScriptObject;
import net.filebot.format.BindingException;
import net.filebot.format.Define;
import net.filebot.format.DynamicBindings;
import net.filebot.format.ExpressionBindings;
import net.filebot.format.ExpressionFormatMethods;
import net.filebot.format.PropertyBindings;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationUtilities;
import net.filebot.media.MediaDetection;
import net.filebot.media.MetaAttributes;
import net.filebot.media.NamingStandard;
import net.filebot.media.VideoFormat;
import net.filebot.media.XattrMetaInfo;
import net.filebot.mediainfo.ImageMetadata;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.mediainfo.MediaInfoException;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.SimilarityComparator;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.util.StringUtilities;
import net.filebot.util.WeakValueHashMap;
import net.filebot.web.AudioTrack;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.Movie;
import net.filebot.web.MovieInfo;
import net.filebot.web.MoviePart;
import net.filebot.web.MultiEpisode;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;
import net.filebot.web.TheTVDBSeriesInfo;

public class MediaBindingBean {
    private final Object infoObject;
    private final File mediaFile;
    private final Map<File, ?> context;
    private MediaInfo mediaInfo;
    private final Resource<MovieInfo> primaryMovieInfo = Resource.lazy(() -> WebServices.TheMovieDB.getMovieInfo(this.getMovie(), Locale.US, false));
    private final Resource<MovieInfo> extendedMovieInfo = Resource.lazy(() -> this.getMovieInfo(this.getMovie().getLanguage(), true));
    private static final Map<File, MediaInfo> sharedMediaInfoObjects = Collections.synchronizedMap(new WeakValueHashMap(64));
    public static final String EXCEPTION_UNDEFINED = "undefined";
    public static final String EXCEPTION_SAMPLE_FILE_NOT_SET = "Sample file has not been set. Click \"Change Sample\" to select a sample file.";

    public MediaBindingBean(Object infoObject, File mediaFile) {
        this(infoObject, mediaFile, null);
    }

    public MediaBindingBean(Object infoObject, File mediaFile, Map<File, ?> context) {
        this.infoObject = infoObject;
        this.mediaFile = mediaFile;
        this.context = context;
    }

    @Define(value={"object"})
    public Object getInfoObject() {
        return this.infoObject;
    }

    @Define(value={"file"})
    public File getFileObject() {
        return this.mediaFile;
    }

    @Define(value={""})
    public <T> T undefined(String name) {
        throw new BindingException((Object)name, EXCEPTION_UNDEFINED);
    }

    @Define(value={"n"})
    public String getName() {
        if (this.infoObject instanceof Episode) {
            return this.getEpisode().getSeriesName();
        }
        if (this.infoObject instanceof Movie) {
            return this.getMovie().getName();
        }
        if (this.infoObject instanceof AudioTrack) {
            return this.getAlbumArtist() != null ? this.getAlbumArtist() : this.getArtist();
        }
        if (this.infoObject instanceof File) {
            return FileUtilities.getName((File)this.infoObject);
        }
        return null;
    }

    @Define(value={"y"})
    public Integer getYear() {
        if (this.infoObject instanceof Episode) {
            return this.getEpisode().getSeriesInfo().getStartDate().getYear();
        }
        if (this.infoObject instanceof Movie) {
            return this.getMovie().getYear();
        }
        return this.getReleaseDate().getYear();
    }

    @Define(value={"ny"})
    public String getNameWithYear() {
        String y;
        String n = this.getName().toString();
        return n.endsWith(y = " (" + this.getYear().toString() + ")") ? n : n + y;
    }

    @Define(value={"s"})
    public Integer getSeasonNumber() {
        if (EpisodeUtilities.isAnime(this.getEpisode())) {
            return this.getSeasonEpisode().getSeason();
        }
        return this.getEpisode().getSeason();
    }

    @Define(value={"e"})
    public Integer getEpisodeNumber() {
        return this.getEpisode().getEpisode();
    }

    @Define(value={"es"})
    public List<Integer> getEpisodeNumbers() {
        return this.getEpisodes().stream().map(it -> it.getEpisode() == null ? (it.getSpecial() == null ? null : it.getSpecial()) : it.getEpisode()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Define(value={"e00"})
    public String getE00() {
        if (this.isRegularEpisode()) {
            return this.getEpisodeNumbers().stream().map(i -> String.format("%02d", i)).collect(Collectors.joining("-"));
        }
        return "Special " + StringUtilities.join(this.getEpisodeNumbers(), (CharSequence)"-");
    }

    @Define(value={"sxe"})
    public String getSxE() {
        return EpisodeFormat.SeasonEpisode.formatSxE(this.getSeasonEpisode());
    }

    @Define(value={"s00e00"})
    public String getS00E00() {
        return EpisodeFormat.SeasonEpisode.formatS00E00(this.getSeasonEpisode());
    }

    @Define(value={"t"})
    public String getTitle() {
        String t = null;
        if (this.infoObject instanceof Episode) {
            t = this.infoObject instanceof MultiEpisode ? EpisodeFormat.SeasonEpisode.formatMultiTitle(this.getEpisodes()) : this.getEpisode().getTitle();
        } else if (this.infoObject instanceof Movie) {
            t = this.getMovieInfo().getTagline();
        } else if (this.infoObject instanceof AudioTrack) {
            t = this.getMusic().getTrackTitle() != null ? this.getMusic().getTrackTitle() : this.getMusic().getTitle();
        }
        return Normalization.truncateText(t, 150);
    }

    @Define(value={"d"})
    public SimpleDate getReleaseDate() {
        if (this.infoObject instanceof Episode) {
            return this.getEpisode().getAirdate();
        }
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getReleased();
        }
        if (this.infoObject instanceof AudioTrack) {
            return this.getMusic().getAlbumReleaseDate();
        }
        if (this.infoObject instanceof File) {
            return new SimpleDate(this.getTimeStamp());
        }
        return null;
    }

    @Define(value={"dt"})
    public ZonedDateTime getTimeStamp() {
        File f = this.getMediaFile();
        try {
            return new ImageMetadata(f).getDateTaken().get();
        }
        catch (Exception exception) {
            try {
                return Instant.ofEpochMilli(ExpressionFormatMethods.getCreationDate(f)).atZone(ZoneOffset.systemDefault());
            }
            catch (Exception e) {
                Logging.debug.warning(e::toString);
                return null;
            }
        }
    }

    @Define(value={"airdate"})
    public SimpleDate getAirdate() {
        return this.getEpisode().getAirdate();
    }

    @Define(value={"age"})
    public Long getAgeInDays() throws Exception {
        long days;
        SimpleDate releaseDate = this.getReleaseDate();
        if (releaseDate != null && (days = ChronoUnit.DAYS.between(releaseDate.toLocalDate().atStartOfDay(ZoneOffset.UTC).toInstant(), Instant.now())) >= 0L) {
            return days;
        }
        return null;
    }

    @Define(value={"startdate"})
    public SimpleDate getStartDate() {
        return this.getEpisode().getSeriesInfo().getStartDate();
    }

    @Define(value={"absolute"})
    public Integer getAbsoluteEpisodeNumber() {
        return this.getEpisode().getAbsolute();
    }

    @Define(value={"special"})
    public Integer getSpecialNumber() {
        return this.getEpisode().getSpecial();
    }

    @Define(value={"series"})
    public SeriesInfo getSeriesInfo() {
        return this.getEpisode().getSeriesInfo();
    }

    @Define(value={"alias"})
    public List<String> getAliasNames() {
        if (this.infoObject instanceof Movie) {
            return Arrays.asList(this.getMovie().getAliasNames());
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getAliasNames();
        }
        return null;
    }

    @Define(value={"primaryTitle"})
    public String getPrimaryTitle() {
        if (this.infoObject instanceof Movie) {
            return this.getPrimaryMovieInfo().getOriginalName();
        }
        if (this.infoObject instanceof Episode) {
            return this.getPrimarySeriesInfo().getName();
        }
        return null;
    }

    @Define(value={"id"})
    public Object getId() throws Exception {
        if (this.infoObject instanceof Episode) {
            return this.getEpisode().getSeriesInfo().getId();
        }
        if (this.infoObject instanceof Movie) {
            return this.getMovie().getId();
        }
        if (this.infoObject instanceof AudioTrack) {
            return this.getMusic().getMBID();
        }
        return null;
    }

    @Define(value={"tmdbid"})
    public String getTmdbId() {
        if (this.getMovie().getTmdbId() > 0) {
            return String.valueOf(this.getMovie().getTmdbId());
        }
        if (this.getMovie().getImdbId() > 0) {
            return this.getPrimaryMovieInfo().getId().toString();
        }
        return null;
    }

    @Define(value={"imdbid"})
    public String getImdbId() {
        if (this.getMovie().getImdbId() > 0) {
            return String.format("tt%07d", this.getMovie().getImdbId());
        }
        if (this.getMovie().getTmdbId() > 0) {
            return String.format("tt%07d", this.getPrimaryMovieInfo().getImdbId());
        }
        return null;
    }

    @Define(value={"vc"})
    public String getVideoCodec() {
        String codec = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Encoded_Library_Name", "Encoded_Library/Name", "CodecID/Hint", "Format");
        return StringUtilities.tokenize(codec).findFirst().orElse(null);
    }

    @Define(value={"ac"})
    public String getAudioCodec() {
        String codec = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "CodecID/Hint", "Format");
        return Normalization.normalizePunctuation(codec, "", "");
    }

    @Define(value={"cf"})
    public String getContainerFormat() {
        String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        return StringUtilities.tokenize(extensions).map(String::toLowerCase).findFirst().get();
    }

    @Define(value={"vf"})
    public String getVideoFormat() {
        int w = Integer.parseInt(this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Width"));
        int h = Integer.parseInt(this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Height"));
        return String.format("%dp", VideoFormat.DEFAULT_GROUPS.guessFormat(w, h));
    }

    @Define(value={"hpi"})
    public String getExactVideoFormat() {
        String height = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Height");
        String scanType = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "ScanType");
        String p = scanType.codePoints().map(Character::toLowerCase).mapToObj(Character::toChars).map(String::valueOf).findFirst().orElse("p");
        return height + p;
    }

    @Define(value={"af"})
    public String getAudioChannels() {
        String channels = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "Channel(s)_Original", "Channel(s)");
        return String.format("%dch", StringUtilities.matchInteger(channels));
    }

    @Define(value={"channels"})
    public String getAudioChannelPositions() {
        String channels = this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "ChannelPositions/String2", "Channel(s)_Original", "Channel(s)");
        double d = StringUtilities.tokenize(channels).mapToDouble(s -> {
            try {
                return StringUtilities.tokenize(s, RegularExpressions.SLASH).mapToDouble(Double::parseDouble).reduce(0.0, (a, b) -> a + b);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }).filter(it -> it > 0.0).max().getAsDouble();
        return BigDecimal.valueOf(d).setScale(1, RoundingMode.HALF_UP).toPlainString();
    }

    @Define(value={"aco"})
    public String getAudioChannelObjects() {
        return this.getMediaInfo(MediaInfo.StreamKind.Audio, "Codec_Profile").filter(Objects::nonNull).map(s -> RegularExpressions.SLASH.splitAsStream((CharSequence)s).findFirst().orElse(null)).filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0).findFirst().orElse(null);
    }

    @Define(value={"resolution"})
    public String getVideoResolution() {
        return StringUtilities.join(this.getDimension(), (CharSequence)"x");
    }

    @Define(value={"bitdepth"})
    public int getVideoBitDepth() {
        String bitdepth = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "BitDepth");
        return Integer.parseInt(bitdepth);
    }

    @Define(value={"ws"})
    public String getWidescreen() {
        List<Integer> dim = this.getDimension();
        return (float)dim.get(0).intValue() / (float)dim.get(1).intValue() > 1.37f ? "WS" : null;
    }

    @Define(value={"hd"})
    public String getVideoDefinitionCategory() {
        List<Integer> dim = this.getDimension();
        if (dim.get(0) >= 3840 || dim.get(1) >= 2160) {
            return "UHD";
        }
        if (dim.get(0) >= 1280 || dim.get(1) >= 720) {
            return "HD";
        }
        return "SD";
    }

    @Define(value={"dim"})
    public List<Integer> getDimension() {
        return Stream.of(MediaInfo.StreamKind.Video, MediaInfo.StreamKind.Image).map(k -> Stream.of("Width", "Height").map(p -> this.getMediaInfo().get((MediaInfo.StreamKind)((Object)k), 0, (String)p)).filter(s -> s.length() > 0).map(Integer::parseInt).collect(Collectors.toList())).filter(d -> d.size() == 2).findFirst().orElse(null);
    }

    @Define(value={"width"})
    public Integer getWidth() {
        return this.getDimension().get(0);
    }

    @Define(value={"height"})
    public Integer getHeight() {
        return this.getDimension().get(1);
    }

    @Define(value={"original"})
    public String getOriginalFileName() {
        String name = XattrMetaInfo.xattr.getOriginalName(this.getMediaFile());
        return name != null ? FileUtilities.getNameWithoutExtension(name) : null;
    }

    @Define(value={"xattr"})
    public Object getMetaAttributesObject() throws Exception {
        return XattrMetaInfo.xattr.getMetaInfo(this.getMediaFile());
    }

    @Define(value={"crc32"})
    public String getCRC32() throws Exception {
        File inferredMediaFile = this.getInferredMediaFile();
        Optional<String> embeddedChecksum = Arrays.stream(this.getFileNames(inferredMediaFile)).map(Normalization::getEmbeddedChecksum).filter(Objects::nonNull).findFirst();
        if (embeddedChecksum.isPresent()) {
            return embeddedChecksum.get();
        }
        String checksum = VerificationUtilities.getHashFromVerificationFile(inferredMediaFile, HashType.SFV, 3);
        if (checksum != null) {
            return checksum;
        }
        try {
            MetaAttributeView xattr = new MetaAttributeView(inferredMediaFile);
            checksum = xattr.get("CRC32");
            if (checksum != null) {
                return checksum;
            }
        }
        catch (Exception xattr) {
            // empty catch block
        }
        Cache cache = Cache.getCache("crc32", CacheType.Ephemeral);
        return (String)cache.computeIfAbsent(inferredMediaFile, it -> VerificationUtilities.crc32(inferredMediaFile));
    }

    @Define(value={"fn"})
    public String getFileName() {
        return FileUtilities.getName(this.getMediaFile());
    }

    @Define(value={"ext"})
    public String getExtension() {
        return FileUtilities.getExtension(this.getMediaFile());
    }

    @Define(value={"source"})
    public String getVideoSource() {
        return MediaDetection.releaseInfo.getVideoSource(this.getFileNames(this.getInferredMediaFile()));
    }

    @Define(value={"tags"})
    public List<String> getVideoTags() {
        List<String> matches = MediaDetection.releaseInfo.getVideoTags(this.getFileNames(this.getInferredMediaFile()));
        if (matches.isEmpty()) {
            return null;
        }
        return matches.stream().map(s -> ExpressionFormatMethods.lowerTrail(ExpressionFormatMethods.upperInitial(Normalization.normalizePunctuation(s)))).sorted().distinct().collect(Collectors.toList());
    }

    @Define(value={"s3d"})
    public String getStereoscopic3D() {
        return MediaDetection.releaseInfo.getStereoscopic3D(this.getFileNames(this.getInferredMediaFile()));
    }

    @Define(value={"group"})
    public String getReleaseGroup() throws Exception {
        Pattern[] nonGroupPattern = new Pattern[]{this.getKeywordExcludePattern(), MediaDetection.releaseInfo.getVideoSourcePattern(), MediaDetection.releaseInfo.getVideoFormatPattern(true), MediaDetection.releaseInfo.getResolutionPattern(), MediaDetection.releaseInfo.getStructureRootPattern()};
        String[] filenames = (String[])Arrays.stream(this.getFileNames(this.getInferredMediaFile())).map(s -> MediaDetection.releaseInfo.clean((String)s, nonGroupPattern)).filter(s -> s.length() > 0).toArray(String[]::new);
        return MediaDetection.releaseInfo.getReleaseGroup(filenames);
    }

    @Define(value={"subt"})
    public String getSubtitleTags() throws Exception {
        if (!MediaTypes.SUBTITLE_FILES.accept(this.getMediaFile())) {
            return null;
        }
        Language language = this.getLanguageTag();
        if (language != null) {
            String tag = "." + language.getISO3B();
            String category = MediaDetection.releaseInfo.getSubtitleCategoryTag(this.getFileNames(this.getMediaFile()));
            if (category != null) {
                return tag + "." + category;
            }
            return tag;
        }
        return null;
    }

    @Define(value={"lang"})
    public Language getLanguageTag() throws Exception {
        Locale languageTag = MediaDetection.releaseInfo.getSubtitleLanguageTag(this.getFileNames(this.getMediaFile()));
        if (languageTag != null) {
            return Language.getLanguage(languageTag);
        }
        if (MediaTypes.SUBTITLE_FILES.accept(this.getMediaFile())) {
            try {
                return SubtitleUtilities.detectSubtitleLanguage(this.getMediaFile());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to detect subtitle language: " + e, e);
            }
        }
        return null;
    }

    @Define(value={"languages"})
    public List<Language> getSpokenLanguages() {
        if (this.infoObject instanceof Movie) {
            List<Locale> languages = this.getMovieInfo().getSpokenLanguages();
            return languages.stream().map(Language::getLanguage).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (this.infoObject instanceof Episode) {
            String language = this.getSeriesInfo().getLanguage();
            return Stream.of(language).map(Language::findLanguage).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @Define(value={"runtime"})
    public Integer getRuntime() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getRuntime();
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getRuntime();
        }
        return null;
    }

    @Define(value={"actors"})
    public List<String> getActors() throws Exception {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getActors();
        }
        if (this.infoObject instanceof Episode) {
            return ExpressionFormatMethods.getActors(this.getSeriesInfo());
        }
        return null;
    }

    @Define(value={"genres"})
    public List<String> getGenres() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getGenres();
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getGenres();
        }
        if (this.infoObject instanceof AudioTrack) {
            return Stream.of(this.getMusic().getGenre()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @Define(value={"genre"})
    public String getPrimaryGenre() {
        return this.getGenres().iterator().next();
    }

    @Define(value={"director"})
    public String getDirector() throws Exception {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getDirector();
        }
        if (this.infoObject instanceof Episode) {
            return ExpressionFormatMethods.getInfo(this.getEpisode()).getDirector();
        }
        return null;
    }

    @Define(value={"certification"})
    public String getCertification() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getCertification();
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getCertification();
        }
        return null;
    }

    @Define(value={"rating"})
    public Double getRating() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getRating();
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getRating();
        }
        return null;
    }

    @Define(value={"votes"})
    public Integer getVotes() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getVotes();
        }
        if (this.infoObject instanceof Episode) {
            return this.getSeriesInfo().getRatingCount();
        }
        return null;
    }

    @Define(value={"collection"})
    public String getCollection() {
        if (this.infoObject instanceof Movie) {
            return this.getMovieInfo().getCollection();
        }
        return null;
    }

    @Define(value={"info"})
    public synchronized AssociativeScriptObject getMetaInfo() {
        if (this.infoObject instanceof Movie) {
            return this.createPropertyBindings(this.getMovieInfo());
        }
        if (this.infoObject instanceof Episode) {
            return this.createPropertyBindings(this.getSeriesInfo());
        }
        return null;
    }

    @Define(value={"omdb"})
    public synchronized AssociativeScriptObject getOmdbApiInfo() throws Exception {
        if (this.infoObject instanceof Movie) {
            if (this.getMovie().getImdbId() > 0) {
                return this.createPropertyBindings(WebServices.OMDb.getMovieInfo(this.getMovie()));
            }
            if (this.getMovie().getTmdbId() > 0) {
                Integer imdbId = this.getPrimaryMovieInfo().getImdbId();
                return this.createPropertyBindings(WebServices.OMDb.getMovieInfo(new Movie(imdbId)));
            }
        }
        if (this.infoObject instanceof Episode) {
            TheTVDBSeriesInfo info = (TheTVDBSeriesInfo)this.getPrimarySeriesInfo();
            int imdbId = StringUtilities.matchInteger(info.getImdbId());
            return this.createPropertyBindings(WebServices.OMDb.getMovieInfo(new Movie(imdbId)));
        }
        return null;
    }

    @Define(value={"order"})
    public DynamicBindings getSortOrderObject() {
        return new DynamicBindings(SortOrder::names, k -> {
            if (this.infoObject instanceof Episode) {
                SortOrder order = SortOrder.forName(k);
                Episode episode = EpisodeUtilities.fetchEpisode(this.getEpisode(), order, null);
                return this.createBindingObject(episode);
            }
            return this.undefined((String)k);
        });
    }

    @Define(value={"localize"})
    public DynamicBindings getLocalizedInfoObject() {
        return new DynamicBindings(Language::availableLanguages, k -> {
            Language language = Language.findLanguage(k);
            if (language != null && this.infoObject instanceof Movie) {
                Movie movie = WebServices.TheMovieDB.getMovieDescriptor(this.getMovie(), language.getLocale());
                return this.createBindingObject(movie);
            }
            if (language != null && this.infoObject instanceof Episode) {
                Episode episode = EpisodeUtilities.fetchEpisode(this.getEpisode(), null, language.getLocale());
                return this.createBindingObject(episode);
            }
            return this.undefined((String)k);
        });
    }

    @Define(value={"az"})
    public String getSortInitial() {
        try {
            return ExpressionFormatMethods.sortInitial(this.getCollection());
        }
        catch (Exception e) {
            return ExpressionFormatMethods.sortInitial(this.getName());
        }
    }

    @Define(value={"anime"})
    public boolean isAnimeEpisode() {
        return this.getEpisodes().stream().anyMatch(it -> EpisodeUtilities.isAnime(it));
    }

    @Define(value={"regular"})
    public boolean isRegularEpisode() {
        return this.getEpisodes().stream().anyMatch(it -> EpisodeUtilities.isRegular(it));
    }

    @Define(value={"episodelist"})
    public List<Episode> getEpisodeList() throws Exception {
        return EpisodeUtilities.fetchEpisodeList(this.getEpisode());
    }

    @Define(value={"sy"})
    public List<Integer> getSeasonYears() throws Exception {
        return this.getEpisodeList().stream().filter(e -> EpisodeUtilities.isRegular(e) && e.getSeason().equals(this.getSeasonNumber()) && e.getAirdate() != null).map(e -> e.getAirdate().getYear()).sorted().distinct().collect(Collectors.toList());
    }

    @Define(value={"sc"})
    public Integer getSeasonCount() throws Exception {
        return this.getEpisodeList().stream().filter(e -> EpisodeUtilities.isRegular(e) && e.getSeason() != null).map(Episode::getSeason).max(Integer::compare).get();
    }

    @Define(value={"mediaTitle"})
    public String getMediaTitle() {
        return this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Title", "Movie");
    }

    @Define(value={"audioLanguages"})
    public List<Language> getAudioLanguageList() {
        return this.getMediaInfo(MediaInfo.StreamKind.Audio, "Language").filter(Objects::nonNull).distinct().map(Language::findLanguage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Define(value={"textLanguages"})
    public List<Language> getTextLanguageList() {
        return this.getMediaInfo(MediaInfo.StreamKind.Text, "Language").filter(Objects::nonNull).distinct().map(Language::findLanguage).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Define(value={"bitrate"})
    public Long getOverallBitRate() {
        return (long)Double.parseDouble(this.getMediaInfo(MediaInfo.StreamKind.General, 0, "OverallBitRate"));
    }

    @Define(value={"kbps"})
    public String getKiloBytesPerSecond() {
        return String.format("%.0f kbps", Float.valueOf((float)this.getOverallBitRate().longValue() / 1000.0f));
    }

    @Define(value={"mbps"})
    public String getMegaBytesPerSecond() {
        return String.format("%.1f Mbps", Float.valueOf((float)this.getOverallBitRate().longValue() / 1000000.0f));
    }

    @Define(value={"khz"})
    public String getSamplingRate() {
        return this.getMediaInfo(MediaInfo.StreamKind.Audio, 0, "SamplingRate/String");
    }

    @Define(value={"duration"})
    public Duration getDuration() {
        long d = (long)Double.parseDouble(this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Duration"));
        return Duration.ofMillis(d);
    }

    @Define(value={"seconds"})
    public long getSeconds() {
        return this.getDuration().getSeconds();
    }

    @Define(value={"minutes"})
    public long getMinutes() {
        return this.getDuration().toMinutes();
    }

    @Define(value={"hours"})
    public String getHours() {
        return ExpressionFormatMethods.format(this.getDuration(), "H:mm");
    }

    @Define(value={"media"})
    public AssociativeScriptObject getGeneralMediaInfo() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.General).get(0);
    }

    @Define(value={"menu"})
    public AssociativeScriptObject getMenuInfo() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Menu).get(0);
    }

    @Define(value={"image"})
    public AssociativeScriptObject getImageInfo() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Image).get(0);
    }

    @Define(value={"video"})
    public List<AssociativeScriptObject> getVideoInfoList() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Video);
    }

    @Define(value={"audio"})
    public List<AssociativeScriptObject> getAudioInfoList() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Audio);
    }

    @Define(value={"text"})
    public List<AssociativeScriptObject> getTextInfoList() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Text);
    }

    @Define(value={"chapters"})
    public List<AssociativeScriptObject> getChaptersInfoList() {
        return this.createMediaInfoBindings(MediaInfo.StreamKind.Chapters);
    }

    @Define(value={"exif"})
    public AssociativeScriptObject getImageMetadata() throws Exception {
        return new AssociativeScriptObject(new ImageMetadata(this.getMediaFile()).snapshot());
    }

    @Define(value={"camera"})
    public AssociativeEnumObject getCamera() throws Exception {
        return new ImageMetadata(this.getMediaFile()).getCameraModel().map(AssociativeEnumObject::new).orElse(null);
    }

    @Define(value={"location"})
    public AssociativeEnumObject getLocation() throws Exception {
        return new ImageMetadata(this.getMediaFile()).getLocationTaken().map(AssociativeEnumObject::new).orElse(null);
    }

    @Define(value={"artist"})
    public String getArtist() {
        return this.getMusic().getArtist();
    }

    @Define(value={"albumArtist"})
    public String getAlbumArtist() {
        return this.getMusic().getAlbumArtist();
    }

    @Define(value={"album"})
    public String getAlbum() {
        return this.getMusic().getAlbum();
    }

    @Define(value={"episode"})
    public Episode getEpisode() {
        return (Episode)this.infoObject;
    }

    @Define(value={"episodes"})
    public List<Episode> getEpisodes() {
        return EpisodeUtilities.getMultiEpisodeList(this.getEpisode());
    }

    @Define(value={"movie"})
    public Movie getMovie() {
        return (Movie)this.infoObject;
    }

    @Define(value={"music"})
    public AudioTrack getMusic() {
        return (AudioTrack)this.infoObject;
    }

    @Define(value={"pi"})
    public Integer getPart() {
        if (this.infoObject instanceof AudioTrack) {
            return this.getMusic().getTrack();
        }
        if (this.infoObject instanceof MoviePart) {
            return ((MoviePart)this.infoObject).getPartIndex();
        }
        return null;
    }

    @Define(value={"pn"})
    public Integer getPartCount() {
        if (this.infoObject instanceof AudioTrack) {
            return this.getMusic().getTrackCount();
        }
        if (this.infoObject instanceof MoviePart) {
            return ((MoviePart)this.infoObject).getPartCount();
        }
        return null;
    }

    @Define(value={"type"})
    public String getInfoObjectType() {
        return this.infoObject.getClass().getSimpleName();
    }

    @Define(value={"mime"})
    public List<String> getMediaType() throws Exception {
        return RegularExpressions.SLASH.splitAsStream(MediaTypes.getMediaType(this.getExtension())).collect(Collectors.toList());
    }

    @Define(value={"mediaPath"})
    public File getMediaPath() throws Exception {
        return MediaDetection.getStructurePathTail(this.getMediaFile());
    }

    @Define(value={"f"})
    public File getMediaFile() {
        if (this.mediaFile == null) {
            throw new IllegalStateException(EXCEPTION_SAMPLE_FILE_NOT_SET);
        }
        return this.mediaFile;
    }

    @Define(value={"folder"})
    public File getMediaParentFolder() {
        return this.getMediaFile().getParentFile();
    }

    @Define(value={"bytes"})
    public long getFileSize() {
        if (this.getMediaFile().isDirectory()) {
            return FileUtilities.listFiles(this.getMediaFile(), FileUtilities.FILES).stream().mapToLong(File::length).sum();
        }
        return this.getInferredMediaFile().length();
    }

    @Define(value={"megabytes"})
    public String getFileSizeInMegaBytes() {
        return String.format("%.0f", (double)this.getFileSize() / 1000000.0);
    }

    @Define(value={"gigabytes"})
    public String getFileSizeInGigaBytes() {
        return String.format("%.1f", (double)this.getFileSize() / 1.0E9);
    }

    @Define(value={"encodedDate"})
    public SimpleDate getEncodedDate() {
        String date = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Encoded_Date");
        ZonedDateTime time = ZonedDateTime.parse(date, DateTimeFormatter.ofPattern("zzz uuuu-MM-dd HH:mm:ss"));
        return new SimpleDate(time);
    }

    @Define(value={"today"})
    public SimpleDate getToday() {
        return new SimpleDate(LocalDateTime.now());
    }

    @Define(value={"home"})
    public File getUserHome() {
        return ApplicationFolder.UserHome.get();
    }

    @Define(value={"output"})
    public File getUserDefinedOutputFolder() throws IOException {
        return new File(Settings.getApplicationArguments().output).getCanonicalFile();
    }

    @Define(value={"defines"})
    public Map<String, String> getUserDefinedArguments() throws IOException {
        return Collections.unmodifiableMap(Settings.getApplicationArguments().defines);
    }

    @Define(value={"label"})
    public String getUserDefinedLabel() throws IOException {
        return this.getUserDefinedArguments().entrySet().stream().filter(it -> ((String)it.getKey()).endsWith("label") && it.getValue() != null && ((String)it.getValue()).length() > 0).map(it -> (String)it.getValue()).findFirst().orElse(null);
    }

    @Define(value={"i"})
    public Integer getModelIndex() {
        return 1 + this.identityIndexOf(this.context.values(), this.getInfoObject());
    }

    @Define(value={"di"})
    public Integer getDuplicateIndex() {
        return 1 + this.identityIndexOf(this.context.values().stream().filter(this.getInfoObject()::equals).collect(Collectors.toList()), this.getInfoObject());
    }

    @Define(value={"dc"})
    public Integer getDuplicateCount() {
        return this.context.values().stream().filter(this.getInfoObject()::equals).mapToInt(i -> 1).sum();
    }

    @Define(value={"plex"})
    public File getPlexStandardPath() throws Exception {
        String path = NamingStandard.Plex.getPath(this.infoObject);
        try {
            path = path.concat(this.getSubtitleTags());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(path);
    }

    @Define(value={"self"})
    public AssociativeScriptObject getSelf() {
        return this.createBindingObject(this.mediaFile, this.infoObject, this.context, property -> null);
    }

    @Define(value={"model"})
    public List<AssociativeScriptObject> getModel() {
        ArrayList<AssociativeScriptObject> result = new ArrayList<AssociativeScriptObject>();
        for (Map.Entry<File, ?> it : this.context.entrySet()) {
            result.add(this.createBindingObject(it.getKey(), it.getValue(), this.context, property -> null));
        }
        return result;
    }

    @Define(value={"json"})
    public String getInfoObjectDump() {
        return MetaAttributes.toJson(this.infoObject);
    }

    public File getInferredMediaFile() {
        File file = this.getMediaFile();
        if (file.isDirectory()) {
            List<File> videos = FileUtilities.listFiles(file, (FileFilter)MediaTypes.VIDEO_FILES, FileUtilities.CASE_INSENSITIVE_PATH_ORDER);
            if (videos.size() > 0) {
                return videos.get(0);
            }
        } else if (MediaTypes.SUBTITLE_FILES.accept(file) || MediaTypes.IMAGE_FILES.accept(file) || (this.infoObject instanceof Episode || this.infoObject instanceof Movie) && !MediaTypes.VIDEO_FILES.accept(file)) {
            if (this.context != null) {
                for (Map.Entry<File, ?> it : this.context.entrySet()) {
                    if (!this.infoObject.equals(it.getValue()) || !MediaTypes.VIDEO_FILES.accept(it.getKey())) continue;
                    return it.getKey();
                }
            }
            String baseName = MediaDetection.stripReleaseInfo(FileUtilities.getName(file)).toLowerCase();
            List<File> videos = FileUtilities.getChildren(file.getParentFile(), MediaTypes.VIDEO_FILES);
            for (File movieFile : videos) {
                if (baseName.isEmpty() || !MediaDetection.stripReleaseInfo(FileUtilities.getName(movieFile)).toLowerCase().startsWith(baseName)) continue;
                return movieFile;
            }
            if (videos.size() > 0) {
                Collections.sort(videos, SimilarityComparator.compareTo(FileUtilities.getName(file), FileUtilities::getName));
                return videos.get(0);
            }
        }
        return file;
    }

    public Episode getSeasonEpisode() {
        if (this.getEpisodes().stream().allMatch(it -> EpisodeUtilities.isAnime(it) && EpisodeUtilities.isRegular(it) && !EpisodeUtilities.isAbsolute(it))) {
            try {
                return EpisodeUtilities.getEpisodeByAbsoluteNumber(this.getEpisode(), WebServices.TheTVDB, SortOrder.Airdate);
            }
            catch (Exception e) {
                Logging.debug.warning(e::toString);
            }
        }
        return this.getEpisode();
    }

    public SeriesInfo getPrimarySeriesInfo() {
        if (WebServices.TheTVDB.getIdentifier().equals(this.getSeriesInfo().getDatabase())) {
            try {
                return WebServices.TheTVDB.getSeriesInfo(this.getSeriesInfo().getId(), Locale.ENGLISH);
            }
            catch (Exception e) {
                Logging.debug.warning("Failed to retrieve primary series info: " + e);
            }
        }
        return this.getSeriesInfo();
    }

    public MovieInfo getPrimaryMovieInfo() {
        try {
            return this.primaryMovieInfo.get();
        }
        catch (Exception e) {
            throw new BindingException("info", "Failed to retrieve primary movie info: " + e, e);
        }
    }

    public MovieInfo getMovieInfo() {
        try {
            return this.extendedMovieInfo.get();
        }
        catch (Exception e) {
            throw new BindingException("info", "Failed to retrieve extended movie info: " + e, e);
        }
    }

    public synchronized MovieInfo getMovieInfo(Locale locale, boolean extendedInfo) throws Exception {
        Movie m = this.getMovie();
        if (m.getTmdbId() > 0) {
            return WebServices.TheMovieDB.getMovieInfo(m, locale == null ? Locale.US : locale, extendedInfo);
        }
        if (m.getImdbId() > 0) {
            return WebServices.OMDb.getMovieInfo(m);
        }
        return null;
    }

    private synchronized MediaInfo getMediaInfo() {
        if (this.mediaInfo == null) {
            File inferredMediaFile = this.getInferredMediaFile();
            this.mediaInfo = sharedMediaInfoObjects.computeIfAbsent(inferredMediaFile, f -> {
                try {
                    return new MediaInfo().open((File)f);
                }
                catch (IOException e) {
                    throw new MediaInfoException(e.getMessage());
                }
            });
        }
        return this.mediaInfo;
    }

    private Integer identityIndexOf(Iterable<?> c, Object o) {
        Iterator<?> itr = c.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Object next = itr.next();
            if (o == next) {
                return i;
            }
            ++i;
        }
        return null;
    }

    private String getMediaInfo(MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        for (String key : keys) {
            String value = this.getMediaInfo().get(streamKind, streamNumber, key);
            if (value.length() <= 0) continue;
            return value;
        }
        return (String)this.undefined(String.format("%s[%d][%s]", new Object[]{streamKind, streamNumber, StringUtilities.join(keys, (CharSequence)", ")}));
    }

    private Stream<String> getMediaInfo(MediaInfo.StreamKind streamKind, String ... keys) {
        return IntStream.range(0, this.getMediaInfo().streamCount(streamKind)).mapToObj(streamNumber -> Arrays.stream(keys).map(key -> this.getMediaInfo().get(streamKind, streamNumber, (String)key)).filter(s -> s.length() > 0).findFirst().orElse(null));
    }

    private AssociativeScriptObject createBindingObject(Object info) {
        return this.createBindingObject(null, info, null, this::undefined);
    }

    private AssociativeScriptObject createBindingObject(File file, Object info, Map<File, ?> context, Function<String, Object> defaultValue) {
        MediaBindingBean mediaBindingBean = new MediaBindingBean(info, file, context){

            @Override
            @Define(value={""})
            public <T> T undefined(String name) {
                return null;
            }
        };
        return new AssociativeScriptObject(new ExpressionBindings(mediaBindingBean), defaultValue);
    }

    private AssociativeScriptObject createPropertyBindings(Object object) {
        return new AssociativeScriptObject(new PropertyBindings(object), this::undefined);
    }

    private List<AssociativeScriptObject> createMediaInfoBindings(MediaInfo.StreamKind kind) {
        return this.getMediaInfo().snapshot().get((Object)kind).stream().map(m -> new AssociativeScriptObject((Map<?, ?>)m, this::undefined)).collect(Collectors.toList());
    }

    private String[] getFileNames(File file) {
        File parent;
        ArrayList<String> names = new ArrayList<String>(3);
        names.add(FileUtilities.getNameWithoutExtension(file.getName()));
        String original = XattrMetaInfo.xattr.getOriginalName(file);
        if (original != null) {
            names.add(FileUtilities.getNameWithoutExtension(original));
        }
        if ((parent = file.getParentFile()) != null && parent.getParent() != null) {
            names.add(parent.getName());
        }
        return names.toArray(new String[0]);
    }

    private Pattern getKeywordExcludePattern() {
        ArrayList<Object> keys = new ArrayList<Object>();
        if (this.infoObject instanceof Episode || this.infoObject instanceof Movie) {
            keys.add(this.getName());
            keys.addAll(this.getAliasNames());
            if (this.infoObject instanceof Episode) {
                for (Episode e : this.getEpisodes()) {
                    keys.add(e.getTitle());
                }
            } else if (this.infoObject instanceof Movie) {
                keys.add(this.getYear());
            }
        }
        String pattern = keys.stream().filter(Objects::nonNull).map(Objects::toString).map(s -> Normalization.normalizePunctuation(s, " ", "\\P{Alnum}+")).filter(s -> s.length() > 0).collect(Collectors.joining("|", "\\b(", ")\\b"));
        return Pattern.compile(pattern, 258);
    }

    public String toString() {
        return String.format("%s \u21d4 %s", this.infoObject, this.mediaFile == null ? null : this.mediaFile.getName());
    }
}

