/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.filebot.format.BindingException;
import net.filebot.util.ExceptionUtilities;

public class PropertyBindings
extends AbstractMap<String, Object> {
    private final Object object;
    private final Map<String, Object> properties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public PropertyBindings(Object object) {
        this.object = object;
        for (Method method : object.getClass().getMethods()) {
            if (method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || method.getDeclaringClass().getName().startsWith("java")) continue;
            if (method.getName().length() > 3 && method.getName().substring(0, 3).equalsIgnoreCase("get")) {
                this.properties.put(method.getName().substring(3), method);
            }
            if (method.getName().length() <= 2 || !method.getName().substring(0, 2).equalsIgnoreCase("is")) continue;
            this.properties.put(method.getName().substring(2), method);
        }
    }

    @Override
    public Object get(Object key) {
        Object value = this.properties.get(key);
        if (value instanceof Method) {
            try {
                value = ((Method)value).invoke(this.object, new Object[0]);
            }
            catch (Exception e) {
                throw new BindingException(key, ExceptionUtilities.getRootCauseMessage(e), e);
            }
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entrySet = new HashSet<Map.Entry<String, Object>>();
        for (final String key : this.keySet()) {
            entrySet.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public Object getValue() {
                    return PropertyBindings.this.get(key);
                }

                @Override
                public Object setValue(Object value) {
                    return PropertyBindings.this.put(key, value);
                }
            });
        }
        return entrySet;
    }
}

