/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.util.zip.CRC32;
import net.filebot.MediaTypes;
import net.filebot.hash.ChecksumHash;
import net.filebot.hash.Hash;
import net.filebot.hash.JacksumHash;
import net.filebot.hash.MessageDigestHash;
import net.filebot.hash.SfvFormat;
import net.filebot.hash.VerificationFormat;
import net.filebot.util.FileUtilities;

public enum HashType {
    SFV{

        @Override
        public Hash newHash() {
            return new ChecksumHash(new CRC32());
        }

        @Override
        public VerificationFormat getFormat() {
            return new SfvFormat();
        }

        @Override
        public FileUtilities.ExtensionFileFilter getFilter() {
            return MediaTypes.getTypeFilter("verification/sfv");
        }
    }
    ,
    MD5{

        @Override
        public Hash newHash() {
            return new MessageDigestHash("MD5");
        }

        @Override
        public VerificationFormat getFormat() {
            return new VerificationFormat();
        }

        @Override
        public FileUtilities.ExtensionFileFilter getFilter() {
            return MediaTypes.getTypeFilter("verification/md5sum");
        }
    }
    ,
    SHA1{

        @Override
        public Hash newHash() {
            return new MessageDigestHash("SHA-1");
        }

        @Override
        public VerificationFormat getFormat() {
            return new VerificationFormat("SHA1");
        }

        @Override
        public FileUtilities.ExtensionFileFilter getFilter() {
            return MediaTypes.getTypeFilter("verification/sha1sum");
        }

        public String toString() {
            return "SHA1";
        }
    }
    ,
    SHA256{

        @Override
        public Hash newHash() {
            return new MessageDigestHash("SHA-256");
        }

        @Override
        public VerificationFormat getFormat() {
            return new VerificationFormat("SHA256");
        }

        @Override
        public FileUtilities.ExtensionFileFilter getFilter() {
            return MediaTypes.getTypeFilter("verification/sha256sum");
        }

        public String toString() {
            return "SHA2";
        }
    }
    ,
    ED2K{

        @Override
        public Hash newHash() {
            return JacksumHash.newED2K();
        }

        @Override
        public VerificationFormat getFormat() {
            return new VerificationFormat();
        }

        @Override
        public FileUtilities.ExtensionFileFilter getFilter() {
            return MediaTypes.getTypeFilter("verification/ed2k");
        }

        public String toString() {
            return "ED2K";
        }
    };


    public abstract Hash newHash();

    public abstract VerificationFormat getFormat();

    public abstract FileUtilities.ExtensionFileFilter getFilter();
}

