/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.math.BigInteger;
import java.security.MessageDigest;
import net.filebot.hash.Hash;

public class MessageDigestHash
implements Hash {
    private final MessageDigest md;

    public MessageDigestHash(String algorithm) {
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public MessageDigestHash(MessageDigest md) {
        this.md = md;
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        this.md.update(bytes, off, len);
    }

    @Override
    public String digest() {
        return String.format("%0" + this.md.getDigestLength() * 2 + "x", new BigInteger(1, this.md.digest()));
    }
}

