/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.Serializable;
import java.text.CollationKey;
import net.filebot.media.HighPerformanceMatcher;

class IndexEntry<T>
implements Serializable {
    private T object;
    private String lenientName;
    private String strictName;
    private transient CollationKey[] lenientKey;
    private transient CollationKey[] strictKey;

    public IndexEntry(T object, String lenientName, String strictName) {
        this.object = object;
        this.lenientName = lenientName;
        this.strictName = strictName;
    }

    public T getObject() {
        return this.object;
    }

    public String getLenientName() {
        return this.lenientName;
    }

    public String getStrictName() {
        return this.strictName;
    }

    public CollationKey[] getLenientKey() {
        if (this.lenientKey == null && this.lenientName != null) {
            this.lenientKey = HighPerformanceMatcher.prepare(this.lenientName);
        }
        return this.lenientKey;
    }

    public CollationKey[] getStrictKey() {
        if (this.strictKey == null && this.strictName != null) {
            this.strictKey = HighPerformanceMatcher.prepare(this.strictName);
        }
        return this.strictKey;
    }

    public String toString() {
        return this.strictName != null ? this.strictName : this.lenientName;
    }
}

