/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.CollationKey;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.filebot.ApplicationFolder;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.Resource;
import net.filebot.WebServices;
import net.filebot.archive.Archive;
import net.filebot.media.HighPerformanceMatcher;
import net.filebot.media.IndexEntry;
import net.filebot.media.ReleaseInfo;
import net.filebot.media.SmartSeasonEpisodeMatcher;
import net.filebot.media.XattrMetaInfo;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.DateMatcher;
import net.filebot.similarity.EpisodeMetrics;
import net.filebot.similarity.MetricAvg;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.NumericSimilarityMetric;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.similarity.SequenceMatchSimilarity;
import net.filebot.similarity.SeriesNameMatcher;
import net.filebot.similarity.SimilarityComparator;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.similarity.StringEqualsMetric;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.vfs.FileInfo;
import net.filebot.web.Episode;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;

public class MediaDetection {
    public static final ReleaseInfo releaseInfo = new ReleaseInfo();
    private static final SeasonEpisodeMatcher seasonEpisodeMatcherStrict = new SmartSeasonEpisodeMatcher(SeasonEpisodeMatcher.DEFAULT_SANITY, true);
    private static final SeasonEpisodeMatcher seasonEpisodeMatcherNonStrict = new SmartSeasonEpisodeMatcher(SeasonEpisodeMatcher.DEFAULT_SANITY, false);
    private static final DateMatcher dateMatcher = new DateMatcher(DateMatcher.DEFAULT_SANITY, Locale.ENGLISH, Locale.getDefault());
    private static final ArrayList<IndexEntry<SearchResult>> seriesIndex = new ArrayList();
    private static final ArrayList<IndexEntry<SearchResult>> animeIndex = new ArrayList();
    private static final ArrayList<IndexEntry<Movie>> movieIndex = new ArrayList();
    private static Pattern formatInfoPattern = releaseInfo.getVideoFormatPattern(true);
    private static final Resource<Pattern> blacklistPattern = Resource.lazy(releaseInfo::getBlacklistPattern);

    public static FileFilter getSystemFilesFilter() {
        return releaseInfo.getSystemFilesFilter();
    }

    public static FileFilter getDiskFolderFilter() {
        return releaseInfo.getDiskFolderFilter();
    }

    public static FileFilter getClutterFileFilter() {
        return releaseInfo.getClutterFileFilter();
    }

    public static boolean isDiskFolder(File folder) {
        return MediaDetection.getDiskFolderFilter().accept(folder);
    }

    public static boolean isClutterFile(File file) throws IOException {
        return MediaDetection.getClutterFileFilter().accept(file);
    }

    public static boolean isVideoDiskFile(File file) throws Exception {
        if (file.isFile() && file.length() > 1000000L) {
            try (Archive iso = Archive.open(file);){
                FileFilter diskFolderEntryFilter = releaseInfo.getDiskFolderEntryFilter();
                for (FileInfo it : iso.listFiles()) {
                    for (File entry : FileUtilities.listPath(it.toFile())) {
                        if (!diskFolderEntryFilter.accept(entry)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public static Locale guessLanguageFromSuffix(File file) {
        return releaseInfo.getSubtitleLanguageTag(FileUtilities.getName(file));
    }

    public static boolean isEpisode(File file, boolean strict) {
        Object metaInfo = XattrMetaInfo.xattr.getMetaInfo(file);
        if (metaInfo instanceof Episode) {
            return true;
        }
        return MediaDetection.isEpisode(String.join((CharSequence)"/", file.getParent(), file.getName()), strict);
    }

    public static boolean isMovie(File file, boolean strict) {
        Object metaInfo = XattrMetaInfo.xattr.getMetaInfo(file);
        if (metaInfo != null) {
            return metaInfo instanceof Movie;
        }
        if (MediaDetection.isEpisode(file, true)) {
            return false;
        }
        if (MediaDetection.matchMovieName(Arrays.asList(file.getName(), file.getParent()), strict, 0).size() > 0) {
            return true;
        }
        return MediaDetection.grepImdbId(file.getPath()).stream().map(Movie::new).filter(m -> {
            try {
                return strict ? WebServices.TheMovieDB.getMovieDescriptor((Movie)m, Locale.US).getId() > 0 : true;
            }
            catch (Exception e) {
                return false;
            }
        }).filter(Objects::nonNull).findFirst().isPresent();
    }

    public static SeasonEpisodeMatcher getSeasonEpisodeMatcher(boolean strict) {
        return strict ? seasonEpisodeMatcherStrict : seasonEpisodeMatcherNonStrict;
    }

    public static DateMatcher getDateMatcher() {
        return dateMatcher;
    }

    public static SeriesNameMatcher getSeriesNameMatcher(boolean strict) {
        return new SeriesNameMatcher(strict ? seasonEpisodeMatcherStrict : seasonEpisodeMatcherNonStrict, dateMatcher);
    }

    public static boolean isEpisode(String name, boolean strict) {
        return MediaDetection.parseEpisodeNumber(name, strict) != null || MediaDetection.parseDate(name) != null;
    }

    public static List<SeasonEpisodeMatcher.SxE> parseEpisodeNumber(String string, boolean strict) {
        return MediaDetection.getSeasonEpisodeMatcher(strict).match(string);
    }

    public static List<SeasonEpisodeMatcher.SxE> parseEpisodeNumber(File file, boolean strict) {
        return MediaDetection.getSeasonEpisodeMatcher(strict).match(file);
    }

    public static SimpleDate parseDate(Object object) {
        if (object instanceof File) {
            return MediaDetection.getDateMatcher().match((File)object);
        }
        return MediaDetection.getDateMatcher().match(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Set<File>, Set<String>> mapSeriesNamesByFiles(Collection<File> files, Locale locale, boolean anime) throws Exception {
        HashMap<File, TreeSet<Object>> seriesNamesByFolder = new HashMap<File, TreeSet<Object>>();
        SortedMap<File, List<File>> filesByFolder = FileUtilities.mapByFolder(files);
        for (Map.Entry entry : filesByFolder.entrySet()) {
            TreeSet<Object> namesForFolder = new TreeSet<Object>(CommonSequenceMatcher.getLenientCollator(locale));
            namesForFolder.addAll(MediaDetection.detectSeriesNames((Collection<File>)((Collection)entry.getValue()), anime, locale));
            seriesNamesByFolder.put((File)entry.getKey(), namesForFolder);
        }
        HashMap foldersBySeriesName = new HashMap();
        for (Set nameSet : seriesNamesByFolder.values()) {
            for (String name : nameSet) {
                HashSet<File> foldersForSeries = new HashSet<File>();
                for (Map.Entry entry : seriesNamesByFolder.entrySet()) {
                    if (!((Set)entry.getValue()).contains(name)) continue;
                    foldersForSeries.add((File)entry.getKey());
                }
                foldersBySeriesName.put(name, foldersForSeries);
            }
        }
        HashMap<Set<File>, Set<String>> hashMap = new HashMap<Set<File>, Set<String>>();
        while (seriesNamesByFolder.size() > 0) {
            boolean modified;
            TreeSet<Object> combinedNameSet = new TreeSet<Object>(CommonSequenceMatcher.getLenientCollator(locale));
            HashSet<File> combinedFolderSet = new HashSet<File>();
            combinedFolderSet.add((File)seriesNamesByFolder.keySet().iterator().next());
            for (boolean resolveFurther = true; resolveFurther; resolveFurther &= modified) {
                modified = false;
                for (File file : combinedFolderSet) {
                    modified |= combinedNameSet.addAll((Collection)seriesNamesByFolder.get(file));
                }
                for (String string : combinedNameSet) {
                    modified |= combinedFolderSet.addAll((Collection)foldersBySeriesName.get(string));
                }
            }
            TreeSet combinedFileSet = new TreeSet();
            for (File file : combinedFolderSet) {
                combinedFileSet.addAll((Collection)filesByFolder.get(file));
            }
            if (combinedFileSet.size() > 0) {
                LinkedHashMap<List<SeasonEpisodeMatcher.SxE>, ArrayList<File>> filesByEpisode = new LinkedHashMap<List<SeasonEpisodeMatcher.SxE>, ArrayList<File>>();
                for (File file : combinedFileSet) {
                    ArrayList<File> episodeFiles;
                    List<SeasonEpisodeMatcher.SxE> d3sxe;
                    List<SeasonEpisodeMatcher.SxE> eid = MediaDetection.getEpisodeIdentifier(file.getName(), true);
                    if (eid == null && (d3sxe = new SeasonEpisodeMatcher.SeasonEpisodePattern(null, "(?<!\\p{Alnum})(\\d)(\\d{2})(?!\\p{Alnum})").match(file.getName())) != null && d3sxe.size() > 0) {
                        eid = d3sxe;
                    }
                    if (eid == null) {
                        eid = file;
                    }
                    if ((episodeFiles = (ArrayList<File>)filesByEpisode.get(eid)) == null) {
                        episodeFiles = new ArrayList<File>();
                        filesByEpisode.put(eid, episodeFiles);
                    }
                    episodeFiles.add(file);
                }
                boolean bl = false;
                while (true) {
                    void var12_23;
                    LinkedHashSet<File> series = new LinkedHashSet<File>();
                    for (List episode : filesByEpisode.values()) {
                        if (var12_23 >= episode.size()) continue;
                        series.add((File)episode.get((int)var12_23));
                    }
                    if (series.isEmpty()) break;
                    combinedFileSet.removeAll(series);
                    hashMap.put(series, combinedNameSet);
                    ++var12_23;
                }
                if (combinedFileSet.size() > 0) {
                    hashMap.put(combinedFileSet, combinedNameSet);
                }
            }
            seriesNamesByFolder.keySet().removeAll(combinedFolderSet);
        }
        HashSet<File> remainingFiles = new HashSet<File>(files);
        for (Set batch : hashMap.keySet()) {
            remainingFiles.removeAll(batch);
        }
        if (remainingFiles.size() > 0) {
            hashMap.put(remainingFiles, null);
        }
        return hashMap;
    }

    public static Object getEpisodeIdentifier(CharSequence name, boolean strict) {
        List<SeasonEpisodeMatcher.SxE> match = MediaDetection.getSeasonEpisodeMatcher(true).match(name);
        if (match == null) {
            match = MediaDetection.getDateMatcher().match(name);
        }
        if (match == null && !strict) {
            match = MediaDetection.getSeasonEpisodeMatcher(false).match(name);
        }
        return match;
    }

    public static List<String> detectSeriesNames(Collection<File> files, boolean anime, Locale locale) throws Exception {
        return MediaDetection.detectSeriesNames(files, anime ? MediaDetection.getAnimeIndex() : MediaDetection.getSeriesIndex(), locale);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> detectSeriesNames(Collection<File> files, List<IndexEntry<SearchResult>> index, Locale locale) throws Exception {
        ArrayList<String> unids = new ArrayList<String>();
        for (File file : files) {
            Object metaObject = XattrMetaInfo.xattr.getMetaInfo(file);
            if (!(metaObject instanceof Episode)) continue;
            unids.add(((Episode)metaObject).getSeriesName());
        }
        if (unids.size() == files.size()) {
            return MediaDetection.getUniqueQuerySet(unids, new Collection[0]);
        }
        try {
            for (SearchResult searchResult : MediaDetection.lookupSeriesNameByInfoFile(files, locale)) {
                unids.add(searchResult.getName());
            }
        }
        catch (Exception e) {
            Logging.debug.warning("Failed to lookup info by id: " + e);
        }
        unids.addAll(MediaDetection.matchSeriesMappings(files));
        SeriesNameMatcher strictSeriesNameMatcher = MediaDetection.getSeriesNameMatcher(true);
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            LinkedHashSet<String> filenames = new LinkedHashSet();
            for (File f : files) {
                for (int i = 0; i < 3 && f != null && !MediaDetection.isStructureRoot(f); ++i, f = f.getParentFile()) {
                    String fn = FileUtilities.getName(f);
                    String sn = strictSeriesNameMatcher.matchByEpisodeIdentifier(fn);
                    if (sn != null) {
                        fn = sn;
                    }
                    (i == 0 ? filenames : linkedHashSet).add(fn);
                }
            }
            List<String> matches = MediaDetection.matchSeriesByName(linkedHashSet, 0, index);
            if (matches.isEmpty()) {
                matches.addAll(MediaDetection.matchSeriesByName((Collection<String>)filenames, 0, index));
                matches.addAll(MediaDetection.matchSeriesByName(MediaDetection.stripReleaseInfo((Collection<String>)filenames, false), 0, index));
            }
            if (matches.isEmpty()) {
                void var9_20;
                ArrayList<String> sns = new ArrayList<String>();
                sns.addAll(linkedHashSet);
                sns.addAll(filenames);
                boolean bl = false;
                while (var9_20 < sns.size()) {
                    String sn = strictSeriesNameMatcher.matchByEpisodeIdentifier((String)sns.get((int)var9_20));
                    if (sn != null) {
                        sns.set((int)var9_20, sn);
                    }
                    ++var9_20;
                }
                for (SearchResult it : MediaDetection.matchSeriesFromStringWithoutSpacing(MediaDetection.stripReleaseInfo(sns, false), true, index)) {
                    matches.add(it.getName());
                }
                matches.addAll(MediaDetection.matchSeriesByName(linkedHashSet, 2, index));
                matches.addAll(MediaDetection.matchSeriesByName(filenames, 2, index));
                unids.addAll(MediaDetection.stripBlacklistedTerms(matches));
            } else {
                unids.addAll(matches);
            }
        }
        catch (Exception exception) {
            Logging.debug.warning("Failed to match folder structure: " + exception);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Object object : (LinkedHashSet<String>)new boolean[]{true, false}) {
            if (!linkedHashSet.isEmpty()) continue;
            SeriesNameMatcher seriesNameMatcher = MediaDetection.getSeriesNameMatcher((boolean)object);
            linkedHashSet.addAll(strictSeriesNameMatcher.matchAll(files.toArray(new File[files.size()])));
            if (!linkedHashSet.isEmpty()) continue;
            block11: for (File f : files) {
                for (File path : FileUtilities.listPathTail(f, 2, true)) {
                    String fn = FileUtilities.getName(path);
                    if (object == false && MediaDetection.parseMovieYear(fn).size() > 0) continue block11;
                    String sn = seriesNameMatcher.matchByEpisodeIdentifier(fn);
                    if (sn != null && sn.length() > 0) {
                        String sn2;
                        if (object == false && (sn2 = seriesNameMatcher.matchBySeparator(fn)) != null && sn2.length() > 0 && sn2.length() < sn.length()) {
                            sn = sn2;
                        }
                        linkedHashSet.add(sn);
                        continue block11;
                    }
                    if (sn != null || !path.isDirectory()) continue;
                    linkedHashSet.addAll(MediaDetection.stripBlacklistedTerms(MediaDetection.stripReleaseInfo(Collections.singleton(path.getName()), true)));
                }
            }
        }
        Logging.debug.finest(Logging.format("Match Series Name => %s %s", unids, linkedHashSet));
        List<String> querySet = MediaDetection.getUniqueQuerySet(unids, linkedHashSet);
        Logging.debug.finest(Logging.format("Query Series => %s", querySet));
        return querySet;
    }

    public static List<String> matchSeriesMappings(Collection<File> files) {
        try {
            Map<Pattern, String> patterns = releaseInfo.getSeriesMappings();
            ArrayList<String> matches = new ArrayList<String>();
            for (File file : files) {
                patterns.forEach((pattern, seriesName) -> {
                    if (pattern.matcher(FileUtilities.getName(file)).find()) {
                        matches.add((String)seriesName);
                    }
                });
            }
            return matches;
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to load series mappings: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static List<IndexEntry<SearchResult>> getSeriesIndex() throws IOException {
        return MediaDetection.getIndex(() -> {
            try {
                return releaseInfo.getTheTVDBIndex();
            }
            catch (Exception e) {
                Logging.debug.severe("Failed to load series index: " + e.getMessage());
                return new SearchResult[0];
            }
        }, HighPerformanceMatcher::prepare, seriesIndex);
    }

    public static List<IndexEntry<SearchResult>> getAnimeIndex() {
        return MediaDetection.getIndex(() -> {
            try {
                return releaseInfo.getAnidbIndex();
            }
            catch (Exception e) {
                Logging.debug.severe("Failed to load anime index: " + e.getMessage());
                return new SearchResult[0];
            }
        }, HighPerformanceMatcher::prepare, animeIndex);
    }

    public static List<String> matchSeriesByName(Collection<String> files, int maxStartIndex, List<IndexEntry<SearchResult>> index) throws Exception {
        HighPerformanceMatcher nameMatcher = new HighPerformanceMatcher(maxStartIndex);
        ArrayList<String> matches = new ArrayList<String>();
        for (CollationKey[] name : HighPerformanceMatcher.prepare(files)) {
            IndexEntry<SearchResult> bestMatch = null;
            for (IndexEntry<SearchResult> it : index) {
                CollationKey[] commonName = (CollationKey[])nameMatcher.matchFirstCommonSequence(new CollationKey[][]{name, it.getLenientKey()});
                if (commonName == null || commonName.length < it.getLenientKey().length || bestMatch != null && commonName.length <= bestMatch.getLenientKey().length) continue;
                bestMatch = it;
            }
            if (bestMatch == null) continue;
            matches.add(bestMatch.getLenientName());
        }
        return matches.stream().sorted((a, b) -> Integer.compare(b.length(), a.length())).collect(Collectors.toList());
    }

    public static List<SearchResult> matchSeriesFromStringWithoutSpacing(Collection<String> names, boolean strict, List<IndexEntry<SearchResult>> index) throws IOException {
        Pattern spacing = Pattern.compile("(^(?i)(The|A)\\b)|[\\p{Punct}\\p{Space}]+");
        ArrayList<String> terms = new ArrayList<String>(names.size());
        for (String it : names) {
            String term = spacing.matcher(it).replaceAll("").toLowerCase();
            if (term.length() < 3) continue;
            terms.add(term);
        }
        NameSimilarityMetric metric = new NameSimilarityMetric();
        float similarityThreshold = strict ? 0.75f : 0.5f;
        ArrayList<SearchResult> seriesList = new ArrayList<SearchResult>();
        block1: for (IndexEntry<SearchResult> it : index) {
            String name = spacing.matcher(it.getLenientName()).replaceAll("").toLowerCase();
            for (String term : terms) {
                if (!term.contains(name)) continue;
                if (!(metric.getSimilarity(term, name) >= similarityThreshold)) continue block1;
                seriesList.add(it.getObject());
                continue block1;
            }
        }
        return seriesList;
    }

    public static List<Movie> detectMovie(File movieFile, MovieIdentificationService service, Locale locale, boolean strict) throws Exception {
        List<String> alternativeTerms;
        Set<String> terms;
        List<Movie> movieNameMatches;
        Iterator<Integer> metaObject;
        ArrayList<Movie> options = new ArrayList<Movie>();
        if (movieFile.exists() && (metaObject = XattrMetaInfo.xattr.getMetaInfo(movieFile)) instanceof Movie) {
            options.add((Movie)((Object)metaObject));
        }
        if (service != null) {
            Movie movie;
            for (int imdbid : MediaDetection.grepImdbId(movieFile.getPath())) {
                movie = service.getMovieDescriptor(new Movie(imdbid), locale);
                if (movie == null) continue;
                options.add(movie);
            }
            try {
                for (int imdbid : MediaDetection.grepImdbIdFor(movieFile)) {
                    movie = service.getMovieDescriptor(new Movie(imdbid), locale);
                    if (movie == null) continue;
                    options.add(movie);
                }
            }
            catch (Exception e) {
                Logging.debug.warning("Failed to lookup info by id: " + e);
            }
        }
        ArrayList<String> names = new ArrayList<String>(2);
        names.add(FileUtilities.getName(movieFile));
        File movieFolder = MediaDetection.guessMovieFolder(movieFile);
        if (movieFolder != null) {
            names.add(FileUtilities.getName(movieFolder));
        }
        if ((movieNameMatches = MediaDetection.matchMovieName(terms = MediaDetection.reduceMovieNamePermutations(names), true, 0)).size() > 0) {
            options.addAll(movieNameMatches);
            return MediaDetection.sortMoviesBySimilarity(options, terms);
        }
        if (movieNameMatches.isEmpty()) {
            movieNameMatches = MediaDetection.matchMovieName(terms, strict, 2);
        }
        if (options.size() > 0 && movieNameMatches.size() > 0) {
            options.addAll(movieNameMatches);
            return MediaDetection.sortMoviesBySimilarity(options, terms);
        }
        if (movieNameMatches.isEmpty() && strict && (movieNameMatches = MediaDetection.matchMovieName(terms, false, 0)).isEmpty()) {
            movieNameMatches = MediaDetection.matchMovieName(terms, false, 2);
        }
        if (movieNameMatches.isEmpty() && (movieNameMatches = MediaDetection.matchMovieFromStringWithoutSpacing(terms, strict)).isEmpty() && !terms.containsAll(alternativeTerms = MediaDetection.stripReleaseInfo(terms, true))) {
            movieNameMatches = MediaDetection.matchMovieFromStringWithoutSpacing(alternativeTerms, strict);
        }
        if (service != null) {
            List<Movie> results = MediaDetection.queryMovieByFileName(terms, service, locale);
            if (results.isEmpty() && !strict) {
                ArrayList<String> lastResortQueryList = new ArrayList<String>();
                Pattern yearPattern = Pattern.compile("(?:19|20)\\d{2}");
                Pattern akaPattern = Pattern.compile("\\bAKA\\b", 2);
                for (String term : terms) {
                    if (!yearPattern.matcher(term).find() && !akaPattern.matcher(term).find()) continue;
                    for (String mn : akaPattern.split(yearPattern.matcher(term).replaceAll(""))) {
                        lastResortQueryList.add(mn.trim());
                    }
                }
                if (lastResortQueryList.size() > 0) {
                    results = MediaDetection.queryMovieByFileName(lastResortQueryList, service, locale);
                }
            }
            options.addAll(results);
        }
        options.addAll(movieNameMatches);
        return MediaDetection.sortMoviesBySimilarity(options, terms);
    }

    public static List<Movie> detectMovieWithYear(File movieFile, MovieIdentificationService service, Locale locale, boolean strict) throws Exception {
        if (!strict) {
            return MediaDetection.detectMovie(movieFile, service, locale, strict);
        }
        List<Integer> year = MediaDetection.parseMovieYear(FileUtilities.getRelativePathTail(movieFile, 3).getPath());
        if (year.isEmpty() || MediaDetection.isEpisode(movieFile, true)) {
            return null;
        }
        return MediaDetection.detectMovie(movieFile, service, locale, strict).stream().filter(m -> year.contains(m.getYear())).collect(Collectors.toList());
    }

    public static SimilarityMetric getMovieMatchMetric() {
        return new MetricAvg(new NameSimilarityMetric(), new StringEqualsMetric(){

            @Override
            protected String normalize(Object object) {
                return super.normalize(Normalization.removeTrailingBrackets(object.toString()));
            }
        }, new NumericSimilarityMetric(){
            private Pattern year = Pattern.compile("\\b\\d{4}\\b");

            @Override
            protected String normalize(Object object) {
                return StringUtilities.streamMatches(object.toString(), this.year).mapToInt(Integer::parseInt).flatMap(i -> IntStream.of(i, i + 1)).mapToObj(Objects::toString).collect(Collectors.joining(" "));
            }

            @Override
            public float getSimilarity(Object o1, Object o2) {
                return super.getSimilarity(o1, o2) * 2.0f;
            }
        }, new SequenceMatchSimilarity(), new SequenceMatchSimilarity(0, true));
    }

    public static Movie getLocalizedMovie(MovieIdentificationService service, Movie movie, Locale locale) throws Exception {
        if (movie != null) {
            try {
                return service.getMovieDescriptor(movie, locale);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Failed to retrieve localized movie data", e);
            }
        }
        return null;
    }

    public static SimilarityMetric getSeriesMatchMetric() {
        return new MetricAvg(new SequenceMatchSimilarity(), new NameSimilarityMetric(), new SequenceMatchSimilarity(0, true));
    }

    public static <T extends SearchResult> List<T> sortBySimilarity(Collection<T> options, Collection<String> terms, SimilarityMetric metric) {
        return MediaDetection.sortBySimilarity(options, terms, metric, SearchResult::getEffectiveNames);
    }

    public static <T extends SearchResult> List<T> sortBySimilarity(Collection<T> options, Collection<String> terms, SimilarityMetric metric, Function<SearchResult, Collection<String>> mapper) {
        SimilarityComparator<SearchResult, String> comparator = new SimilarityComparator<SearchResult, String>(metric, terms, mapper);
        List ranking = options.stream().sorted(comparator).distinct().collect(Collectors.toList());
        Logging.debug.finest(Logging.format("Rank %s => %s", terms, ranking));
        return ranking;
    }

    public static List<Movie> sortMoviesBySimilarity(Collection<Movie> options, Collection<String> terms) throws Exception {
        TreeSet<String> paragon = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        paragon.addAll(MediaDetection.stripReleaseInfo(terms, true));
        paragon.addAll(MediaDetection.stripReleaseInfo(terms, false));
        return MediaDetection.sortBySimilarity(options, paragon, MediaDetection.getMovieMatchMetric());
    }

    public static boolean isEpisodeNumberMatch(File f, Episode e) {
        float similarity = EpisodeMetrics.EpisodeIdentifier.getSimilarity(f, e);
        if (similarity >= 1.0f) {
            return true;
        }
        if ((double)similarity >= 0.5 && e.getSeason() == null && e.getEpisode() != null && e.getSpecial() == null) {
            List<SeasonEpisodeMatcher.SxE> numbers = MediaDetection.parseEpisodeNumber(f, false);
            return numbers != null && numbers.stream().anyMatch(it -> it.season < 0 && it.episode == e.getEpisode());
        }
        return false;
    }

    public static List<Integer> parseMovieYear(String name) {
        return StringUtilities.matchIntegers(name).stream().filter(DateMatcher.DEFAULT_SANITY::acceptYear).collect(Collectors.toList());
    }

    public static String reduceMovieName(String name, boolean strict) throws IOException {
        Matcher matcher = Pattern.compile(strict ? "^(.+)[\\[\\(]((?:19|20)\\d{2})[\\]\\)]" : "^(.+?)((?:19|20)\\d{2})").matcher(name);
        if (matcher.find() && MediaDetection.parseMovieYear(matcher.group(2)).size() > 0) {
            return String.format("%s %s", Normalization.trimTrailingPunctuation(matcher.group(1)), matcher.group(2));
        }
        return null;
    }

    public static Set<String> reduceMovieNamePermutations(Collection<String> terms) throws IOException {
        LinkedList<String> names = new LinkedList<String>();
        for (String it : terms) {
            String rn = MediaDetection.reduceMovieName(it, true);
            if (rn != null) {
                names.addFirst(rn);
                continue;
            }
            names.addLast(it);
            rn = MediaDetection.reduceMovieName(it, false);
            if (rn == null) continue;
            names.addLast(rn);
        }
        return new LinkedHashSet<String>(names);
    }

    public static File guessMovieFolder(File movieFile) throws Exception {
        if (movieFile.isDirectory()) {
            File f = movieFile;
            if (!MediaDetection.isStructureRoot(f.getParentFile()) && MediaDetection.checkMovie(f.getParentFile(), false) != null && MediaDetection.checkMovie(f, false) == null) {
                return f.getParentFile();
            }
            return MediaDetection.isStructureRoot(f) ? null : f;
        }
        for (boolean strictness : new boolean[]{true, false}) {
            File f = movieFile.getParentFile();
            for (int i = 0; f != null && i < 4 && !MediaDetection.isStructureRoot(f); f = f.getParentFile(), ++i) {
                String term = MediaDetection.stripReleaseInfo(f.getName());
                if (term.length() <= 0 || MediaDetection.checkMovie(f, strictness) == null) continue;
                return f;
            }
        }
        Object f = movieFile.getParentFile();
        for (int i = 0; f != null && i < 2 && !MediaDetection.isStructureRoot((File)f); f = ((File)f).getParentFile(), ++i) {
            String term = MediaDetection.stripReleaseInfo(((File)f).getName());
            if (term.length() <= 0) continue;
            if (MediaDetection.checkMovie(((File)f).getParentFile(), false) != null && MediaDetection.checkMovie((File)f, false) == null) {
                return ((File)f).getParentFile();
            }
            return f;
        }
        if (movieFile.getParentFile() != null && !MediaDetection.isStructureRoot(((File)f).getParentFile()) && MediaDetection.stripReleaseInfo(movieFile.getParentFile().getName()).length() > 0) {
            return movieFile.getParentFile();
        }
        return null;
    }

    public static Movie checkMovie(File file, boolean strict) {
        List<Movie> matches = file == null ? null : MediaDetection.matchMovieName(Collections.singleton(file.getName()), strict, 4);
        return matches == null || matches.isEmpty() ? null : matches.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends SearchResult> List<IndexEntry<T>> getIndex(Supplier<T[]> function, Function<T, List<IndexEntry<T>>> mapper, ArrayList<IndexEntry<T>> sink) {
        ArrayList<IndexEntry<T>> arrayList = sink;
        synchronized (arrayList) {
            if (sink.isEmpty()) {
                SearchResult[] index = (SearchResult[])function.get();
                sink.ensureCapacity(index.length * 4);
                Arrays.stream(index).map(mapper).forEach(sink::addAll);
            }
            return sink;
        }
    }

    public static List<IndexEntry<Movie>> getMovieIndex() {
        return MediaDetection.getIndex(() -> {
            try {
                return releaseInfo.getMovieList();
            }
            catch (Exception e) {
                Logging.debug.severe("Failed to load movie index: " + e.getMessage());
                return new Movie[0];
            }
        }, HighPerformanceMatcher::prepare, movieIndex);
    }

    public static List<Movie> matchMovieName(Collection<String> files, boolean strict, int maxStartIndex) {
        HighPerformanceMatcher nameMatcher = new HighPerformanceMatcher(maxStartIndex);
        HashMap<Movie, String> matchMap = new HashMap<Movie, String>();
        List<CollationKey[]> names = HighPerformanceMatcher.prepare(files);
        for (IndexEntry<Movie> movie : MediaDetection.getMovieIndex()) {
            for (CollationKey[] name : names) {
                CollationKey[] commonName = (CollationKey[])nameMatcher.matchFirstCommonSequence(new CollationKey[][]{name, movie.getLenientKey()});
                if (commonName == null || commonName.length < movie.getLenientKey().length) continue;
                CollationKey[] strictCommonName = (CollationKey[])nameMatcher.matchFirstCommonSequence(new CollationKey[][]{name, movie.getStrictKey()});
                if (strictCommonName != null && strictCommonName.length >= movie.getStrictKey().length) {
                    matchMap.put(movie.getObject(), movie.getStrictName());
                    continue;
                }
                if (strict) continue;
                matchMap.put(movie.getObject(), movie.getLenientName());
            }
        }
        return matchMap.keySet().stream().sorted((a, b) -> Integer.compare(((String)matchMap.get(b)).length(), ((String)matchMap.get(a)).length())).collect(Collectors.toList());
    }

    public static List<Movie> matchMovieFromStringWithoutSpacing(Collection<String> names, boolean strict) {
        Pattern spacing = Pattern.compile("(^(?i)(The|A)\\b)|[\\p{Punct}\\p{Space}]+");
        ArrayList<String> terms = new ArrayList<String>(names.size());
        for (String it : names) {
            String term = spacing.matcher(it).replaceAll("").toLowerCase();
            if (term.length() < 3) continue;
            terms.add(term);
        }
        NameSimilarityMetric metric = new NameSimilarityMetric();
        float similarityThreshold = strict ? 0.9f : 0.5f;
        LinkedList<Movie> movies = new LinkedList<Movie>();
        block1: for (IndexEntry<Movie> it : MediaDetection.getMovieIndex()) {
            String name = spacing.matcher(it.getLenientName()).replaceAll("").toLowerCase();
            for (String term : terms) {
                if (!term.contains(name)) continue;
                String year = String.valueOf(it.getObject().getYear());
                if (term.contains(year) && metric.getSimilarity(term, name + year) > similarityThreshold) {
                    movies.addFirst(it.getObject());
                    continue block1;
                }
                if (!(metric.getSimilarity(term, name) > similarityThreshold)) continue block1;
                movies.addLast(it.getObject());
                continue block1;
            }
        }
        return new ArrayList<Movie>(movies);
    }

    private static List<Movie> queryMovieByFileName(Collection<String> files, MovieIdentificationService queryLookupService, Locale locale) throws Exception {
        List<String> querySet = MediaDetection.getUniqueQuerySet(Collections.emptySet(), files);
        Logging.debug.finest(Logging.format("Query Movie => %s", querySet));
        LinkedHashMap<Movie, Float> probabilityMap = new LinkedHashMap<Movie, Float>();
        SimilarityMetric metric = MediaDetection.getMovieMatchMetric();
        for (String query : querySet) {
            for (Movie movie : queryLookupService.searchMovie(query.toLowerCase(), locale)) {
                probabilityMap.put(movie, Float.valueOf(metric.getSimilarity(query, movie)));
            }
        }
        ArrayList<Movie> results = new ArrayList<Movie>(probabilityMap.keySet());
        results.sort((a, b) -> ((Float)probabilityMap.get(b)).compareTo((Float)probabilityMap.get(a)));
        return results;
    }

    private static List<String> getUniqueQuerySet(Collection<String> exactMatches, Collection<String> ... guessMatches) {
        LinkedHashMap<String, String> unique = new LinkedHashMap<String, String>();
        Function<String, String> normalize = s -> Normalization.normalizePunctuation(s).toLowerCase();
        MediaDetection.addUniqueQuerySet(exactMatches, normalize, Function.identity(), unique);
        List<String> extra = Arrays.stream(guessMatches).flatMap(Collection::stream).filter(t -> !unique.containsKey(normalize.apply((String)t))).collect(Collectors.toList());
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(MediaDetection.stripReleaseInfo(extra, true));
        terms.addAll(MediaDetection.stripReleaseInfo(extra, false));
        MediaDetection.addUniqueQuerySet(MediaDetection.stripBlacklistedTerms(terms), normalize, normalize, unique);
        return new ArrayList<String>(unique.values());
    }

    private static void addUniqueQuerySet(Collection<String> terms, Function<String, String> keyFunction, Function<String, String> valueFunction, Map<String, String> uniqueMap) {
        for (String term : terms) {
            String key;
            if (term == null || term.length() <= 0 || (key = keyFunction.apply(term)) == null || key.length() <= 0) continue;
            uniqueMap.computeIfAbsent(key, k -> (String)valueFunction.apply(term));
        }
    }

    public static List<Movie> matchMovieByWordSequence(String name, Collection<Movie> options, int maxStartIndex) {
        ArrayList<Movie> movies = new ArrayList<Movie>();
        HighPerformanceMatcher nameMatcher = new HighPerformanceMatcher(maxStartIndex);
        CollationKey[] nameSeq = HighPerformanceMatcher.prepare(Normalization.normalizePunctuation(name));
        block0: for (Movie movie : options) {
            for (String alias : movie.getEffectiveNames()) {
                CollationKey[] movieSeq = HighPerformanceMatcher.prepare(Normalization.normalizePunctuation(alias));
                CollationKey[] commonSeq = (CollationKey[])nameMatcher.matchFirstCommonSequence(new CollationKey[][]{nameSeq, movieSeq});
                if (commonSeq == null || commonSeq.length < movieSeq.length) continue;
                movies.add(movie);
                continue block0;
            }
        }
        return movies;
    }

    public static String stripFormatInfo(CharSequence name) {
        return formatInfoPattern.matcher(name).replaceAll("");
    }

    public static boolean isVolumeRoot(File folder) {
        return folder == null || folder.getName() == null || folder.getName().isEmpty() || releaseInfo.getVolumeRoots().contains(folder);
    }

    public static boolean isStructureRoot(File folder) throws Exception {
        return MediaDetection.isVolumeRoot(folder) || releaseInfo.getStructureRootPattern().matcher(folder.getName()).matches() || ApplicationFolder.UserHome.get().equals(folder.getParentFile());
    }

    public static File getStructureRoot(File file) throws Exception {
        boolean structureRoot = false;
        for (File it : FileUtilities.listPathTail(file, Integer.MAX_VALUE, true)) {
            if (!structureRoot && !MediaDetection.isStructureRoot(it)) continue;
            if (it.isDirectory()) {
                return it;
            }
            structureRoot = true;
        }
        return null;
    }

    public static List<String> listStructurePathTail(File file) throws Exception {
        LinkedList<String> relativePath = new LinkedList<String>();
        for (File it : FileUtilities.listPathTail(file, 32, true)) {
            if (MediaDetection.isStructureRoot(it)) break;
            relativePath.addFirst(it.getName());
        }
        return relativePath;
    }

    public static File getStructurePathTail(File file) throws Exception {
        List<String> relativePath = MediaDetection.listStructurePathTail(file);
        return relativePath.isEmpty() ? null : new File(String.join((CharSequence)File.separator, relativePath));
    }

    public static Map<File, List<File>> mapByMediaFolder(Collection<File> files) {
        HashMap<File, List<File>> mediaFolders = new HashMap<File, List<File>>();
        for (File f : files) {
            File folder = MediaDetection.guessMediaFolder(f);
            ArrayList<File> value = (ArrayList<File>)mediaFolders.get(folder);
            if (value == null) {
                value = new ArrayList<File>();
                mediaFolders.put(folder, value);
            }
            value.add(f);
        }
        return mediaFolders;
    }

    public static Map<String, List<File>> mapByMediaExtension(Iterable<File> files) {
        LinkedHashMap<String, List<File>> map = new LinkedHashMap<String, List<File>>();
        for (File file : files) {
            ArrayList<File> valueList;
            Locale locale;
            Object key = FileUtilities.getExtension(file);
            if (key != null && MediaTypes.SUBTITLE_FILES.accept(file) && (locale = releaseInfo.getSubtitleLanguageTag(FileUtilities.getName(file))) != null) {
                key = locale.getLanguage() + "." + (String)key;
            }
            if (key != null) {
                key = ((String)key).toLowerCase();
            }
            if ((valueList = (ArrayList<File>)map.get(key)) == null) {
                valueList = new ArrayList<File>();
                map.put((String)key, valueList);
            }
            valueList.add(file);
        }
        return map;
    }

    public static List<List<File>> groupByMediaCharacteristics(Collection<File> files) {
        ArrayList<List<File>> groups = new ArrayList<List<File>>();
        FileUtilities.mapByExtension(files).forEach((extension, filesByExtension) -> {
            if (filesByExtension.size() < 2) {
                groups.add((List<File>)filesByExtension);
                return;
            }
            filesByExtension.stream().collect(Collectors.groupingBy(f -> {
                if (MediaTypes.VIDEO_FILES.accept((File)f) && f.length() > 1000000L) {
                    List<Object> list;
                    block14: {
                        MediaInfo mi = new MediaInfo().open((File)f);
                        Throwable throwable = null;
                        try {
                            ChronoUnit d = Duration.ofMillis(Long.parseLong(mi.get(MediaInfo.StreamKind.General, 0, "Duration"))).toMinutes() < 10L ? ChronoUnit.MINUTES : ChronoUnit.HOURS;
                            String v = mi.get(MediaInfo.StreamKind.Video, 0, "CodecID");
                            String a = mi.get(MediaInfo.StreamKind.Audio, 0, "CodecID");
                            String w = mi.get(MediaInfo.StreamKind.Video, 0, "Width");
                            String h = mi.get(MediaInfo.StreamKind.Video, 0, "Height");
                            list = Arrays.asList(d, v, a, w, h);
                            if (mi == null) break block14;
                        }
                        catch (Throwable throwable2) {
                            try {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (mi != null) {
                                        MediaDetection.$closeResource(throwable, mi);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Exception e) {
                                Logging.debug.warning(Logging.format("Failed to read media characteristics: %s", e.getMessage()));
                            }
                        }
                        MediaDetection.$closeResource(throwable, mi);
                    }
                    return list;
                } else if (MediaTypes.SUBTITLE_FILES.accept((File)f) && f.length() > 1000L) {
                    try {
                        Language language = SubtitleUtilities.detectSubtitleLanguage(f);
                        if (language != null) {
                            return Arrays.asList(language.getCode());
                        }
                    }
                    catch (Exception e) {
                        Logging.debug.warning(Logging.format("Failed to detect subtitle language: %s", e.getMessage()));
                    }
                }
                return Optional.ofNullable(MediaDetection.guessMediaFolder(f)).map(File::getName);
            }, LinkedHashMap::new, Collectors.toList())).forEach((group, videos) -> groups.add((List<File>)videos));
        });
        return groups;
    }

    public static Map<String, List<File>> mapBySeriesName(Collection<File> files, boolean anime, Locale locale) throws Exception {
        TreeMap<String, List<File>> result = new TreeMap<String, List<File>>(String.CASE_INSENSITIVE_ORDER);
        for (File f : files) {
            List<String> names = MediaDetection.detectSeriesNames(Collections.singleton(f), anime, locale);
            String key = names.isEmpty() ? "" : names.get(0);
            ArrayList<File> value = (ArrayList<File>)result.get(key);
            if (value == null) {
                value = new ArrayList<File>();
                result.put(key, value);
            }
            value.add(f);
        }
        return result;
    }

    public static Movie matchMovie(File file, int depth) {
        ArrayList<String> names = new ArrayList<String>(depth);
        for (File it : FileUtilities.listPathTail(file, depth, true)) {
            names.add(it.getName());
        }
        List<Movie> matches = MediaDetection.matchMovieName(names, true, 0);
        return matches.size() > 0 ? matches.get(0) : null;
    }

    public static File guessMediaFolder(File file) {
        List<File> tail = FileUtilities.listPathTail(file, 3, true);
        for (int i = 1; i < tail.size(); ++i) {
            File folder = tail.get(i);
            String term = MediaDetection.stripReleaseInfo(folder.getName());
            if (term.length() <= 0) continue;
            return folder;
        }
        return file.getParentFile();
    }

    public static List<String> stripReleaseInfo(Collection<String> names, boolean strict) {
        try {
            return releaseInfo.cleanRelease(names, strict);
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to strip release info: " + e.getMessage(), e);
            return new ArrayList<String>(names);
        }
    }

    public static String stripReleaseInfo(String name, boolean strict) {
        Iterator<String> value = MediaDetection.stripReleaseInfo(Collections.singleton(name), strict).iterator();
        if (value.hasNext()) {
            return value.next();
        }
        return "";
    }

    public static String stripReleaseInfo(String name) {
        return MediaDetection.stripReleaseInfo(name, true);
    }

    public static List<String> stripBlacklistedTerms(Collection<String> names) {
        try {
            Pattern pattern = blacklistPattern.get();
            return names.stream().filter(s -> pattern.matcher((CharSequence)s).replaceAll("").trim().length() > 0).collect(Collectors.toList());
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to strip release info: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static Set<Integer> grepImdbIdFor(File file) throws Exception {
        LinkedHashSet<Integer> collection = new LinkedHashSet<Integer>();
        ArrayList<File> nfoFiles = new ArrayList<File>();
        if (file.isDirectory()) {
            nfoFiles.addAll(FileUtilities.listFiles(file, MediaTypes.NFO_FILES));
        } else if (file.getParentFile() != null && file.getParentFile().isDirectory()) {
            nfoFiles.addAll(FileUtilities.getChildren(file.getParentFile(), MediaTypes.NFO_FILES));
        }
        for (File nfo : nfoFiles) {
            collection.addAll(MediaDetection.grepImdbId(FileUtilities.readTextFile(nfo)));
        }
        return collection;
    }

    public static Set<SearchResult> lookupSeriesNameByInfoFile(Collection<File> files, Locale language) throws Exception {
        LinkedHashSet<SearchResult> names = new LinkedHashSet<SearchResult>();
        TreeSet folders = new TreeSet(Collections.reverseOrder());
        for (File f : files) {
            for (int i = 0; i < 2 && f.getParentFile() != null; ++i) {
                f = f.getParentFile();
                folders.add(f);
            }
        }
        for (File folder : folders) {
            if (!folder.exists()) continue;
            for (File nfo : FileUtilities.getChildren(folder, MediaTypes.NFO_FILES)) {
                SearchResult series;
                String text = FileUtilities.readTextFile(nfo);
                for (int imdbid : MediaDetection.grepImdbId(text)) {
                    series = WebServices.TheTVDB.lookupByIMDbID(imdbid, language);
                    if (series == null) continue;
                    names.add(series);
                }
                for (int tvdbid : MediaDetection.grepTheTvdbId(text)) {
                    series = WebServices.TheTVDB.lookupByID(tvdbid, language);
                    if (series == null) continue;
                    names.add(series);
                }
            }
        }
        return names;
    }

    public static List<Integer> grepImdbId(CharSequence text) {
        Pattern imdbId = Pattern.compile("(?<!\\p{Alnum})tt(\\d{7})(?!\\p{Alnum})", 2);
        return StringUtilities.streamMatches(text, imdbId, m -> m.group(1)).map(Integer::parseInt).collect(Collectors.toList());
    }

    public static List<Integer> grepTheTvdbId(CharSequence text) {
        Pattern tvdbUrl = Pattern.compile("thetvdb.com[\\p{Graph}]*?[\\p{Punct}]id=(\\d+)", 2);
        return StringUtilities.streamMatches(text, tvdbUrl, m -> m.group(1)).map(Integer::parseInt).collect(Collectors.toList());
    }

    public static Movie grepMovie(File nfo, MovieIdentificationService resolver, Locale locale) throws Exception {
        List<Integer> imdbId = MediaDetection.grepImdbId(FileUtilities.readTextFile(nfo));
        return imdbId.isEmpty() ? null : resolver.getMovieDescriptor(new Movie(imdbId.get(0)), locale);
    }

    public static SeriesInfo grepSeries(File nfo, Locale locale) throws Exception {
        List<Integer> tvdbId = MediaDetection.grepTheTvdbId(FileUtilities.readTextFile(nfo));
        return tvdbId.isEmpty() ? null : WebServices.TheTVDB.getSeriesInfo(tvdbId.get(0), locale);
    }

    public static <T extends SearchResult> List<T> getProbableMatches(String query, Collection<T> options, boolean alias, boolean strict) {
        if (query == null) {
            return options.stream().distinct().collect(Collectors.toList());
        }
        Function<SearchResult, Collection<String>> names = alias ? SearchResult::getEffectiveNames : f -> Collections.singleton(f.getName());
        ArrayList<SearchResult> probableMatches = new ArrayList<SearchResult>();
        NameSimilarityMetric metric = new NameSimilarityMetric();
        float threshold = strict && options.size() > 1 ? 0.8f : 0.6f;
        float sanity = strict && options.size() > 1 ? 0.5f : 0.2f;
        String q = Normalization.removeTrailingBrackets(query).toLowerCase();
        for (SearchResult option : options) {
            float f2 = 0.0f;
            for (String n : names.apply(option)) {
                if (!((f2 = Math.max(f2, metric.getSimilarity(q, n = Normalization.removeTrailingBrackets(n).toLowerCase()))) >= sanity) || !n.startsWith(q)) continue;
                f2 = 1.0f;
                break;
            }
            if (!(f2 >= threshold)) continue;
            probableMatches.add(option);
        }
        return MediaDetection.sortBySimilarity(probableMatches, Collections.singleton(query), new NameSimilarityMetric(), names);
    }

    public static void warmupCachedResources() throws Exception {
        MediaDetection.getClutterFileFilter();
        MediaDetection.getDiskFolderFilter();
        MediaDetection.matchSeriesMappings(Collections.emptyList());
        MediaDetection.stripReleaseInfo(Collections.singleton(""), true);
        MediaDetection.matchSeriesByName(Collections.singleton(""), -1, MediaDetection.getSeriesIndex());
        MediaDetection.matchSeriesByName(Collections.singleton(""), -1, MediaDetection.getAnimeIndex());
        MediaDetection.matchMovieName(Collections.singleton(""), true, -1);
    }
}

