/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.filebot.similarity.Normalization;
import net.filebot.util.FileUtilities;
import net.filebot.web.AudioTrack;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.Movie;
import net.filebot.web.MoviePart;

public enum NamingStandard {
    Plex;

    public static final int TITLE_MAX_LENGTH = 150;

    public String getPath(Object o) {
        if (o instanceof Episode) {
            return this.getPath((Episode)o);
        }
        if (o instanceof Movie) {
            return this.getPath((Movie)o);
        }
        if (o instanceof AudioTrack) {
            return this.getPath((AudioTrack)o);
        }
        return null;
    }

    public String getPath(Episode e) {
        String episodeTitle = Normalization.truncateText(EpisodeFormat.SeasonEpisode.formatMultiTitle(EpisodeUtilities.getMultiEpisodeList(e)), 150);
        if (EpisodeUtilities.isAnime(e)) {
            String primaryTitle = e.getSeriesInfo().getName();
            String episode = String.join((CharSequence)" - ", primaryTitle, EpisodeFormat.SeasonEpisode.formatSxE(e), episodeTitle);
            return NamingStandard.path(this.getAnimeFolder(), primaryTitle, episode);
        }
        String episode = String.join((CharSequence)" - ", e.getSeriesName(), EpisodeFormat.SeasonEpisode.formatS00E00(e), episodeTitle);
        String season = e.getSpecial() != null ? this.getSpecialFolder(e.getSeason()) : (e.getSeason() != null ? this.getSeasonFolder(e.getSeason()) : null);
        return NamingStandard.path(this.getSeriesFolder(), e.getSeriesName(), season, episode);
    }

    public String getPath(Movie m) {
        String name = m.getNameWithYear();
        if (m instanceof MoviePart) {
            name = String.format("%s CD%d", name, ((MoviePart)m).getPartIndex());
        }
        return NamingStandard.path(this.getMovieFolder(), m.getNameWithYear(), name);
    }

    public String getPath(AudioTrack a) {
        String name = NamingStandard.first(a.getTrackTitle(), a.getTitle());
        if (a.getTrack() != null) {
            name = String.format("%02d - %s", a.getTrack(), name);
        }
        return NamingStandard.path(this.getMusicFolder(), a.getArtist(), a.getAlbum(), name);
    }

    private static String path(String ... name) {
        return Arrays.stream(name).filter(Objects::nonNull).map(s -> Normalization.replaceColon(s, ".", " - ")).map(s -> FileUtilities.replacePathSeparators(s, " ")).map(s -> Normalization.normalizeQuotationMarks(s)).map(s -> Normalization.trimTrailingPunctuation(s)).map(s -> FileUtilities.validateFileName(s)).filter(s -> s.length() > 0).collect(Collectors.joining("/"));
    }

    private static String first(String ... options) {
        return Arrays.stream(options).filter(Objects::nonNull).findFirst().get();
    }

    public String getMovieFolder() {
        return "Movies";
    }

    public String getSeriesFolder() {
        return "TV Shows";
    }

    public String getAnimeFolder() {
        return "Anime";
    }

    public String getMusicFolder() {
        return "Music";
    }

    public String getSpecialFolder(Integer season) {
        return "Specials";
    }

    public String getSeasonFolder(Integer season) {
        return String.format("Season %02d", season == null ? 0 : season);
    }
}

