/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.util.Locale;
import java.util.function.Function;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.Resource;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.media.MetaAttributes;
import net.filebot.web.Episode;
import net.filebot.web.Movie;
import net.filebot.web.SimpleDate;

public class XattrMetaInfo {
    public static final XattrMetaInfo xattr = new XattrMetaInfo(Settings.useExtendedFileAttributes(), Settings.useCreationDate());
    private final boolean useExtendedFileAttributes;
    private final boolean useCreationDate;
    private final Cache xattrMetaInfoCache = Cache.getCache("net.filebot.metadata", CacheType.Ephemeral);
    private final Cache xattrOriginalNameCache = Cache.getCache("net.filebot.filename", CacheType.Ephemeral);

    public XattrMetaInfo(boolean useExtendedFileAttributes, boolean useCreationDate) {
        this.useExtendedFileAttributes = useExtendedFileAttributes;
        this.useCreationDate = useCreationDate;
    }

    public boolean isMetaInfo(Object object) {
        return object instanceof Episode || object instanceof Movie;
    }

    public long getTimeStamp(Object object) throws Exception {
        SimpleDate releaseDate;
        Movie movie;
        if (object instanceof Episode) {
            Episode episode = (Episode)object;
            if (episode.getAirdate() != null) {
                return episode.getAirdate().getTimeStamp();
            }
        } else if (object instanceof Movie && (movie = (Movie)object).getYear() > 0 && movie.getTmdbId() > 0 && (releaseDate = WebServices.TheMovieDB.getMovieInfo(movie, Locale.US, false).getReleased()) != null) {
            return releaseDate.getTimeStamp();
        }
        return -1L;
    }

    public synchronized Object getMetaInfo(File file) {
        return this.getXattrValue(this.xattrMetaInfoCache, file, MetaAttributes::getObject);
    }

    public synchronized String getOriginalName(File file) {
        return (String)this.getXattrValue(this.xattrOriginalNameCache, file, MetaAttributes::getOriginalName);
    }

    private Object getXattrValue(Cache cache, File file, Function<MetaAttributes, Object> compute) {
        if (!this.useExtendedFileAttributes) {
            return cache.get(file);
        }
        try {
            return cache.computeIfAbsent(file, element -> compute.apply(this.xattr(file)));
        }
        catch (Throwable e) {
            Logging.debug.warning(Logging.cause("Failed to read xattr", e));
            return null;
        }
    }

    private File writable(File f) throws Exception {
        if (!f.canWrite()) {
            if (f.setWritable(true)) {
                Logging.debug.fine(Logging.message("Grant write permissions", f));
            } else {
                Logging.debug.warning(Logging.message("Failed to grant write permissions", f));
            }
        }
        return f;
    }

    private MetaAttributes xattr(File f) throws Exception {
        return new MetaAttributes(f);
    }

    public synchronized void setMetaInfo(File file, Object model, String original) {
        if (!this.isMetaInfo(model) || !file.isFile()) {
            return;
        }
        Resource<MetaAttributes> xattr = Resource.lazy(() -> this.xattr(this.writable(file)));
        if (this.useCreationDate) {
            try {
                long t = this.getTimeStamp(model);
                if (t > 0L) {
                    xattr.get().setCreationDate(t);
                }
            }
            catch (Throwable e) {
                Logging.debug.warning(Logging.cause("Failed to set creation date", e));
            }
        }
        try {
            if (this.isMetaInfo(model)) {
                this.xattrMetaInfoCache.put(file, model);
                if (this.useExtendedFileAttributes) {
                    xattr.get().setObject(model);
                }
            }
            if (original != null && original.length() > 0 && this.getOriginalName(file) == null) {
                this.xattrOriginalNameCache.put(file, original);
                if (this.useExtendedFileAttributes) {
                    xattr.get().setOriginalName(original);
                }
            }
        }
        catch (Throwable e) {
            Logging.debug.warning(Logging.cause("Failed to set xattr", e));
        }
    }

    public synchronized void clear(File file) {
        this.xattrMetaInfoCache.remove(file);
        this.xattrOriginalNameCache.remove(file);
        if (this.useExtendedFileAttributes) {
            try {
                this.xattr(this.writable(file)).clear();
            }
            catch (Throwable e) {
                Logging.debug.warning(Logging.cause("Failed to clear xattr", e));
            }
        }
    }
}

