/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.platform.mac;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.UserFiles;
import net.filebot.media.MediaDetection;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.HeaderPanel;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.miginfocom.swing.MigLayout;

public class DropToUnlock
extends JList<File> {
    public static final Map<String, String> persistentSecurityScopedBookmarks = Settings.forPackage(DropToUnlock.class).node("SecurityScopedBookmarks").asMap();
    private final RoundRectangle2D dropArea = new RoundRectangle2D.Double(0.0, 0.0, 0.0, 0.0, 20.0, 20.0);
    private final BasicStroke dashedStroke = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f}, 0.0f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockBySecurityScopedBookmarks(List<File> folders) {
        Map<String, String> map = persistentSecurityScopedBookmarks;
        synchronized (map) {
            Set<String> bookmarks = persistentSecurityScopedBookmarks.keySet();
            for (File folder : folders) {
                Optional<File> bookmarkForFolder = FileUtilities.listPath(folder).stream().filter(f -> bookmarks.contains(f.getPath())).findFirst();
                if (!bookmarkForFolder.isPresent() || !MacAppUtilities.isLockedFolder(folder)) continue;
                try {
                    MacAppUtilities.NSURL_URLByResolvingBookmarkData_startAccessingSecurityScopedResource(persistentSecurityScopedBookmarks.get(bookmarkForFolder.get().getPath()));
                }
                catch (Throwable e) {
                    Logging.debug.severe("NSURL.URLByResolvingBookmarkData.startAccessingSecurityScopedResource: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSecurityScopedBookmarks(List<File> folders) {
        Map<String, String> map = persistentSecurityScopedBookmarks;
        synchronized (map) {
            Set<String> bookmarks = persistentSecurityScopedBookmarks.keySet();
            for (File folder : folders) {
                if (!Collections.disjoint(bookmarks, FileUtilities.listPath(folder)) || MacAppUtilities.isLockedFolder(folder)) continue;
                try {
                    String bookmarkData = MacAppUtilities.NSURL_bookmarkDataWithOptions(folder.getPath());
                    persistentSecurityScopedBookmarks.put(folder.getPath(), bookmarkData);
                }
                catch (Throwable e) {
                    Logging.debug.severe("NSURL.bookmarkDataWithOptions: " + e);
                }
            }
        }
    }

    public static List<File> getParentFolders(Collection<File> files) {
        return files.stream().map(f -> f.isDirectory() ? f : f.getParentFile()).sorted().distinct().filter(f -> !f.exists() || MacAppUtilities.isLockedFolder(f)).map(f -> {
            try {
                File file = f.getCanonicalFile();
                File root = MediaDetection.getStructureRoot(file);
                if (root == null || root.getParentFile() == null || root.getName().isEmpty()) {
                    for (File it : FileUtilities.listPathTail(file, Integer.MAX_VALUE, true)) {
                        if (!it.isDirectory()) continue;
                        return it;
                    }
                }
                return root;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(f -> f != null && !f.getName().isEmpty() && MacAppUtilities.isLockedFolder(f)).sorted().distinct().collect(Collectors.toList());
    }

    public static boolean showUnlockFoldersDialog(Window owner, Collection<File> files) {
        final List<File> model = DropToUnlock.getParentFolders(files);
        if (model.isEmpty()) {
            return true;
        }
        DropToUnlock.unlockBySecurityScopedBookmarks(model);
        if (model.stream().allMatch(f -> !MacAppUtilities.isLockedFolder(f))) {
            return true;
        }
        FutureTask<Boolean> showPermissionDialog = new FutureTask<Boolean>(() -> {
            final JDialog dialog = new JDialog(owner);
            final AtomicBoolean dialogCancelled = new AtomicBoolean(true);
            DropToUnlock d = new DropToUnlock(model){

                @Override
                public void updateLockStatus(File ... folders) {
                    super.updateLockStatus(folders);
                    if (model.stream().allMatch(f -> !MacAppUtilities.isLockedFolder(f))) {
                        dialogCancelled.set(false);
                        SwingUI.invokeLater(750, () -> dialog.setVisible(false));
                        SwingUI.invokeLater(1000, () -> Desktop.getDesktop().requestForeground(true));
                    } else {
                        model.stream().filter(f -> MacAppUtilities.isLockedFolder(f)).findFirst().ifPresent(f -> SwingUI.invokeLater(250, () -> UserFiles.revealFiles(Collections.singleton(f))));
                    }
                }
            };
            d.setBorder(BorderFactory.createEmptyBorder(5, 15, 120, 15));
            JComponent c = (JComponent)dialog.getContentPane();
            c.setLayout(new MigLayout("insets 0, fill"));
            HeaderPanel h = new HeaderPanel();
            h.getTitleLabel().setText("Folder Permissions Required");
            h.getTitleLabel().setIcon(ResourceManager.getIcon("file.lock"));
            h.getTitleLabel().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 64));
            JLabel help = new JLabel("<html>FileBot does not have permission to access the folder above. To allow FileBot access, drag and drop the folder from Finder onto the drop area above</b>. The permissions for this folder (and all the folders it contains) will be remembered and FileBot will not need to ask for it again.</html>");
            help.setBorder(BorderFactory.createCompoundBorder(new SeparatorBorder(1, new Color(0xB4B4B4), new Color(0xACACAC), GradientStyle.LEFT_TO_RIGHT, SeparatorBorder.Position.TOP), BorderFactory.createTitledBorder("About App Sandboxing")));
            c.add((Component)h, "wmin 150px, hmin 75px, growx, dock north");
            c.add((Component)d, "wmin 150px, hmin 150px, grow");
            c.add((Component)help, "wmin 150px, hmin 75px, growx, aligny center, dock south");
            dialog.setModal(true);
            dialog.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
            dialog.setSize(new Dimension(540, 500));
            dialog.setResizable(false);
            dialog.setLocationByPlatform(true);
            dialog.setAlwaysOnTop(true);
            SwingUI.invokeLater(500, () -> UserFiles.revealFiles(model));
            dialog.setVisible(true);
            return !dialogCancelled.get();
        });
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                showPermissionDialog.run();
            } else {
                SwingUtilities.invokeAndWait(showPermissionDialog);
            }
            if (((Boolean)showPermissionDialog.get()).booleanValue()) {
                DropToUnlock.storeSecurityScopedBookmarks(model);
                return true;
            }
            return false;
        }
        catch (InterruptedException | InvocationTargetException | ExecutionException e) {
            throw new RuntimeException("Failed to request permissions: " + e.getMessage(), e);
        }
    }

    public DropToUnlock(Collection<File> model) {
        super(model.toArray(new File[0]));
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.setCellRenderer(new FolderLockCellRenderer());
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new FileChooserAction());
        this.setTransferHandler(new DefaultTransferHandler(new FolderDropPolicy(), null));
    }

    public void updateLockStatus(File ... folder) {
        this.repaint();
        Stream.of(folder).filter(f -> MacAppUtilities.isLockedFolder(f)).forEach(f -> {
            try {
                String owner = Files.getOwner(f.toPath(), new LinkOption[0]).getName();
                String permissions = PosixFilePermissions.toString(Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]));
                Logging.log.log(Level.SEVERE, Logging.format("Permission denied: %s (%s %s)", f, permissions, owner));
            }
            catch (Exception e) {
                Logging.log.log(Level.SEVERE, e, Logging.format("Permission denied: %s", f));
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int w = 300;
        int h = 70;
        int pad = 20;
        g2d.setColor(Color.lightGray);
        this.dropArea.setFrameFromCenter(this.getWidth() / 2, this.getHeight() - h / 2 - pad - 10, (this.getWidth() - w) / 2, this.getHeight() - h - 2 * pad);
        g2d.setStroke(this.dashedStroke);
        g2d.draw(this.dropArea);
        g2d.setColor(Color.gray);
        g2d.setFont(g2d.getFont().deriveFont(2, 36.0f));
        g2d.drawString("Drop 'em", (int)this.dropArea.getMinX() + 15, (int)this.dropArea.getMinY() + 40);
        g2d.drawString("to Unlock 'em", (int)this.dropArea.getMinX() + 45, (int)this.dropArea.getMinY() + 40 + 35);
    }

    protected static class FileChooserAction
    extends MouseAdapter {
        protected FileChooserAction() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            File folder;
            int index;
            DropToUnlock list = (DropToUnlock)evt.getSource();
            if (evt.getClickCount() > 0 && (index = list.locationToIndex(evt.getPoint())) >= 0 && list.getCellBounds(index, index).contains(evt.getPoint()) && MacAppUtilities.isLockedFolder(folder = (File)list.getModel().getElementAt(index)) && null != UserFiles.showOpenDialogSelectFolder(folder, "Grant Permission", new ActionEvent(list, 1001, "Grant"))) {
                list.updateLockStatus(folder);
            }
        }
    }

    protected static class FolderLockCellRenderer
    extends DefaultListCellRenderer {
        protected FolderLockCellRenderer() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 100);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File folder = (File)value;
            JLabel c = (JLabel)super.getListCellRendererComponent(list, folder.getName(), index, false, false);
            c.setIcon(ResourceManager.getIcon(MacAppUtilities.isLockedFolder(folder) ? "folder.locked" : "folder.open"));
            c.setHorizontalTextPosition(0);
            c.setVerticalTextPosition(3);
            c.setToolTipText(folder.getAbsolutePath());
            return c;
        }
    }

    protected class FolderDropPolicy
    extends TransferablePolicy {
        protected FolderDropPolicy() {
        }

        @Override
        public boolean accept(Transferable tr) throws Exception {
            return true;
        }

        @Override
        public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
            List<File> folders;
            List<File> files = FileTransferable.getFilesFromTransferable(tr);
            if (files != null && (folders = FileUtilities.filter(files, FileUtilities.FOLDERS)).size() > 0) {
                DropToUnlock.this.updateLockStatus(folders.toArray(new File[0]));
            }
        }
    }
}

