/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.filebot.util.RegularExpressions;

public class CommonSequenceMatcher {
    protected final Collator collator;
    protected final int commonSequenceMaxStartIndex;
    protected final boolean returnFirstMatch;
    private final Map<String, CollationKey> collationKeyDictionary = Collections.synchronizedMap(new HashMap(256));

    public static Collator getLenientCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        collator.setDecomposition(2);
        collator.setStrength(0);
        return collator;
    }

    public CommonSequenceMatcher(Collator collator, int commonSequenceMaxStartIndex, boolean returnFirstMatch) {
        this.collator = collator;
        this.commonSequenceMaxStartIndex = commonSequenceMaxStartIndex;
        this.returnFirstMatch = returnFirstMatch;
    }

    public Collator getCollator() {
        return this.collator;
    }

    public String matchFirstCommonSequence(String ... names) {
        Comparable[][] words = new CollationKey[names.length][];
        for (int i = 0; i < names.length; ++i) {
            words[i] = this.split(names[i]);
        }
        return this.synth((CollationKey[])this.matchFirstCommonSequence(words));
    }

    public <E extends Comparable<E>> E[] matchFirstCommonSequence(E[][] names) {
        Object[] common = null;
        for (E[] words : names) {
            if (common == null) {
                common = words;
                continue;
            }
            if ((common = this.firstCommonSequence((Comparable[])common, (Comparable[])words, this.commonSequenceMaxStartIndex, this.returnFirstMatch)) != null) continue;
            return null;
        }
        return common;
    }

    protected String synth(CollationKey[] keys) {
        if (keys == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (CollationKey it : keys) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(it.getSourceString());
        }
        return sb.toString();
    }

    public CollationKey[] split(String sequence) {
        return this.getCollationKeys(RegularExpressions.SPACE.split(sequence));
    }

    protected CollationKey[] getCollationKeys(String[] words) {
        CollationKey[] keys = new CollationKey[words.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.collationKeyDictionary.get(words[i]);
            if (keys[i] != null) continue;
            keys[i] = this.collator.getCollationKey(words[i]);
            this.collationKeyDictionary.put(words[i], keys[i]);
        }
        return keys;
    }

    protected <E extends Comparable<E>> E[] firstCommonSequence(E[] seq1, E[] seq2, int maxStartIndex, boolean returnFirstMatch) {
        Comparable[] matchSeq = null;
        for (int i = 0; i < seq1.length && i <= maxStartIndex; ++i) {
            for (int j = 0; j < seq2.length && j <= maxStartIndex; ++j) {
                int len = 0;
                while (i + len < seq1.length && j + len < seq2.length && seq1[i + len].compareTo(seq2[j + len]) == 0) {
                    ++len;
                }
                if (len <= (matchSeq == null ? 0 : matchSeq.length)) continue;
                matchSeq = (Comparable[])Arrays.copyOfRange(seq1, i, i + len);
                if (!returnFirstMatch) continue;
                return matchSeq;
            }
        }
        return matchSeq;
    }
}

