/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.util.Map;
import java.util.TreeSet;
import net.filebot.format.PropertyBindings;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.similarity.StringEqualsMetric;

public class CrossPropertyMetric
implements SimilarityMetric {
    private SimilarityMetric metric;

    public CrossPropertyMetric(SimilarityMetric metric) {
        this.metric = metric;
    }

    public CrossPropertyMetric() {
        this.metric = new StringEqualsMetric();
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        Map<String, Object> m1 = this.getProperties(o1);
        if (m1.isEmpty()) {
            return 0.0f;
        }
        Map<String, Object> m2 = this.getProperties(o2);
        if (m2.isEmpty()) {
            return 0.0f;
        }
        TreeSet<String> keys = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        keys.addAll(m1.keySet());
        keys.retainAll(m2.keySet());
        if (keys.isEmpty()) {
            return 0.0f;
        }
        float feedback = 0.0f;
        for (String k : keys) {
            try {
                feedback += this.metric.getSimilarity(m1.get(k), m2.get(k));
            }
            catch (Exception exception) {}
        }
        return feedback / (float)keys.size();
    }

    protected Map<String, Object> getProperties(Object object) {
        return new PropertyBindings(object);
    }
}

