/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import net.filebot.similarity.DateMatcher;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.web.SimpleDate;

public class DateMetric
implements SimilarityMetric {
    private final DateMatcher matcher;

    public DateMetric(DateMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        SimpleDate d1 = this.parse(o1);
        if (d1 == null) {
            return 0.0f;
        }
        SimpleDate d2 = this.parse(o2);
        if (d2 == null) {
            return 0.0f;
        }
        return d1.equals(d2) ? 1.0f : -1.0f;
    }

    public SimpleDate parse(Object object) {
        if (object instanceof File) {
            return this.matcher.match((File)object);
        }
        return this.matcher.match(object.toString());
    }
}

