/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.filebot.media.SmartSeasonEpisodeMatcher;
import net.filebot.similarity.EpisodeMetrics;
import net.filebot.similarity.Match;
import net.filebot.similarity.Matcher;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.MultiEpisode;

public class EpisodeMatcher
extends Matcher<File, Object> {
    private final SeasonEpisodeMatcher seasonEpisodeMatcher = new SmartSeasonEpisodeMatcher(SeasonEpisodeMatcher.LENIENT_SANITY, false);
    private final Map<File, Set<SeasonEpisodeMatcher.SxE>> transformCache = Collections.synchronizedMap(new HashMap(64, 4.0f));

    public EpisodeMatcher(Collection<File> values, Collection<Episode> candidates, boolean strict) {
        super(values, candidates, strict, EpisodeMetrics.defaultSequence(false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void deepMatch(Collection<Match<File, Object>> possibleMatches, int level) throws InterruptedException {
        boolean bl;
        IdentityHashMap episodeSets = new IdentityHashMap();
        for (Match match : possibleMatches) {
            void var6_9;
            List list = (List)episodeSets.get(match.getValue());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                episodeSets.put((File)match.getValue(), arrayList);
            }
            var6_9.add((Episode)match.getCandidate());
        }
        IdentityHashMap episodeIdentifierSets = new IdentityHashMap();
        for (Map.Entry entry : episodeSets.entrySet()) {
            HashSet<SeasonEpisodeMatcher.SxE> hashSet = new HashSet<SeasonEpisodeMatcher.SxE>(((List)entry.getValue()).size());
            for (Episode ep : (List)entry.getValue()) {
                if (ep.getSpecial() == null) {
                    hashSet.add(new SeasonEpisodeMatcher.SxE(ep.getSeason(), ep.getEpisode()));
                    continue;
                }
                hashSet.add(new SeasonEpisodeMatcher.SxE(0, ep.getSpecial()));
            }
            episodeIdentifierSets.put((File)entry.getKey(), hashSet);
        }
        boolean bl2 = false;
        for (Match match : possibleMatches) {
            Episode[] episodeSequence;
            List episodes;
            Set<Integer> uniqueEpisodes;
            File file = (File)match.getValue();
            Set<Integer> uniqueFiles = this.normalizeIdentifierSet(this.parseEpisodeIdentifer(file));
            if (!uniqueFiles.equals(uniqueEpisodes = this.normalizeIdentifierSet((Set)episodeIdentifierSets.get(file))) || (episodes = (List)episodeSets.get(file)).size() <= 1 || !this.isMultiEpisode(episodeSequence = (Episode[])episodes.stream().sorted(EpisodeUtilities.episodeComparator()).distinct().toArray(Episode[]::new))) continue;
            MultiEpisode episode = new MultiEpisode(episodeSequence);
            this.disjointMatchCollection.add(new Match<File, MultiEpisode>(file, episode));
            bl = true;
        }
        if (bl) {
            this.removeCollected(possibleMatches);
        }
        super.deepMatch(possibleMatches, level);
    }

    private Set<SeasonEpisodeMatcher.SxE> parseEpisodeIdentifer(File file) {
        Set<SeasonEpisodeMatcher.SxE> result = this.transformCache.get(file);
        if (result != null) {
            return result;
        }
        List<SeasonEpisodeMatcher.SxE> sxe = this.seasonEpisodeMatcher.match(file.getName());
        result = sxe != null ? new HashSet<SeasonEpisodeMatcher.SxE>(sxe) : Collections.emptySet();
        this.transformCache.put(file, result);
        return result;
    }

    private Set<Integer> normalizeIdentifierSet(Set<SeasonEpisodeMatcher.SxE> numbers) {
        int limit = 100;
        for (SeasonEpisodeMatcher.SxE it : numbers) {
            while (it.season > 0 && it.episode >= limit) {
                limit *= 10;
            }
        }
        HashSet<Integer> identifier = new HashSet<Integer>(numbers.size());
        for (SeasonEpisodeMatcher.SxE it : numbers) {
            if (it.season > 0 && it.episode > 0 && it.episode < limit) {
                identifier.add(it.season * limit + it.episode);
                continue;
            }
            if (it.season > 0 || it.episode <= 0) continue;
            identifier.add(it.episode);
        }
        return identifier;
    }

    private boolean isMultiEpisode(Episode[] episodes) {
        if (episodes.length < 2) {
            return false;
        }
        Function<Episode, Integer> number = Arrays.stream(episodes).allMatch(e -> e.getSpecial() == null) ? e -> e.getEpisode() : e -> e.getSpecial();
        Integer seqIndex = null;
        for (Episode it : episodes) {
            Integer i = number.apply(it);
            if (i == null) {
                return false;
            }
            if (seqIndex != null && !i.equals(seqIndex + 1) && !i.equals(seqIndex)) {
                return false;
            }
            seqIndex = i;
        }
        return Arrays.stream(episodes).skip(1L).allMatch(e -> episodes[0].getSeriesName().equals(e.getSeriesName()));
    }
}

